/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hdfs.trans.analyzer;

import org.pentaho.big.data.kettle.plugins.hdfs.trans.HadoopFileInputMeta;
import org.pentaho.big.data.kettle.plugins.hdfs.trans.analyzer.HadoopBaseStepAnalyzer;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.analyzer.kettle.step.IClonableStepAnalyzer;

public class HadoopFileInputStepAnalyzer
extends HadoopBaseStepAnalyzer<HadoopFileInputMeta> {
    @Override
    public Class<HadoopFileInputMeta> getMetaClass() {
        return HadoopFileInputMeta.class;
    }

    public boolean isOutput() {
        return false;
    }

    public boolean isInput() {
        return true;
    }

    protected void customAnalyze(HadoopFileInputMeta meta, IMetaverseNode rootNode) throws MetaverseAnalyzerException {
        super.customAnalyze((BaseStepMeta)meta, rootNode);
        if (meta.isAcceptingFilenames()) {
            rootNode.setProperty("fileNameStep", (Object)meta.getAcceptingStepName());
            rootNode.setProperty("fileNameField", (Object)meta.getAcceptingField());
            rootNode.setProperty("passingThruFields", (Object)meta.inputFiles.passingThruFields);
        }
        rootNode.setProperty("fileType", (Object)meta.content.fileType);
        rootNode.setProperty("separator", (Object)meta.content.separator);
        rootNode.setProperty("enclosure", (Object)meta.content.enclosure);
        rootNode.setProperty("breakInEnclosureAllowed", (Object)meta.content.breakInEnclosureAllowed);
        rootNode.setProperty("escapeCharacter", (Object)meta.content.escapeCharacter);
        if (meta.content.header) {
            rootNode.setProperty("nrHeaderLines", (Object)meta.content.nrHeaderLines);
        }
        if (meta.content.footer) {
            rootNode.setProperty("nrFooterLines", (Object)meta.content.nrFooterLines);
        }
        if (meta.content.lineWrapped) {
            rootNode.setProperty("nrWraps", (Object)meta.content.nrWraps);
        }
        if (meta.content.layoutPaged) {
            rootNode.setProperty("nrLinesPerPage", (Object)meta.content.nrLinesPerPage);
            rootNode.setProperty("nrLinesDocHeader", (Object)meta.content.nrLinesDocHeader);
        }
        rootNode.setProperty("fileCompression", (Object)meta.content.fileCompression);
        rootNode.setProperty("noEmptyLines", (Object)meta.content.noEmptyLines);
        rootNode.setProperty("includeFilename", (Object)meta.content.includeFilename);
        if (meta.content.includeFilename) {
            rootNode.setProperty("filenameField", (Object)meta.content.filenameField);
        }
        rootNode.setProperty("includeRowNumber", (Object)meta.content.includeRowNumber);
        if (meta.content.includeFilename) {
            rootNode.setProperty("rowNumberField", (Object)meta.content.rowNumberField);
            rootNode.setProperty("rowNumberByFile", (Object)meta.content.rowNumberByFile);
        }
        rootNode.setProperty("fileFormat", (Object)meta.content.fileFormat);
        rootNode.setProperty("encoding", (Object)meta.content.encoding);
        rootNode.setProperty("rowLimit", (Object)Long.toString(meta.content.rowLimit));
        rootNode.setProperty("dateFormatLenient", (Object)meta.content.dateFormatLenient);
        rootNode.setProperty("dateFormatLocale", (Object)meta.content.dateFormatLocale);
        rootNode.setProperty("addFilenamesToResult", (Object)meta.inputFiles.isaddresult);
    }

    public IClonableStepAnalyzer newInstance() {
        return new HadoopFileInputStepAnalyzer();
    }
}

