/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swt.tags;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulToolbarbutton;
import org.pentaho.ui.xul.containers.XulToolbar;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swt.AbstractSwtXulContainer;
import org.pentaho.ui.xul.util.SwtXulUtil;
import org.pentaho.ui.xul.util.XulUtil;

public class SwtToolbarbutton
extends AbstractSwtXulContainer
implements XulToolbarbutton {
    private ToolItem button;
    private boolean disabled;
    private String image;
    private String downImage;
    private XulComponent parent;
    private XulDomContainer container;
    private String command;
    private static final Log logger = LogFactory.getLog(SwtToolbarbutton.class);
    private XulToolbar parentToolbar;
    private String label;
    private String type;

    public SwtToolbarbutton(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("toolbarbutton");
        this.parent = parent;
        this.container = domContainer;
        if (parent instanceof XulToolbar) {
            this.parentToolbar = (XulToolbar)parent;
        }
        if (this.parentToolbar != null) {
            this.createButton(self, parent);
        }
    }

    private void createButton(Element self, XulComponent parent) {
        if (this.button != null) {
            this.button.dispose();
        }
        int style = 131072;
        style = this.type != null && this.type.equals("toggle") || self.getAttributeValue("type") != null && self.getAttributeValue("type").equals("toggle") ? (style |= 0x10) : (style |= 8);
        this.button = new ToolItem((ToolBar)parent.getManagedObject(), style);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (SwtToolbarbutton.this.command != null) {
                    SwtToolbarbutton.this.invoke(SwtToolbarbutton.this.command);
                }
            }
        });
        this.setManagedObject(this.button);
    }

    @Override
    public void setMenu(final IMenuManager menu) {
        if (this.button != null && !this.button.isDisposed()) {
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    Rectangle rect = SwtToolbarbutton.this.button.getBounds();
                    Point pt = SwtToolbarbutton.this.button.getParent().toDisplay(new Point(rect.x, rect.y));
                    if (menu instanceof MenuManager) {
                        Menu swtMenu = ((MenuManager)menu).createContextMenu((Control)SwtToolbarbutton.this.button.getParent());
                        menu.update(true);
                        swtMenu.setLocation(pt.x, pt.y + rect.height);
                        swtMenu.setVisible(true);
                    }
                }
            });
        }
    }

    public void setMenu(final Menu menu) {
        if (this.button != null && !this.button.isDisposed()) {
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    Rectangle rect = SwtToolbarbutton.this.button.getBounds();
                    Point pt = SwtToolbarbutton.this.button.getParent().toDisplay(new Point(rect.x, rect.y));
                    menu.setLocation(pt.x, pt.y + rect.height);
                    menu.setVisible(true);
                }
            });
        }
    }

    @Override
    public void layout() {
        if (this.parentToolbar == null) {
            this.parentToolbar = (XulToolbar)this.getParent();
        }
        if (this.button == null) {
            this.createButton((Element)this, this.getParent());
            this.setLabel(this.getLabel());
            this.setImage(this.getImage());
            this.setDownimage(this.getDownimage());
            this.setDisabled(this.isDisabled());
            this.setTooltiptext(this.getTooltiptext());
        }
    }

    public String getDownimage() {
        return this.downImage;
    }

    public String getDownimagedisabled() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDownimage(String img) {
        this.downImage = img;
        if (img == null || this.button == null || this.button.isDisposed()) {
            return;
        }
        Display d = ((Composite)this.parent.getManagedObject()).getDisplay();
        if (d == null) {
            d = Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault();
        }
        InputStream in = null;
        try {
            in = XulUtil.loadResourceAsStream((String)img, (XulDomContainer)this.container);
            this.button.setHotImage(new Image((Device)((Composite)this.parent.getManagedObject()).getDisplay(), in));
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void setDownimagedisabled(String img) {
    }

    public void setSelected(boolean selected, boolean fireEvent) {
    }

    public void doClick() {
    }

    public String getDir() {
        return null;
    }

    public String getGroup() {
        return null;
    }

    public String getImage() {
        return this.image;
    }

    public String getLabel() {
        return this.label;
    }

    public String getOnclick() {
        return this.command;
    }

    public String getType() {
        return this.type;
    }

    public boolean isSelected() {
        return false;
    }

    public void setDir(String dir) {
    }

    public void setGroup(String group) {
    }

    public void setImageFromStream(InputStream in) {
        Display d = ((Composite)this.getParent().getManagedObject()).getDisplay();
        if (d == null) {
            Display display = d = Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault();
        }
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setImage(new Image((Device)d, in));
        }
    }

    public void setImage(Image img) {
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setImage(img);
        }
    }

    public void setImage(String src) {
        this.image = src;
        if (src == null) {
            return;
        }
        if (this.button == null || this.button.isDisposed()) {
            return;
        }
        if (!this.parentToolbar.getMode().equals("ICONS") && !this.parentToolbar.getMode().equals("FULL")) {
            return;
        }
        Display d = ((Composite)this.parentToolbar.getManagedObject()).getDisplay();
        if (d == null) {
            d = Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault();
        }
        Object in = null;
        Image img = SwtXulUtil.getCachedImage(src, this.container, d);
        this.button.setImage(img);
    }

    public void setLabel(String label) {
        this.label = label;
        if (this.button == null || this.button.isDisposed()) {
            return;
        }
        if (this.parentToolbar.getMode().equals("ICONS")) {
            return;
        }
        if (label != null) {
            this.button.setText(label);
        }
    }

    public void setOnclick(String method) {
        this.command = method;
    }

    public void setSelected(boolean selected) {
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setSelection(selected);
        }
    }

    public void setSelected(String selected) {
    }

    public void setType(String type) {
        this.type = type;
        if (this.initialized) {
            this.setTooltiptext(this.getTooltiptext());
            this.setDisabled(this.isDisabled());
            this.setImage(this.getImage());
            this.setDownimage(this.getDownimage());
            this.setDownimagedisabled(this.getDownimagedisabled());
            this.setLabel(this.getLabel());
            this.setOnclick(this.getOnclick());
        }
    }

    @Override
    public void setTooltiptext(String tooltip) {
        super.setTooltiptext(tooltip);
        if (this.button == null || this.button.isDisposed()) {
            return;
        }
        this.button.setToolTipText(tooltip);
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
        if (this.button != null && !this.button.isDisposed()) {
            this.button.setEnabled(!disabled);
        }
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }
}

