/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.sources.query;

import java.util.Collections;
import java.util.List;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.platform.dataaccess.datasource.beans.AutobeanUtilities;
import org.pentaho.platform.dataaccess.datasource.wizard.IDatasourceSummary;
import org.pentaho.platform.dataaccess.datasource.wizard.IWizardDatasource;
import org.pentaho.platform.dataaccess.datasource.wizard.IWizardStep;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.MessageHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceDTO;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceDTOUtil;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceModel;
import org.pentaho.platform.dataaccess.datasource.wizard.models.IWizardModel;
import org.pentaho.platform.dataaccess.datasource.wizard.service.IXulAsyncDSWDatasourceService;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.query.QueryPhysicalStep;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

public class QueryDatasource
extends AbstractXulEventHandler
implements IWizardDatasource {
    private boolean finishable;
    private QueryPhysicalStep queryStep;
    private DatasourceModel datasourceModel;
    private IXulAsyncDSWDatasourceService datasourceService;
    private IWizardModel wizardModel;

    public QueryDatasource(IXulAsyncDSWDatasourceService datasourceService, DatasourceModel datasourceModel) {
        this.datasourceModel = datasourceModel;
        this.datasourceService = datasourceService;
    }

    @Override
    public void activating() throws XulException {
        this.queryStep.activating();
    }

    @Override
    public void deactivating() {
        this.queryStep.deactivate();
    }

    @Override
    @Bindable
    public String getName() {
        return MessageHandler.getString("sql.datasource.name");
    }

    @Override
    public List<IWizardStep> getSteps() {
        return Collections.singletonList(this.queryStep);
    }

    @Override
    public void onFinish(XulServiceCallback<IDatasourceSummary> callback) {
        String name = this.datasourceModel.getDatasourceName().replace(".", "_").replace(" ", "_");
        String query = this.datasourceModel.getQuery();
        DatabaseConnection conn = (DatabaseConnection)AutobeanUtilities.connectionBeanToImpl(this.datasourceModel.getSelectedRelationalConnection());
        this.datasourceService.generateQueryDomain(name, query, conn, DatasourceDTOUtil.generateDTO(this.datasourceModel), callback);
    }

    @Override
    public void init(XulDomContainer container, IWizardModel wizardModel) throws XulException {
        this.wizardModel = wizardModel;
        this.queryStep = new QueryPhysicalStep(this.datasourceModel, this);
        container.addEventHandler((XulEventHandler)this.queryStep);
        this.queryStep.init(wizardModel);
    }

    @Override
    public String getId() {
        return "SQL-DS";
    }

    @Override
    @Bindable
    public boolean isFinishable() {
        return this.finishable;
    }

    @Override
    public void setFinishable(boolean finishable) {
        boolean prevFinishable = this.finishable;
        this.finishable = finishable;
        this.firePropertyChange("finishable", prevFinishable, finishable);
    }

    @Override
    public void restoreSavedDatasource(Domain previousDomain, final XulServiceCallback<Void> callback) {
        String serializedDatasource = (String)((LogicalModel)previousDomain.getLogicalModels().get(0)).getProperty("datasourceModel");
        this.datasourceService.deSerializeModelState(serializedDatasource, new XulServiceCallback<DatasourceDTO>(){

            public void success(DatasourceDTO datasourceDTO) {
                DatasourceDTO.populateModel(datasourceDTO, QueryDatasource.this.datasourceModel);
                QueryDatasource.this.datasourceModel.getGuiStateModel().setDirty(false);
                if (QueryDatasource.this.datasourceModel.getGuiStateModel().getConnections() == null || QueryDatasource.this.datasourceModel.getGuiStateModel().getConnections().size() <= 0) {
                    QueryDatasource.this.queryStep.reloadConnections();
                }
                QueryDatasource.this.wizardModel.setEditing(true);
                callback.success(null);
            }

            public void error(String s, Throwable throwable) {
                MessageHandler.getInstance().showErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("DatasourceEditor.ERROR_0002_UNABLE_TO_SHOW_DIALOG", throwable.getLocalizedMessage()));
                callback.error(s, throwable);
            }
        });
    }

    @Override
    public void reset() {
        this.datasourceModel.clearModel();
    }
}

