/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.sources.csv;

import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.platform.dataaccess.datasource.wizard.AbstractWizardStep;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.MessageHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.models.ColumnInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.models.CsvParseException;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceModel;
import org.pentaho.platform.dataaccess.datasource.wizard.models.IModelInfoValidationListener;
import org.pentaho.platform.dataaccess.datasource.wizard.models.IWizardModel;
import org.pentaho.platform.dataaccess.datasource.wizard.models.ModelInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.service.gwt.ICsvDatasourceServiceAsync;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.csv.CsvDatasource;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulEventSource;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingProvider;
import org.pentaho.ui.xul.binding.FactoryBasedBindingProvider;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulTreeCell;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulTreeItem;
import org.pentaho.ui.xul.containers.XulTreeRow;
import org.pentaho.ui.xul.stereotype.Bindable;

public class StageDataStep
extends AbstractWizardStep
implements IModelInfoValidationListener {
    private DatasourceModel datasourceModel;
    private ICsvDatasourceServiceAsync csvDatasourceService;
    private static final String MSG_STAGING_DATA = "physicalDatasourceDialog.STAGING_DATA";
    private static final String MSG_STAGING_FILE = "physicalDatasourceDialog.STAGING_FILE";
    private XulDialog errorDialog = null;
    private XulLabel errorLabel = null;
    private XulDialog successDialog = null;
    private XulLabel successLabel = null;
    private XulDialog previewDialog = null;
    private XulLabel previewLabel = null;

    public StageDataStep(DatasourceModel datasourceModel, CsvDatasource parentDatasource, ICsvDatasourceServiceAsync csvDatasourceService) {
        super(parentDatasource);
        this.datasourceModel = datasourceModel;
        this.csvDatasourceService = csvDatasourceService;
    }

    @Override
    public String getStepName() {
        return MessageHandler.getString("wizardStepName.STAGE");
    }

    @Override
    public void setBindings() {
    }

    @Override
    public XulComponent getUIComponent() {
        return this.document.getElementById("stagedatastep");
    }

    @Override
    public void init(IWizardModel wizardModel) throws XulException {
        super.init(wizardModel);
        this.errorDialog = (XulDialog)this.document.getElementById("errorDialog");
        this.errorLabel = (XulLabel)this.document.getElementById("errorLabel");
        this.successDialog = (XulDialog)this.document.getElementById("successDialog");
        this.successLabel = (XulLabel)this.document.getElementById("successLabel");
        this.previewDialog = (XulDialog)this.document.getElementById("csvPreviewDialog");
        this.previewLabel = (XulLabel)this.document.getElementById("csvTextPreviewLabel");
        this.datasourceModel.getModelInfo().addModelInfoValidationListener(this);
    }

    @Override
    public void stepActivatingForward() {
        this.setStepImageVisible(true);
        this.showWaitingFileStageDialog();
        this.loadColumnData(this.datasourceModel.getModelInfo().getFileInfo().getTmpFilename());
    }

    @Override
    public void stepActivatingReverse() {
        this.setStepImageVisible(true);
    }

    private void loadColumnData(String selectedFile) {
        String encoding = this.datasourceModel.getModelInfo().getFileInfo().getEncoding();
        try {
            this.clearColumnGrid();
        }
        catch (XulException e) {
            e.printStackTrace();
        }
        if (this.datasourceModel.getGuiStateModel().isDirty()) {
            this.csvDatasourceService.stageFile(selectedFile, this.datasourceModel.getModelInfo().getFileInfo().getDelimiter(), this.datasourceModel.getModelInfo().getFileInfo().getEnclosure(), this.datasourceModel.getModelInfo().getFileInfo().getHeaderRows() > 0, encoding, new StageFileCallback());
        } else {
            this.refreshColumnGrid();
            this.closeWaitingDialog();
        }
    }

    @Override
    public void onCsvValid() {
    }

    @Override
    public void onCsvInValid() {
    }

    @Override
    public void onModelInfoValid() {
        this.parentDatasource.setFinishable(true);
    }

    @Override
    public void onModelInfoInvalid() {
        this.parentDatasource.setFinishable(false);
    }

    @Override
    public boolean stepDeactivatingForward() {
        super.stepDeactivatingForward();
        return true;
    }

    @Override
    public boolean stepDeactivatingReverse() {
        this.setStepImageVisible(false);
        return true;
    }

    @Bindable
    public void closePreviewDialog() {
        this.previewDialog.hide();
    }

    @Bindable
    public void showPreviewDialog() throws Exception {
        this.previewLabel.setValue(this.datasourceModel.getModelInfo().getFileInfo().formatSampleContents());
        this.previewDialog.show();
    }

    public void clearColumnGrid() throws XulException {
        XulTree tree = (XulTree)this.document.getElementById("csvModelDataTable");
        tree.setElements(null);
        tree.update();
    }

    @Bindable
    public void refreshColumnGrid() {
        this.generateDataTypeDisplay_horizontal();
    }

    private void generateDataTypeDisplay_horizontal() {
        XulTree tree = (XulTree)this.document.getElementById("csvModelDataTable");
        tree.setRows(this.datasourceModel.getModelInfo().getColumns().length);
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        tree.setBindingProvider((BindingProvider)new FactoryBasedBindingProvider(this.bf){

            public BindingConvertor getConvertor(XulEventSource source, String prop1, XulEventSource target, String prop2) {
                if (source instanceof ColumnInfo) {
                    if (prop1.equals("length") || prop1.equals("precision")) {
                        return BindingConvertor.integer2String();
                    }
                    if (prop1.equals("include") && prop2.equals("value")) {
                        return null;
                    }
                    if (prop1.equals("include")) {
                        return BindingConvertor.boolean2String();
                    }
                    if (prop1.equals("availableDataTypes")) {
                        return new BindingConvertor<List, Vector>(){

                            public Vector sourceToTarget(List value) {
                                return new Vector(value);
                            }

                            public List targetToSource(Vector value) {
                                return new ArrayList(value);
                            }
                        };
                    }
                    if (prop1.equals("formatStrings")) {
                        return new BindingConvertor<List, Vector>(){

                            public Vector sourceToTarget(List value) {
                                return new Vector(value);
                            }

                            public List targetToSource(Vector value) {
                                return new ArrayList(value);
                            }
                        };
                    }
                    if (prop1.equals("dataType") && prop2.equals("selectedIndex")) {
                        return new BindingConvertor<DataType, Integer>(){

                            public Integer sourceToTarget(DataType value) {
                                List<DataType> types = ColumnInfo.getAvailableDataTypes();
                                for (int i = 0; i < types.size(); ++i) {
                                    if (!types.get(i).equals((Object)value)) continue;
                                    return i;
                                }
                                return 0;
                            }

                            public DataType targetToSource(Integer value) {
                                return ColumnInfo.getAvailableDataTypes().get(value);
                            }
                        };
                    }
                    if (prop1.equals("formatStringsDisabled")) {
                        return null;
                    }
                    return BindingConvertor.string2String();
                }
                return null;
            }
        });
        tree.setElements(Arrays.asList(this.datasourceModel.getModelInfo().getColumns()));
        if (this.datasourceModel.getModelInfo().getColumns().length > 0) {
            tree.setSelectedRows(new int[]{0});
        }
        tree.update();
    }

    @Bindable
    public void selectAll() {
        XulTree tree = (XulTree)this.document.getElementById("csvModelDataTable");
        for (XulComponent component : tree.getRootChildren().getChildNodes()) {
            XulTreeItem item = (XulTreeItem)component;
            for (XulComponent childComp : item.getChildNodes()) {
                XulTreeRow row = (XulTreeRow)childComp;
                XulTreeCell cell = row.getCell(0);
                cell.setValue((Object)true);
            }
        }
        this.datasourceModel.getModelInfo().validate();
    }

    @Bindable
    public void deselectAll() {
        XulTree tree = (XulTree)this.document.getElementById("csvModelDataTable");
        for (XulComponent component : tree.getRootChildren().getChildNodes()) {
            XulTreeItem item = (XulTreeItem)component;
            for (XulComponent childComp : item.getChildNodes()) {
                XulTreeRow row = (XulTreeRow)childComp;
                XulTreeCell cell = row.getCell(0);
                cell.setValue((Object)false);
            }
        }
        this.datasourceModel.getModelInfo().validate();
    }

    public String getName() {
        return "stageDataController";
    }

    @Bindable
    public void closeErrorDialog() {
        this.errorDialog.hide();
    }

    public void showErrorDialog(String message) {
        this.errorLabel.setValue(message);
        this.errorDialog.show();
    }

    public void closeWaitingDialog() {
        MessageHandler.getInstance().closeWaitingDialog();
    }

    public void showWaitingDataStageDialog() {
        MessageHandler.getInstance().showWaitingDialog(MessageHandler.getString(MSG_STAGING_DATA));
    }

    public void showWaitingFileStageDialog() {
        MessageHandler.getInstance().showWaitingDialog(MessageHandler.getString(MSG_STAGING_FILE));
    }

    @Bindable
    public void closeSuccessDialog() {
        this.successDialog.hide();
    }

    public void showSuccessDialog(String message) {
        this.successLabel.setValue(message);
        this.successDialog.show();
    }

    @Override
    public void refresh() {
    }

    public class StageFileCallback
    implements AsyncCallback<ModelInfo> {
        public void onSuccess(ModelInfo aModelInfo) {
            StageDataStep.this.datasourceModel.getModelInfo().setColumns(aModelInfo.getColumns());
            StageDataStep.this.datasourceModel.getModelInfo().setData(aModelInfo.getData());
            StageDataStep.this.datasourceModel.getModelInfo().getFileInfo().setEncoding(aModelInfo.getFileInfo().getEncoding());
            StageDataStep.this.refreshColumnGrid();
            StageDataStep.this.closeWaitingDialog();
            StageDataStep.this.parentDatasource.setFinishable(true);
        }

        public void onFailure(Throwable caught) {
            StageDataStep.this.closeWaitingDialog();
            StageDataStep.this.parentDatasource.setFinishable(false);
            if (caught instanceof CsvParseException) {
                CsvParseException e = (CsvParseException)caught;
                StageDataStep.this.showErrorDialog(MessageHandler.getString(caught.getMessage(), String.valueOf(e.getLineNumber()), e.getOffendingLine()));
            } else {
                StageDataStep.this.showErrorDialog(caught.getMessage());
            }
        }
    }
}

