/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils;

import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.geo.GeoContextConfigProvider;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class GeoContextSettingsProvider
implements GeoContextConfigProvider {
    private String settingsFile;

    public GeoContextSettingsProvider(String settingsFile) {
        this.settingsFile = settingsFile;
    }

    public String getDimensionName() throws ModelerException {
        return PentahoSystem.getSystemSetting((String)this.settingsFile, (String)"geo/dimension-name", null);
    }

    public String getRoles() throws ModelerException {
        return PentahoSystem.getSystemSetting((String)this.settingsFile, (String)"geo/roles", null);
    }

    public String getRoleAliases(String roleName) throws ModelerException {
        String aliasKey = "geo/" + roleName + "/aliases";
        String aliases = PentahoSystem.getSystemSetting((String)this.settingsFile, (String)aliasKey, null);
        if (aliases == null || aliases.trim().length() == 0) {
            throw new ModelerException("Error while building GeoContext: No Aliases found for role  " + roleName + ". Make sure there is a " + aliasKey + " element defined");
        }
        return aliases;
    }

    public String getRoleRequirements(String roleName) throws ModelerException {
        String key = "geo/" + roleName + "/required-parents";
        return PentahoSystem.getSystemSetting((String)this.settingsFile, (String)key, null);
    }
}

