/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.agilebi.modeler.geo.GeoContext;
import org.pentaho.agilebi.modeler.gwt.BogoPojo;
import org.pentaho.agilebi.modeler.util.MultiTableModelerSource;
import org.pentaho.database.dialect.PDIDialect;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.util.DatabaseUtil;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.concept.Concept;
import org.pentaho.metadata.model.concept.security.Security;
import org.pentaho.metadata.model.concept.security.SecurityOwner;
import org.pentaho.platform.dataaccess.datasource.utils.DataAccessPermissionUtil;
import org.pentaho.platform.dataaccess.datasource.wizard.IDatasourceSummary;
import org.pentaho.platform.dataaccess.datasource.wizard.service.ConnectionServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.DatasourceServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.gwt.IGwtJoinSelectionService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.ConnectionServiceImpl;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.DSWDatasourceServiceImpl;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.ModelerService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.MultiTableDatasourceDTO;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils.ConnectionServiceHelper;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils.LegacyDatasourceConverter;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.query.QueryDatasourceSummary;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;

public class MultitableDatasourceService
extends PentahoBase
implements IGwtJoinSelectionService {
    private DatabaseMeta databaseMeta;
    private ConnectionServiceImpl connectionServiceImpl;
    private Log logger = LogFactory.getLog(MultitableDatasourceService.class);

    public MultitableDatasourceService() {
        this.connectionServiceImpl = new ConnectionServiceImpl();
        this.init();
    }

    public MultitableDatasourceService(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
        this.init();
    }

    protected void init() {
    }

    private boolean isDataServicesConnection(IDatabaseConnection connection) {
        return connection.getDatabaseType().getName().equals(new PDIDialect().getDatabaseType().getName());
    }

    private DatabaseMeta getDatabaseMeta(IDatabaseConnection connection) throws ConnectionServiceException {
        if (this.connectionServiceImpl == null) {
            return this.databaseMeta;
        }
        connection = this.connectionServiceImpl.getConnectionByName(connection.getName(), false);
        connection.setPassword(ConnectionServiceHelper.getConnectionPassword(connection.getName(), connection.getPassword()));
        DatabaseMeta dbmeta = DatabaseUtil.convertToDatabaseMeta((IDatabaseConnection)connection);
        dbmeta.getDatabaseInterface().setQuoteAllFields(true);
        return dbmeta;
    }

    @Override
    public List<String> retrieveSchemas(IDatabaseConnection connection) throws DatasourceServiceException {
        ArrayList<String> schemas = new ArrayList<String>();
        try {
            DatabaseMeta databaseMeta = this.getDatabaseMeta(connection);
            Database database = new Database(null, databaseMeta);
            database.connect();
            Map tableMap = database.getTableMap(null, (Map)(this.isDataServicesConnection(connection) ? new HashMap<String, String>(){
                {
                    this.put("STREAMING", "N");
                }
            } : null));
            Set schemaNames = tableMap.keySet();
            schemas.addAll(schemaNames);
            database.disconnect();
        }
        catch (KettleDatabaseException e) {
            this.logger.error((Object)"Error creating database object", (Throwable)e);
            throw new DatasourceServiceException(e);
        }
        catch (ConnectionServiceException e) {
            this.logger.error((Object)"Error getting database meta", (Throwable)e);
            throw new DatasourceServiceException(e);
        }
        return schemas;
    }

    @Override
    public List<String> getDatabaseTables(IDatabaseConnection connection, String schema) throws DatasourceServiceException {
        try {
            DatabaseMeta databaseMeta = this.getDatabaseMeta(connection);
            Database database = new Database(null, databaseMeta);
            database.connect();
            String[] tableNames = database.getTablenames(schema, true, (Map)(this.isDataServicesConnection(connection) ? new HashMap<String, String>(){
                {
                    this.put("STREAMING", "N");
                }
            } : null));
            ArrayList<String> tables = new ArrayList<String>();
            tables.addAll(Arrays.asList(tableNames));
            tables.addAll(Arrays.asList(database.getViews(schema, true)));
            database.disconnect();
            return tables;
        }
        catch (KettleDatabaseException e) {
            this.logger.error((Object)"Error creating database object", (Throwable)e);
            throw new DatasourceServiceException(e);
        }
        catch (ConnectionServiceException e) {
            this.logger.error((Object)"Error getting database meta", (Throwable)e);
            throw new DatasourceServiceException(e);
        }
    }

    @Override
    public IDatasourceSummary serializeJoins(MultiTableDatasourceDTO dto, IDatabaseConnection connection) throws DatasourceServiceException {
        try {
            ModelerService modelerService = new ModelerService();
            modelerService.initKettle();
            DSWDatasourceServiceImpl datasourceService = new DSWDatasourceServiceImpl();
            GeoContext geoContext = datasourceService.getGeoContext();
            DatabaseMeta databaseMeta = this.getDatabaseMeta(connection);
            MultiTableModelerSource multiTable = new MultiTableModelerSource(databaseMeta, dto.getSchemaModel(), dto.getDatasourceName(), dto.getSelectedTables(), geoContext);
            Domain domain = multiTable.generateDomain(dto.isDoOlap());
            String modelState = this.serializeModelState(dto);
            for (LogicalModel lm : domain.getLogicalModels()) {
                lm.setProperty("datasourceModel", (Object)modelState);
                lm.setProperty("DatasourceType", (Object)"MULTI-TABLE-DS");
                this.applySecurity(lm);
            }
            modelerService.serializeModels(domain, dto.getDatasourceName(), dto.isDoOlap());
            QueryDatasourceSummary summary = new QueryDatasourceSummary();
            summary.setDomain(domain);
            return summary;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error serializing joins", (Throwable)e);
            throw new DatasourceServiceException(e);
        }
    }

    private String serializeModelState(MultiTableDatasourceDTO dto) throws DatasourceServiceException {
        XStream xs = new XStream();
        return xs.toXML((Object)dto);
    }

    @Override
    public MultiTableDatasourceDTO deSerializeModelState(String dtoStr) throws DatasourceServiceException {
        try {
            XStream xs = new XStream();
            xs.registerConverter((Converter)new LegacyDatasourceConverter());
            return (MultiTableDatasourceDTO)xs.fromXML(dtoStr);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            throw new DatasourceServiceException(e);
        }
    }

    private static String[] getSchemaTablePair(DatabaseMeta db, String table) {
        if (table.indexOf(".") < 0) {
            return new String[]{"", table};
        }
        String[] pair = new String[2];
        String[] parts = table.split("\\.");
        pair[0] = parts[0];
        String tableName = "";
        for (int i = 1; i < parts.length; ++i) {
            tableName = tableName + "." + parts[i];
        }
        pair[1] = tableName.substring(1);
        pair[0] = pair[0].replaceAll(db.getStartQuote(), "");
        pair[0] = pair[0].replaceAll(db.getEndQuote(), "");
        pair[1] = pair[1].replaceAll(db.getStartQuote(), "");
        pair[1] = pair[1].replaceAll(db.getEndQuote(), "");
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getTableFields(String table, IDatabaseConnection connection) throws DatasourceServiceException {
        ArrayList<String> arrayList;
        DatabaseMeta databaseMeta = this.getDatabaseMeta(connection);
        Database database = new Database(null, databaseMeta);
        try {
            database.connect();
            String[] schemaTablePair = MultitableDatasourceService.getSchemaTablePair(databaseMeta, table);
            RowMetaInterface fieldsMeta = database.getTableFieldsMeta(schemaTablePair[0], schemaTablePair[1]);
            ArrayList<String> fields = new ArrayList<String>();
            for (int i = fieldsMeta.size() - 1; i >= 0; --i) {
                ValueMetaInterface field = fieldsMeta.getValueMeta(i);
                fields.add(field.getName());
            }
            arrayList = fields;
        }
        catch (Throwable throwable) {
            try {
                database.disconnect();
                throw throwable;
            }
            catch (KettleDatabaseException e) {
                this.logger.error((Object)e);
                throw new DatasourceServiceException(e);
            }
            catch (ConnectionServiceException e) {
                this.logger.error((Object)e);
                throw new DatasourceServiceException(e);
            }
        }
        database.disconnect();
        return arrayList;
    }

    @Override
    public BogoPojo gwtWorkaround(BogoPojo pojo) {
        return pojo;
    }

    public Log getLogger() {
        return null;
    }

    protected boolean hasDataAccessViewPermission() {
        return DataAccessPermissionUtil.hasViewAccess();
    }

    protected List<String> getPermittedRoleList() {
        return DataAccessPermissionUtil.getPermittedViewRoleList();
    }

    protected List<String> getPermittedUserList() {
        return DataAccessPermissionUtil.getPermittedViewUserList();
    }

    protected int getDefaultAcls() {
        return DataAccessPermissionUtil.getDataAccessViewPermissionHandler().getDefaultAcls(PentahoSessionHolder.getSession());
    }

    protected boolean isSecurityEnabled() {
        Boolean securityEnabled = this.getPermittedRoleList() != null && this.getPermittedRoleList().size() > 0 || this.getPermittedUserList() != null && this.getPermittedUserList().size() > 0;
        return securityEnabled;
    }

    protected void applySecurity(LogicalModel logicalModel) {
        if (this.isSecurityEnabled()) {
            SecurityOwner owner;
            Security security = new Security();
            for (String user : this.getEffectivePermittedUserList(this.isSecurityEnabled())) {
                owner = new SecurityOwner(SecurityOwner.OwnerType.USER, user);
                security.putOwnerRights(owner, this.getDefaultAcls());
            }
            for (String role : this.getPermittedRoleList()) {
                owner = new SecurityOwner(SecurityOwner.OwnerType.ROLE, role);
                security.putOwnerRights(owner, this.getDefaultAcls());
            }
            logicalModel.setProperty(Concept.SECURITY_PROPERTY, (Object)security);
        }
    }

    private List<String> getEffectivePermittedUserList(boolean securityEnabled) {
        ArrayList<String> permittedUserList;
        ArrayList<String> arrayList = permittedUserList = this.getPermittedUserList() == null ? new ArrayList<String>() : new ArrayList<String>(this.getPermittedUserList());
        if (securityEnabled && !permittedUserList.contains(PentahoSessionHolder.getSession().getName())) {
            permittedUserList.add(PentahoSessionHolder.getSession().getName());
        }
        return permittedUserList;
    }
}

