/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.pentaho.agilebi.modeler.IModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.geo.GeoContext;
import org.pentaho.agilebi.modeler.gwt.GwtModelerWorkspaceHelper;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.IPhysicalModel;
import org.pentaho.metadata.model.InlineEtlPhysicalModel;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.SqlPhysicalModel;
import org.pentaho.metadata.model.SqlPhysicalTable;
import org.pentaho.metadata.model.concept.types.LocaleType;
import org.pentaho.metadata.repository.DomainAlreadyExistsException;
import org.pentaho.metadata.repository.DomainIdNullException;
import org.pentaho.metadata.repository.DomainStorageException;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.metadata.util.SQLModelGenerator;
import org.pentaho.metadata.util.SQLModelGeneratorException;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.dataaccess.datasource.beans.BogoPojo;
import org.pentaho.platform.dataaccess.datasource.beans.BusinessData;
import org.pentaho.platform.dataaccess.datasource.beans.LogicalModelSummary;
import org.pentaho.platform.dataaccess.datasource.beans.SerializedResultSet;
import org.pentaho.platform.dataaccess.datasource.utils.DataAccessPermissionUtil;
import org.pentaho.platform.dataaccess.datasource.wizard.csv.FileUtils;
import org.pentaho.platform.dataaccess.datasource.wizard.models.CsvFileInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.models.CsvTransformGeneratorException;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceDTO;
import org.pentaho.platform.dataaccess.datasource.wizard.service.ConnectionServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.DatasourceServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.QueryValidationException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.SqlQueriesNotSupportedException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.agile.AgileHelper;
import org.pentaho.platform.dataaccess.datasource.wizard.service.agile.CsvTransformGenerator;
import org.pentaho.platform.dataaccess.datasource.wizard.service.gwt.IDSWDatasourceService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.ConnectionServiceImpl;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.CsvDatasourceServiceImpl;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.ModelerService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils.DatasourceServiceHelper;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils.UtilHtmlSanitizer;
import org.pentaho.platform.dataaccess.datasource.wizard.service.messages.Messages;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.query.QueryDatasourceSummary;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.PentahoConnectionFactory;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalogServiceException;
import org.pentaho.platform.plugin.services.connections.sql.SQLConnection;
import org.pentaho.platform.uifoundation.component.xml.PMDUIComponent;
import org.pentaho.platform.util.logging.SimpleLogger;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.web.SimpleUrlFactory;

public class DSWDatasourceServiceImpl
implements IDSWDatasourceService {
    private static final Log logger = LogFactory.getLog(DSWDatasourceServiceImpl.class);
    protected static final String LM_PROP_DATASOURCE_TYPE = "DatasourceType";
    protected static final String LM_PROP_MONDRIAN_CATALOG_REF = "MondrianCatalogRef";
    protected static final String LM_PROP_DATASOURCE_MODEL = "datasourceModel";
    protected static final String LM_PROP_VISIBLE = "visible";
    private static final String DB_TYPE_ID_PENTAHO_DATA_SERVICE = "Pentaho Data Services";
    private IMetadataDomainRepository metadataDomainRepository = (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class, null);
    private static final String BEFORE_QUERY = " SELECT * FROM (";
    private static final String AFTER_QUERY = ") tbl";
    private GeoContext geoContext;
    private ConnectionServiceImpl connService;

    public DSWDatasourceServiceImpl() {
        this(new ConnectionServiceImpl());
    }

    public DSWDatasourceServiceImpl(ConnectionServiceImpl connService) {
        this.connService = connService;
    }

    protected boolean hasDataAccessPermission() {
        return DataAccessPermissionUtil.hasManageAccess();
    }

    protected boolean hasDataAccessViewPermission() {
        return DataAccessPermissionUtil.hasViewAccess();
    }

    protected List<String> getPermittedRoleList() {
        return DataAccessPermissionUtil.getPermittedViewRoleList();
    }

    protected List<String> getPermittedUserList() {
        return DataAccessPermissionUtil.getPermittedViewUserList();
    }

    protected int getDefaultAcls() {
        return DataAccessPermissionUtil.getDataAccessViewPermissionHandler().getDefaultAcls(PentahoSessionHolder.getSession());
    }

    protected ModelerWorkspace createModelerWorkspace() {
        return new ModelerWorkspace((IModelerWorkspaceHelper)new GwtModelerWorkspaceHelper());
    }

    protected ModelerService createModelerService() {
        return new ModelerService();
    }

    @Override
    public boolean deleteLogicalModel(String domainId, String modelName) throws DatasourceServiceException {
        if (!this.hasDataAccessPermission()) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0001_PERMISSION_DENIED"));
            return false;
        }
        String catalogRef = null;
        String targetTable = null;
        try {
            IMondrianCatalogService service;
            LogicalModel logicalModelRep;
            Domain domain = this.getMetadataDomainRepository().getDomain(domainId);
            ModelerWorkspace model = this.createModelerWorkspace();
            model.setDomain(domain);
            LogicalModel logicalModel = model.getLogicalModel(ModelerPerspective.ANALYSIS);
            if (logicalModel == null) {
                logicalModel = model.getLogicalModel(ModelerPerspective.REPORTING);
            }
            if ((logicalModelRep = model.getLogicalModel(ModelerPerspective.REPORTING)) != null) {
                String modelState = (String)logicalModelRep.getProperty(LM_PROP_DATASOURCE_MODEL);
                if ("CSV".equals(logicalModelRep.getProperty(LM_PROP_DATASOURCE_TYPE)) || "true".equalsIgnoreCase((String)logicalModelRep.getProperty("target_table_staged"))) {
                    targetTable = ((SqlPhysicalTable)((IPhysicalModel)domain.getPhysicalModels().get(0)).getPhysicalTables().get(0)).getTargetTable();
                    DatasourceDTO datasource = null;
                    if (modelState != null) {
                        datasource = this.deSerializeModelState(modelState);
                    }
                    if (datasource != null) {
                        CsvTransformGenerator csvTransformGenerator = new CsvTransformGenerator(datasource.getCsvModelInfo(), AgileHelper.getDatabaseMeta());
                        try {
                            csvTransformGenerator.dropTable(targetTable);
                        }
                        catch (CsvTransformGeneratorException e) {
                            logger.warn((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0019_UNABLE_TO_DROP_TABLE", targetTable, domainId, e.getLocalizedMessage()), (Throwable)e);
                        }
                        String fileName = datasource.getCsvModelInfo().getFileInfo().getFilename();
                        FileUtils fileService = new FileUtils();
                        if (fileName != null) {
                            fileService.deleteFile(fileName);
                        }
                    }
                }
            }
            if (logicalModel.getProperty(LM_PROP_MONDRIAN_CATALOG_REF) != null && (service = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, null)).getCatalog(catalogRef = (String)logicalModel.getProperty(LM_PROP_MONDRIAN_CATALOG_REF), PentahoSessionHolder.getSession()) != null) {
                service.removeCatalog(catalogRef, PentahoSessionHolder.getSession());
            }
            this.getMetadataDomainRepository().removeModel(domainId, logicalModel.getId());
            if (logicalModelRep != null && !logicalModelRep.getId().equals(logicalModel.getId())) {
                this.getMetadataDomainRepository().removeModel(domainId, logicalModelRep.getId());
            }
            if ((domain = this.getMetadataDomainRepository().getDomain(domainId)) == null) {
                return true;
            }
            if (domain.getLogicalModels() == null || domain.getLogicalModels().isEmpty()) {
                this.getMetadataDomainRepository().removeDomain(domainId);
            }
        }
        catch (MondrianCatalogServiceException me) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0020_UNABLE_TO_DELETE_CATALOG", catalogRef, domainId, me.getLocalizedMessage()), (Throwable)me);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0020_UNABLE_TO_DELETE_CATALOG", catalogRef, domainId, me.getLocalizedMessage()), me);
        }
        catch (DomainStorageException dse) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0017_UNABLE_TO_STORE_DOMAIN", domainId, dse.getLocalizedMessage()), (Throwable)dse);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0016_UNABLE_TO_STORE_DOMAIN", domainId, dse.getLocalizedMessage()), dse);
        }
        catch (DomainIdNullException dne) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0019_DOMAIN_IS_NULL", dne.getLocalizedMessage()), (Throwable)dne);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0019_DOMAIN_IS_NULL", dne.getLocalizedMessage()), dne);
        }
        return true;
    }

    IPentahoResultSet executeQuery(String connectionName, String query, String previewLimit) throws QueryValidationException, SqlQueriesNotSupportedException {
        try (SQLConnection sqlConnection = null;){
            this.checkSqlQueriesSupported(connectionName);
            int limit = previewLimit != null && previewLimit.length() > 0 ? Integer.parseInt(previewLimit) : -1;
            sqlConnection = (SQLConnection)PentahoConnectionFactory.getConnection((String)"SQL", (String)connectionName, (IPentahoSession)PentahoSessionHolder.getSession(), (ILogger)new SimpleLogger(DatasourceServiceHelper.class.getName()));
            sqlConnection.setMaxRows(limit);
            sqlConnection.setReadOnly(true);
            IPentahoResultSet iPentahoResultSet = sqlConnection.executeQuery(BEFORE_QUERY + query + AFTER_QUERY);
            return iPentahoResultSet;
        }
    }

    void checkSqlQueriesSupported(String connName) throws ConnectionServiceException, SqlQueriesNotSupportedException {
        IDatabaseConnection conn = this.connService.getConnectionByName(connName);
        IDatabaseType dbType = conn.getDatabaseType();
        if (dbType.getName().equals(DB_TYPE_ID_PENTAHO_DATA_SERVICE)) {
            throw new SqlQueriesNotSupportedException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0024_SQL_QUERIES_NOT_SUPPORTED_FOR_PENTAHO_DATA_SERVICE"));
        }
    }

    @Override
    public SerializedResultSet doPreview(String connectionName, String query, String previewLimit) throws DatasourceServiceException {
        SerializedResultSet returnResultSet;
        if (!this.hasDataAccessPermission()) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0001_PERMISSION_DENIED"));
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0001_PERMISSION_DENIED"));
        }
        try {
            connectionName = UtilHtmlSanitizer.getInstance().safeEscapeHtml(connectionName);
            this.executeQuery(connectionName, query, previewLimit);
            returnResultSet = DatasourceServiceHelper.getSerializeableResultSet(connectionName, query, Integer.parseInt(previewLimit), PentahoSessionHolder.getSession());
        }
        catch (QueryValidationException e) {
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0009_QUERY_VALIDATION_FAILED", e.getLocalizedMessage()), e);
        }
        catch (SqlQueriesNotSupportedException e) {
            throw new DatasourceServiceException(e.getLocalizedMessage(), e);
        }
        return returnResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testDataSourceConnection(String connectionName) throws DatasourceServiceException {
        if (!this.hasDataAccessPermission()) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0001_PERMISSION_DENIED"));
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0001_PERMISSION_DENIED"));
        }
        Connection conn = null;
        try {
            conn = DatasourceServiceHelper.getDataSourceConnection(connectionName, PentahoSessionHolder.getSession());
            if (conn == null) {
                logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0018_UNABLE_TO_TEST_CONNECTION", connectionName));
                throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0018_UNABLE_TO_TEST_CONNECTION", connectionName));
            }
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0018_UNABLE_TO_TEST_CONNECTION", connectionName, e.getLocalizedMessage()), (Throwable)e);
                throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0018_UNABLE_TO_TEST_CONNECTION", connectionName, e.getLocalizedMessage()), e);
            }
        }
        return true;
    }

    @Override
    public BusinessData generateLogicalModel(String modelName, String connectionName, String dbType, String query, String previewLimit) throws DatasourceServiceException {
        if (!this.hasDataAccessPermission()) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0001_PERMISSION_DENIED"));
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0001_PERMISSION_DENIED"));
        }
        try {
            connectionName = UtilHtmlSanitizer.getInstance().safeEscapeHtml(connectionName);
            this.executeQuery(connectionName, query, previewLimit);
            Boolean securityEnabled = this.getPermittedRoleList() != null && this.getPermittedRoleList().size() > 0 || this.getPermittedUserList() != null && this.getPermittedUserList().size() > 0;
            SerializedResultSet resultSet = DatasourceServiceHelper.getSerializeableResultSet(connectionName, query, Integer.parseInt(previewLimit), PentahoSessionHolder.getSession());
            SQLModelGenerator sqlModelGenerator = new SQLModelGenerator(modelName, connectionName, dbType, resultSet.getColumnTypes(), resultSet.getColumns(), query, securityEnabled, this.getEffectivePermittedUserList(securityEnabled), this.getPermittedRoleList(), this.getDefaultAcls(), PentahoSessionHolder.getSession() != null ? PentahoSessionHolder.getSession().getName() : null);
            Domain domain = sqlModelGenerator.generate();
            return new BusinessData(domain, resultSet.getData());
        }
        catch (SQLModelGeneratorException smge) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0011_UNABLE_TO_GENERATE_MODEL", smge.getLocalizedMessage()), (Throwable)smge);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0011_UNABLE_TO_GENERATE_MODEL", smge.getLocalizedMessage()), smge);
        }
        catch (QueryValidationException e) {
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0009_QUERY_VALIDATION_FAILED", e.getLocalizedMessage()), e);
        }
        catch (SqlQueriesNotSupportedException e) {
            throw new DatasourceServiceException(e.getLocalizedMessage(), e);
        }
    }

    private List<String> getEffectivePermittedUserList(boolean securityEnabled) {
        ArrayList<String> permittedUserList;
        ArrayList<String> arrayList = permittedUserList = this.getPermittedUserList() == null ? new ArrayList<String>() : new ArrayList<String>(this.getPermittedUserList());
        if (securityEnabled && !permittedUserList.contains(PentahoSessionHolder.getSession().getName())) {
            permittedUserList.add(PentahoSessionHolder.getSession().getName());
        }
        return permittedUserList;
    }

    public IMetadataDomainRepository getMetadataDomainRepository() {
        return this.metadataDomainRepository;
    }

    public void setMetadataDomainRepository(IMetadataDomainRepository metadataDomainRepository) {
        this.metadataDomainRepository = metadataDomainRepository;
    }

    @Override
    public boolean saveLogicalModel(Domain domain, boolean overwrite) throws DatasourceServiceException {
        if (!this.hasDataAccessPermission()) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0001_PERMISSION_DENIED"));
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0001_PERMISSION_DENIED"));
        }
        String domainName = domain.getId();
        try {
            this.getMetadataDomainRepository().storeDomain(domain, overwrite);
            return true;
        }
        catch (DomainStorageException dse) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0012_UNABLE_TO_STORE_DOMAIN", domainName, dse.getLocalizedMessage()), (Throwable)dse);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0012_UNABLE_TO_STORE_DOMAIN", domainName, dse.getLocalizedMessage()), dse);
        }
        catch (DomainAlreadyExistsException dae) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0013_DOMAIN_ALREADY_EXIST", domainName, dae.getLocalizedMessage()), (Throwable)dae);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0013_DOMAIN_ALREADY_EXIST", domainName, dae.getLocalizedMessage()), dae);
        }
        catch (DomainIdNullException dne) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0014_DOMAIN_IS_NULL", dne.getLocalizedMessage()), (Throwable)dne);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0014_DOMAIN_IS_NULL", dne.getLocalizedMessage()), dne);
        }
    }

    @Override
    public boolean hasPermission() {
        if (PentahoSessionHolder.getSession() != null) {
            IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class, (IPentahoSession)PentahoSessionHolder.getSession());
            return policy.isAllowed("org.pentaho.repository.read") && policy.isAllowed("org.pentaho.repository.create") && policy.isAllowed("org.pentaho.security.administerSecurity");
        }
        return false;
    }

    @Override
    public List<LogicalModelSummary> getLogicalModels(String context) throws DatasourceServiceException {
        if (!this.hasDataAccessViewPermission()) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0001_PERMISSION_DENIED"));
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0001_PERMISSION_DENIED"));
        }
        ArrayList<LogicalModelSummary> logicalModelSummaries = new ArrayList<LogicalModelSummary>();
        for (String domainId : this.getMetadataDomainRepository().getDomainIds()) {
            Domain domain;
            try {
                domain = this.getMetadataDomainRepository().getDomain(domainId);
            }
            catch (Exception e) {
                logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0022_UNABLE_TO_PROCESS_LOGICAL_MODEL", domainId), (Throwable)e);
                continue;
            }
            String locale = LocaleHelper.getLocale().toString();
            String[] locales = new String[domain.getLocales().size()];
            for (int i = 0; i < domain.getLocales().size(); ++i) {
                locales[i] = ((LocaleType)domain.getLocales().get(i)).getCode();
            }
            locale = LocaleHelper.getClosestLocale((String)locale, (String[])locales);
            for (LogicalModel model : domain.getLogicalModels()) {
                String vis = (String)model.getProperty(LM_PROP_VISIBLE);
                if (vis != null) {
                    String[] visibleContexts = vis.split(",");
                    boolean visibleToContext = false;
                    for (String c : visibleContexts) {
                        if (!StringUtils.isNotEmpty((String)c.trim()) || !c.trim().equals(context)) continue;
                        visibleToContext = true;
                        break;
                    }
                    if (!visibleToContext) continue;
                }
                logicalModelSummaries.add(new LogicalModelSummary(domainId, model.getId(), model.getName(locale)));
            }
        }
        return logicalModelSummaries;
    }

    @Override
    public BusinessData loadBusinessData(String domainId, String modelId) throws DatasourceServiceException {
        Domain domain = this.getMetadataDomainRepository().getDomain(domainId);
        List<List<String>> data = null;
        if (domain.getPhysicalModels().get(0) instanceof InlineEtlPhysicalModel) {
            InlineEtlPhysicalModel model = (InlineEtlPhysicalModel)domain.getPhysicalModels().get(0);
            String relativePath = PentahoSystem.getSystemSetting((String)"file-upload-defaults/relative-path", (String)String.valueOf(CsvTransformGenerator.DEFAULT_RELATIVE_UPLOAD_FILE_PATH));
            String csvFileLoc = PentahoSystem.getApplicationContext().getSolutionPath(relativePath);
            data = DatasourceServiceHelper.getCsvDataSample(csvFileLoc + model.getFileLocation(), model.getHeaderPresent(), model.getDelimiter(), model.getEnclosure(), 5);
        } else {
            SqlPhysicalModel model = (SqlPhysicalModel)domain.getPhysicalModels().get(0);
            String query = ((SqlPhysicalTable)model.getPhysicalTables().get(0)).getTargetTable();
            SerializedResultSet resultSet = DatasourceServiceHelper.getSerializeableResultSet(model.getDatasource().getDatabaseName(), query, 5, PentahoSessionHolder.getSession());
            data = resultSet.getData();
        }
        return new BusinessData(domain, data);
    }

    @Override
    public BogoPojo gwtWorkaround(BogoPojo pojo) {
        return pojo;
    }

    @Override
    public String serializeModelState(DatasourceDTO dto) throws DatasourceServiceException {
        XStream xstream = new XStream();
        return xstream.toXML((Object)dto);
    }

    @Override
    public DatasourceDTO deSerializeModelState(String dtoStr) throws DatasourceServiceException {
        XStream xs = new XStream();
        xs.setClassLoader(DatasourceDTO.class.getClassLoader());
        if (dtoStr.startsWith("<org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceDTO>") && dtoStr.endsWith("</org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceDTO>")) {
            return (DatasourceDTO)xs.fromXML(dtoStr);
        }
        logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0025_STRING_FOR_DESERIALIZATION_IS_NOT_VALID"));
        throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0025_STRING_FOR_DESERIALIZATION_IS_NOT_VALID"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listDatasourceNames() throws IOException {
        byte[] byArray = CsvDatasourceServiceImpl.lock;
        synchronized (CsvDatasourceServiceImpl.lock) {
            SimpleUrlFactory urlFactory = new SimpleUrlFactory("");
            PMDUIComponent component = new PMDUIComponent((IPentahoUrlFactory)urlFactory, new ArrayList());
            component.validate(PentahoSessionHolder.getSession(), null);
            component.setAction(2);
            Document document = component.getXmlContent();
            ArrayList<String> datasourceNames = new ArrayList<String>();
            for (Node node : document.selectNodes("//model_name")) {
                datasourceNames.add(node.getText());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return datasourceNames;
        }
    }

    @Override
    public QueryDatasourceSummary generateQueryDomain(String name, String query, DatabaseConnection connection, DatasourceDTO datasourceDTO) throws DatasourceServiceException {
        ModelerWorkspace modelerWorkspace = new ModelerWorkspace((IModelerWorkspaceHelper)new GwtModelerWorkspaceHelper(), this.getGeoContext());
        ModelerService modelerService = this.createModelerService();
        modelerWorkspace.setModelName(name);
        try {
            UtilHtmlSanitizer.getInstance().sanitizeConnectionParameters((IDatabaseConnection)connection);
            this.executeQuery(UtilHtmlSanitizer.getInstance().safeEscapeHtml(datasourceDTO.getConnectionName()), query, "1");
            Boolean securityEnabled = this.getPermittedRoleList() != null && this.getPermittedRoleList().size() > 0 || this.getPermittedUserList() != null && this.getPermittedUserList().size() > 0;
            SerializedResultSet resultSet = DatasourceServiceHelper.getSerializeableResultSet(connection.getName(), query, 10, PentahoSessionHolder.getSession());
            SQLModelGenerator sqlModelGenerator = new SQLModelGenerator(name, connection.getName(), connection.getDatabaseType().getShortName(), resultSet.getColumnTypes(), resultSet.getColumns(), query, securityEnabled, this.getEffectivePermittedUserList(securityEnabled), this.getPermittedRoleList(), this.getDefaultAcls(), PentahoSessionHolder.getSession() != null ? PentahoSessionHolder.getSession().getName() : null);
            Domain domain = sqlModelGenerator.generate();
            ((IPhysicalModel)domain.getPhysicalModels().get(0)).setId(connection.getName());
            modelerWorkspace.setDomain(domain);
            modelerWorkspace.getWorkspaceHelper().autoModelFlat(modelerWorkspace);
            modelerWorkspace.getWorkspaceHelper().autoModelRelationalFlat(modelerWorkspace);
            modelerWorkspace.setModelName(datasourceDTO.getDatasourceName());
            modelerWorkspace.getWorkspaceHelper().populateDomain(modelerWorkspace);
            ((LogicalModel)domain.getLogicalModels().get(0)).setProperty(LM_PROP_DATASOURCE_MODEL, (Object)this.serializeModelState(datasourceDTO));
            ((LogicalModel)domain.getLogicalModels().get(0)).setProperty(LM_PROP_DATASOURCE_TYPE, (Object)"SQL-DS");
            QueryDatasourceSummary summary = new QueryDatasourceSummary();
            this.prepareForSerializaton(domain);
            modelerService.serializeModels(domain, modelerWorkspace.getModelName());
            summary.setDomain(domain);
            return summary;
        }
        catch (SQLModelGeneratorException smge) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0011_UNABLE_TO_GENERATE_MODEL", smge.getLocalizedMessage()), (Throwable)smge);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0011_UNABLE_TO_GENERATE_MODEL", smge.getLocalizedMessage()), smge);
        }
        catch (QueryValidationException e) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0009_QUERY_VALIDATION_FAILED", e.getLocalizedMessage()), (Throwable)e);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0009_QUERY_VALIDATION_FAILED", e.getLocalizedMessage()), e);
        }
        catch (ModelerException e) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0011_UNABLE_TO_GENERATE_MODEL", e.getLocalizedMessage()), (Throwable)e);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0011_UNABLE_TO_GENERATE_MODEL", e.getLocalizedMessage()), e);
        }
        catch (SqlQueriesNotSupportedException e) {
            throw new DatasourceServiceException(e.getLocalizedMessage(), e);
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0011_UNABLE_TO_GENERATE_MODEL", e.getLocalizedMessage()), (Throwable)e);
            throw new DatasourceServiceException(Messages.getErrorString("DatasourceServiceImpl.ERROR_0011_UNABLE_TO_GENERATE_MODEL", e.getLocalizedMessage()), e);
        }
    }

    public void prepareForSerializaton(Domain domain) {
        String relativePath = PentahoSystem.getSystemSetting((String)"file-upload-defaults/relative-path", (String)String.valueOf(FileUtils.DEFAULT_RELATIVE_UPLOAD_FILE_PATH));
        String path = PentahoSystem.getApplicationContext().getSolutionPath(relativePath);
        LogicalModel logicalModel = (LogicalModel)domain.getLogicalModels().get(0);
        String modelState = (String)logicalModel.getProperty(LM_PROP_DATASOURCE_MODEL);
        if (modelState != null) {
            XStream xs = new XStream();
            DatasourceDTO datasource = (DatasourceDTO)xs.fromXML(modelState);
            CsvFileInfo csvFileInfo = datasource.getCsvModelInfo().getFileInfo();
            String csvFileName = csvFileInfo.getFilename();
            if (csvFileName != null) {
                csvFileInfo.setFilename(null);
                csvFileInfo.setTmpFilename(null);
                csvFileInfo.setFriendlyFilename(null);
                csvFileInfo.setContents(null);
                csvFileInfo.setEncoding(null);
                File csvFile = new File(path + File.separatorChar + csvFileName);
                if (csvFile.exists()) {
                    csvFile.delete();
                }
                CsvTransformGenerator csvTransformGenerator = new CsvTransformGenerator(datasource.getCsvModelInfo(), AgileHelper.getDatabaseMeta());
                try {
                    csvTransformGenerator.dropTable(datasource.getCsvModelInfo().getStageTableName());
                }
                catch (CsvTransformGeneratorException e) {
                    logger.error((Object)e);
                }
            }
            modelState = xs.toXML((Object)datasource);
            logicalModel.setProperty(LM_PROP_DATASOURCE_MODEL, (Object)modelState);
        }
    }

    @Override
    public String getDatasourceIllegalCharacters() throws DatasourceServiceException {
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        return resLoader.getPluginSetting(this.getClass(), "settings/data-access-datasource-illegal-characters");
    }

    @Override
    public GeoContext getGeoContext() throws DatasourceServiceException {
        if (this.geoContext == null) {
            this.geoContext = DatasourceServiceHelper.getGeoContext();
        }
        return this.geoContext;
    }
}

