/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.commons.connection.IPentahoConnection;
import org.pentaho.database.DatabaseDialectException;
import org.pentaho.database.IDatabaseDialect;
import org.pentaho.database.dialect.GenericDatabaseDialect;
import org.pentaho.database.model.DatabaseAccessType;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.service.DatabaseDialectService;
import org.pentaho.platform.api.data.IDBDatasourceService;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoObjectFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.api.repository.datasource.DatasourceMgmtServiceException;
import org.pentaho.platform.api.repository.datasource.DuplicateDatasourceException;
import org.pentaho.platform.api.repository.datasource.IDatasourceMgmtService;
import org.pentaho.platform.api.repository.datasource.NonExistingDatasourceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.ConnectionServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.gwt.IConnectionService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.IDataAccessPermissionHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.SimpleDataAccessPermissionHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils.ConnectionServiceHelper;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils.UtilHtmlSanitizer;
import org.pentaho.platform.dataaccess.datasource.wizard.service.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.PentahoConnectionFactory;
import org.pentaho.platform.plugin.services.connections.sql.SQLConnection;

public class ConnectionServiceImpl
extends PentahoBase
implements IConnectionService {
    private static final long serialVersionUID = -4321819783067403620L;
    private IDataAccessPermissionHandler dataAccessPermHandler;
    protected IDatasourceMgmtService datasourceMgmtSvc;
    protected IDBDatasourceService datasourceService;
    protected DatabaseDialectService dialectService = new DatabaseDialectService();
    GenericDatabaseDialect genericDialect = new GenericDatabaseDialect();
    private static final Log logger = LogFactory.getLog(ConnectionServiceImpl.class);
    private UtilHtmlSanitizer sanitizer = UtilHtmlSanitizer.getInstance();

    public Log getLogger() {
        return logger;
    }

    public ConnectionServiceImpl() {
        IPentahoSession session = PentahoSessionHolder.getSession();
        this.datasourceMgmtSvc = (IDatasourceMgmtService)PentahoSystem.get(IDatasourceMgmtService.class, (IPentahoSession)session);
        try {
            IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
            String dataAccessClassName = resLoader.getPluginSetting(this.getClass(), "settings/data-access-permission-handler", SimpleDataAccessPermissionHandler.class.getName());
            Class<?> clazz = Class.forName(dataAccessClassName, true, this.getClass().getClassLoader());
            Constructor<?> defaultConstructor = clazz.getConstructor(new Class[0]);
            this.dataAccessPermHandler = (IDataAccessPermissionHandler)defaultConstructor.newInstance(new Object[0]);
            IPentahoObjectFactory objectFactory = PentahoSystem.getObjectFactory();
            this.datasourceService = objectFactory.objectDefined(IDBDatasourceService.class) ? (IDBDatasourceService)objectFactory.get(IDBDatasourceService.class, null) : null;
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceImpl.ERROR_0007_DATAACCESS_PERMISSIONS_INIT_ERROR", e.getLocalizedMessage()), (Throwable)e);
            this.dataAccessPermHandler = new SimpleDataAccessPermissionHandler();
        }
    }

    public boolean hasDataAccessPermission() {
        return this.dataAccessPermHandler != null && this.dataAccessPermHandler.hasDataAccessPermission(PentahoSessionHolder.getSession());
    }

    public void ensureDataAccessPermission() throws ConnectionServiceException {
        if (!this.hasDataAccessPermission()) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0001_PERMISSION_DENIED");
            logger.error((Object)message);
            throw new ConnectionServiceException(403, message);
        }
    }

    @Override
    public List<IDatabaseConnection> getConnections() throws ConnectionServiceException {
        return this.getConnections(false);
    }

    public List<IDatabaseConnection> getConnections(boolean hidePassword) throws ConnectionServiceException {
        this.ensureDataAccessPermission();
        List connectionList = null;
        try {
            connectionList = this.datasourceMgmtSvc.getDatasources();
            for (IDatabaseConnection conn : connectionList) {
                this.sanitizer.unsanitizeConnectionParameters(conn);
                if (!hidePassword) continue;
                conn.setPassword(null);
            }
        }
        catch (DatasourceMgmtServiceException dme) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0002_UNABLE_TO_GET_CONNECTION_LIST", dme.getLocalizedMessage());
            logger.error((Object)message);
            throw new ConnectionServiceException(message, dme);
        }
        return connectionList;
    }

    @Override
    public IDatabaseConnection getConnectionByName(String name) throws ConnectionServiceException {
        return this.getConnectionByName(name, true);
    }

    public IDatabaseConnection getConnectionByName(String name, boolean doUnsanitize) throws ConnectionServiceException {
        this.ensureDataAccessPermission();
        try {
            IDatabaseConnection connection = this.datasourceMgmtSvc.getDatasourceByName(this.sanitizer.safeEscapeHtml(name));
            if (connection == null) {
                throw new ConnectionServiceException(404, Messages.getErrorString("ConnectionServiceImpl.ERROR_0003_UNABLE_TO_GET_CONNECTION", name));
            }
            if (doUnsanitize) {
                this.sanitizer.unsanitizeConnectionParameters(connection);
            }
            return connection;
        }
        catch (DatasourceMgmtServiceException dme) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0003_UNABLE_TO_GET_CONNECTION", dme.getLocalizedMessage());
            logger.error((Object)message);
            throw new ConnectionServiceException(message, dme);
        }
    }

    public IDatabaseConnection getConnectionById(String id) throws ConnectionServiceException {
        this.ensureDataAccessPermission();
        try {
            IDatabaseConnection connection = this.datasourceMgmtSvc.getDatasourceById(id);
            if (connection == null) {
                throw new ConnectionServiceException(404, Messages.getErrorString("ConnectionServiceImpl.ERROR_0003_UNABLE_TO_GET_CONNECTION", id));
            }
            return connection;
        }
        catch (DatasourceMgmtServiceException dme) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0003_UNABLE_TO_GET_CONNECTION", dme.getLocalizedMessage());
            logger.error((Object)message);
            throw new ConnectionServiceException(message, dme);
        }
    }

    @Override
    public boolean addConnection(IDatabaseConnection connection) throws ConnectionServiceException {
        this.ensureDataAccessPermission();
        try {
            if (connection.getAccessType() != null && connection.getAccessType().equals((Object)DatabaseAccessType.JNDI)) {
                IPentahoConnection pentahoConnection = null;
                pentahoConnection = PentahoConnectionFactory.getConnection((String)"SQL", (String)connection.getDatabaseName(), null, (ILogger)this);
                try {
                    connection.setUsername(((SQLConnection)pentahoConnection).getNativeConnection().getMetaData().getUserName());
                }
                catch (Exception e) {
                    logger.warn((Object)("Unable to get username from datasource: " + connection.getName()));
                }
            }
            this.datasourceMgmtSvc.createDatasource(connection);
            return true;
        }
        catch (DuplicateDatasourceException duplicateDatasourceException) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0004_UNABLE_TO_ADD_CONNECTION", connection.getName(), duplicateDatasourceException.getLocalizedMessage());
            logger.error((Object)message);
            throw new ConnectionServiceException(409, message, duplicateDatasourceException);
        }
        catch (Exception e) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0004_UNABLE_TO_ADD_CONNECTION", connection.getName(), e.getLocalizedMessage());
            logger.error((Object)message);
            throw new ConnectionServiceException(message, e);
        }
    }

    protected String getConnectionPassword(String name, String password) throws ConnectionServiceException {
        return ConnectionServiceHelper.getConnectionPassword(name, password);
    }

    @Override
    public boolean updateConnection(IDatabaseConnection connection) throws ConnectionServiceException {
        this.ensureDataAccessPermission();
        try {
            connection.setPassword(this.getConnectionPassword(connection.getName(), connection.getPassword()));
            this.datasourceMgmtSvc.updateDatasourceByName(connection.getName(), connection);
            this.clearDatasource(connection.getName());
            return true;
        }
        catch (NonExistingDatasourceException nonExistingDatasourceException) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0005_UNABLE_TO_UPDATE_CONNECTION", connection.getName(), nonExistingDatasourceException.getLocalizedMessage());
            throw new ConnectionServiceException(404, message, nonExistingDatasourceException);
        }
        catch (Exception e) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0005_UNABLE_TO_UPDATE_CONNECTION", connection.getName(), e.getLocalizedMessage());
            logger.error((Object)message);
            throw new ConnectionServiceException(message, e);
        }
    }

    @Override
    public boolean deleteConnection(IDatabaseConnection connection) throws ConnectionServiceException {
        this.ensureDataAccessPermission();
        this.sanitizer.sanitizeConnectionParameters(connection);
        try {
            this.datasourceMgmtSvc.deleteDatasourceByName(connection.getName());
            this.clearDatasource(connection.getName());
            return true;
        }
        catch (NonExistingDatasourceException nonExistingDatasourceException) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0006_UNABLE_TO_DELETE_CONNECTION", connection.getName(), nonExistingDatasourceException.getLocalizedMessage());
            throw new ConnectionServiceException(404, message, nonExistingDatasourceException);
        }
        catch (Exception e) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0006_UNABLE_TO_DELETE_CONNECTION", connection.getName(), e.getLocalizedMessage());
            logger.error((Object)message);
            throw new ConnectionServiceException(message, e);
        }
    }

    @Override
    public boolean deleteConnection(String name) throws ConnectionServiceException {
        this.ensureDataAccessPermission();
        name = this.sanitizer.safeEscapeHtml(name);
        try {
            this.datasourceMgmtSvc.deleteDatasourceByName(name);
            this.clearDatasource(name);
            return true;
        }
        catch (NonExistingDatasourceException nonExistingDatasourceException) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0006_UNABLE_TO_DELETE_CONNECTION", name, nonExistingDatasourceException.getLocalizedMessage());
            throw new ConnectionServiceException(404, message, nonExistingDatasourceException);
        }
        catch (Exception e) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0006_UNABLE_TO_DELETE_CONNECTION", name, e.getLocalizedMessage());
            logger.error((Object)message);
            throw new ConnectionServiceException(message, e);
        }
    }

    @Override
    public boolean testConnection(IDatabaseConnection connection) throws ConnectionServiceException {
        this.ensureDataAccessPermission();
        if (connection != null) {
            this.sanitizer.sanitizeConnectionParameters(connection);
            if (connection.getPassword() == null) {
                connection.setPassword("");
            }
            IDatabaseDialect dialect = this.dialectService.getDialect(connection);
            String driverClass = null;
            driverClass = connection.getDatabaseType().getShortName().equals("GENERIC") ? (String)connection.getAttributes().get("CUSTOM_DRIVER_CLASS") : dialect.getNativeDriver();
            IPentahoConnection pentahoConnection = null;
            try {
                if (connection.getAccessType().equals((Object)DatabaseAccessType.JNDI)) {
                    pentahoConnection = PentahoConnectionFactory.getConnection((String)"SQL", (String)connection.getDatabaseName(), null, (ILogger)this);
                } else if (connection.isUsingConnectionPool()) {
                    Properties props = new Properties();
                    props.put("connection_name", connection.getName());
                    props.put("connection", connection);
                    pentahoConnection = PentahoConnectionFactory.getConnection((String)"SQL", (Properties)props, null, (ILogger)this);
                } else {
                    pentahoConnection = PentahoConnectionFactory.getConnection((String)"SQL", (String)driverClass, (String)dialect.getURLWithExtraOptions(connection), (String)connection.getUsername(), (String)this.getConnectionPassword(connection.getName(), connection.getPassword()), null, (ILogger)this);
                }
            }
            catch (DatabaseDialectException e) {
                throw new ConnectionServiceException(e);
            }
            if (pentahoConnection != null) {
                boolean testedOk = ((SQLConnection)pentahoConnection).getNativeConnection() != null;
                pentahoConnection.close();
                return testedOk;
            }
            return false;
        }
        String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0008_UNABLE_TO_TEST_NULL_CONNECTION");
        logger.error((Object)message);
        throw new ConnectionServiceException(400, message);
    }

    @Override
    public boolean isConnectionExist(String connectionName) throws ConnectionServiceException {
        this.ensureDataAccessPermission();
        try {
            IDatabaseConnection connection = this.datasourceMgmtSvc.getDatasourceByName(this.sanitizer.safeEscapeHtml(connectionName));
            return connection != null;
        }
        catch (DatasourceMgmtServiceException dme) {
            String message = Messages.getErrorString("ConnectionServiceImpl.ERROR_0003_UNABLE_TO_GET_CONNECTION", dme.getLocalizedMessage());
            logger.error((Object)message);
            throw new ConnectionServiceException(message, dme);
        }
    }

    private void clearDatasource(String name) {
        if (this.datasourceService == null) {
            logger.warn((Object)("IDBDatasourceService bean not initialized. Unable to clear data source:  " + name));
            return;
        }
        this.datasourceService.clearDataSource(name);
    }
}

