/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.enunciate.Facet;
import org.pentaho.database.IDatabaseDialect;
import org.pentaho.database.dialect.GenericDatabaseDialect;
import org.pentaho.database.model.DatabaseConnection;
import org.pentaho.database.model.DatabaseConnectionPoolParameter;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.service.DatabaseDialectService;
import org.pentaho.database.util.DatabaseUtil;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.ConnectionServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.ConnectionServiceImpl;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.StringArrayWrapper;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils.UtilHtmlSanitizer;
import org.pentaho.platform.dataaccess.datasource.wizard.service.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.ui.database.event.DefaultDatabaseConnectionList;
import org.pentaho.ui.database.event.DefaultDatabaseConnectionPoolParameterList;
import org.pentaho.ui.database.event.IDatabaseConnectionList;
import org.pentaho.ui.database.event.IDatabaseConnectionPoolParameterList;

@Path(value="/data-access/api/connection")
public class ConnectionService {
    private ConnectionServiceImpl connectionService;
    private DatabaseDialectService dialectService;
    GenericDatabaseDialect genericDialect = new GenericDatabaseDialect();
    private static final Log logger = LogFactory.getLog(ConnectionService.class);
    private UtilHtmlSanitizer sanitizer;
    private static final DatabaseConnectionPoolParameter[] poolingParameters = new DatabaseConnectionPoolParameter[]{new DatabaseConnectionPoolParameter("defaultAutoCommit", "true", Messages.getString("ConnectionServiceImpl.INFO_0002_DEFAULT_AUTO_COMMIT")), new DatabaseConnectionPoolParameter("defaultReadOnly", null, Messages.getString("ConnectionServiceImpl.INFO_0003_DEFAULT_READ_ONLY")), new DatabaseConnectionPoolParameter("defaultTransactionIsolation", null, Messages.getString("ConnectionServiceImpl.INFO_0004_DEFAULT_TRANSACTION_ISOLATION")), new DatabaseConnectionPoolParameter("defaultCatalog", null, Messages.getString("ConnectionServiceImpl.INFO_0005_DEFAULT_CATALOG")), new DatabaseConnectionPoolParameter("initialSize", "0", Messages.getString("ConnectionServiceImpl.INFO_0006_INITAL_SIZE")), new DatabaseConnectionPoolParameter("maxActive", "8", Messages.getString("ConnectionServiceImpl.INFO_0007_MAX_ACTIVE")), new DatabaseConnectionPoolParameter("maxIdle", "8", Messages.getString("ConnectionServiceImpl.INFO_0008_MAX_IDLE")), new DatabaseConnectionPoolParameter("minIdle", "0", Messages.getString("ConnectionServiceImpl.INFO_0009_MIN_IDLE")), new DatabaseConnectionPoolParameter("maxWait", "-1", Messages.getString("ConnectionServiceImpl.INFO_0010_MAX_WAIT")), new DatabaseConnectionPoolParameter("validationQuery", null, Messages.getString("ConnectionServiceImpl.INFO_0011_VALIDATION_QUERY")), new DatabaseConnectionPoolParameter("testOnBorrow", "true", Messages.getString("ConnectionServiceImpl.INFO_0012_TEST_ON_BORROW")), new DatabaseConnectionPoolParameter("testOnReturn", "false", Messages.getString("ConnectionServiceImpl.INFO_0013_TEST_ON_RETURN")), new DatabaseConnectionPoolParameter("testWhileIdle", "false", Messages.getString("ConnectionServiceImpl.INFO_0014_TEST_WHILE_IDLE")), new DatabaseConnectionPoolParameter("timeBetweenEvictionRunsMillis", null, Messages.getString("ConnectionServiceImpl.INFO_0015_TIME_BETWEEN_EVICTION_RUNS_MILLIS")), new DatabaseConnectionPoolParameter("poolPreparedStatements", "false", Messages.getString("ConnectionServiceImpl.INFO_0016_POOL_PREPARED_STATEMENTS")), new DatabaseConnectionPoolParameter("maxOpenPreparedStatements", "-1", Messages.getString("ConnectionServiceImpl.INFO_0017_MAX_OPEN_PREPARED_STATEMENTS")), new DatabaseConnectionPoolParameter("accessToUnderlyingConnectionAllowed", "false", Messages.getString("ConnectionServiceImpl.INFO_0018_ACCESS_TO_UNDERLYING_CONNECTION_ALLOWED")), new DatabaseConnectionPoolParameter("removeAbandoned", "false", Messages.getString("ConnectionServiceImpl.INFO_0019_REMOVE_ABANDONED")), new DatabaseConnectionPoolParameter("removeAbandonedTimeout", "300", Messages.getString("ConnectionServiceImpl.INFO_0020_REMOVE_ABANDONED_TIMEOUT")), new DatabaseConnectionPoolParameter("logAbandoned", "false", Messages.getString("ConnectionServiceImpl.INFO_0021_LOGS_ABANDONED"))};

    public ConnectionService() {
        this.connectionService = new ConnectionServiceImpl();
        this.dialectService = new DatabaseDialectService(true);
        this.sanitizer = UtilHtmlSanitizer.getInstance();
    }

    @GET
    @Path(value="/getid")
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public Response getConnectionIdByNameWithResponse(@QueryParam(value="name") String name) throws ConnectionServiceException {
        Response response;
        IDatabaseConnection conn = null;
        try {
            conn = this.connectionService.getConnectionByName(name);
            response = conn != null ? Response.ok().entity((Object)conn.getId()).build() : Response.notModified().build();
        }
        catch (Exception ex) {
            response = Response.serverError().entity((Object)ex.getMessage()).build();
        }
        return response;
    }

    @POST
    @Path(value="/checkParams")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public StringArrayWrapper checkParameters(DatabaseConnection connection) {
        StringArrayWrapper array = null;
        String[] rawValues = DatabaseUtil.convertToDatabaseMeta((IDatabaseConnection)connection).checkParameters();
        if (rawValues.length > 0) {
            array = new StringArrayWrapper();
            array.setArray(rawValues);
        }
        return array;
    }

    @GET
    @Path(value="/createDatabaseConnection")
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public IDatabaseConnection createDatabaseConnection(@QueryParam(value="driver") String driver, @QueryParam(value="url") String url) {
        for (IDatabaseDialect dialect : this.dialectService.getDatabaseDialects()) {
            if (dialect.getNativeDriver() == null || !dialect.getNativeDriver().equals(driver) || dialect.getNativeJdbcPre() == null || !url.startsWith(dialect.getNativeJdbcPre())) continue;
            return dialect.createNativeConnection(url);
        }
        IDatabaseConnection conn = this.genericDialect.createNativeConnection(url);
        conn.getAttributes().put("CUSTOM_DRIVER_CLASS", driver);
        return conn;
    }

    @GET
    @Path(value="/poolingParameters")
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public IDatabaseConnectionPoolParameterList getPoolingParameters() {
        DefaultDatabaseConnectionPoolParameterList value = new DefaultDatabaseConnectionPoolParameterList();
        ArrayList<DatabaseConnectionPoolParameter> paramList = new ArrayList<DatabaseConnectionPoolParameter>();
        for (DatabaseConnectionPoolParameter param : poolingParameters) {
            paramList.add(param);
        }
        value.setDatabaseConnectionPoolParameters(paramList);
        return value;
    }

    @PUT
    @Path(value="/test")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @Facet(name="Unsupported")
    public Response testConnection(DatabaseConnection connection) throws ConnectionServiceException {
        boolean success = false;
        this.applySavedPassword((IDatabaseConnection)connection);
        success = this.connectionService.testConnection((IDatabaseConnection)connection);
        if (success) {
            return Response.ok((Object)Messages.getString("ConnectionServiceImpl.INFO_0001_CONNECTION_SUCCEED", connection.getDatabaseName())).build();
        }
        return Response.serverError().entity((Object)Messages.getErrorString("ConnectionServiceImpl.ERROR_0009_CONNECTION_FAILED", connection.getDatabaseName())).build();
    }

    @POST
    @Path(value="/update")
    @Consumes(value={"application/json"})
    @Facet(name="Unsupported")
    public Response updateConnection(DatabaseConnection connection) throws ConnectionServiceException {
        this.sanitizer.sanitizeConnectionParameters((IDatabaseConnection)connection);
        try {
            this.applySavedPassword((IDatabaseConnection)connection);
            boolean success = this.connectionService.updateConnection((IDatabaseConnection)connection);
            if (success) {
                return Response.ok().build();
            }
            return Response.notModified().build();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return Response.serverError().build();
        }
    }

    private void applySavedPassword(IDatabaseConnection conn) throws ConnectionServiceException {
        if (StringUtils.isBlank((String)conn.getPassword())) {
            IDatabaseConnection savedConn;
            if (conn.getId() != null) {
                savedConn = this.connectionService.getConnectionById(conn.getId());
            } else {
                try {
                    savedConn = this.connectionService.getConnectionByName(conn.getName());
                }
                catch (ConnectionServiceException e) {
                    logger.warn((Object)e.getMessage());
                    savedConn = null;
                }
            }
            if (savedConn != null) {
                conn.setPassword(savedConn.getPassword());
            }
        }
    }

    @DELETE
    @Path(value="/delete")
    @Consumes(value={"application/json"})
    @Facet(name="Unsupported")
    public Response deleteConnection(DatabaseConnection connection) throws ConnectionServiceException {
        try {
            boolean success = this.connectionService.deleteConnection((IDatabaseConnection)connection);
            if (success) {
                return Response.ok().build();
            }
            return Response.notModified().build();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return Response.serverError().build();
        }
    }

    @DELETE
    @Path(value="/deletebyname")
    public Response deleteConnectionByName(@QueryParam(value="name") String name) throws ConnectionServiceException {
        try {
            boolean success = this.connectionService.deleteConnection(name);
            if (success) {
                return Response.ok().build();
            }
            return Response.notModified().build();
        }
        catch (Throwable t) {
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="/add")
    @Consumes(value={"application/json"})
    @Facet(name="Unsupported")
    public Response addConnection(DatabaseConnection connection) throws ConnectionServiceException {
        this.sanitizer.sanitizeConnectionParameters((IDatabaseConnection)connection);
        try {
            boolean success = this.connectionService.addConnection((IDatabaseConnection)connection);
            if (success) {
                return Response.ok().build();
            }
            return Response.notModified().build();
        }
        catch (ConnectionServiceException cse) {
            return Response.status((int)cse.getStatusCode()).build();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return Response.serverError().build();
        }
    }

    private void validateAccess() throws PentahoAccessControlException {
        boolean isAdmin;
        IAuthorizationPolicy policy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
        boolean bl = isAdmin = policy.isAllowed("org.pentaho.repository.read") && policy.isAllowed("org.pentaho.repository.create") && (policy.isAllowed("org.pentaho.security.administerSecurity") || policy.isAllowed("org.pentaho.security.publish"));
        if (!isAdmin) {
            throw new PentahoAccessControlException("Access Denied");
        }
    }

    @GET
    @Path(value="/list")
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public IDatabaseConnectionList getConnections() throws ConnectionServiceException {
        DefaultDatabaseConnectionList databaseConnections = new DefaultDatabaseConnectionList();
        List<IDatabaseConnection> conns = this.connectionService.getConnections(true);
        databaseConnections.setDatabaseConnections(conns);
        return databaseConnections;
    }

    @GET
    @Path(value="/get")
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public IDatabaseConnection getConnectionByName(@QueryParam(value="name") String name) throws ConnectionServiceException {
        IDatabaseConnection conn = this.connectionService.getConnectionByName(name);
        this.hidePassword(conn);
        return conn;
    }

    @GET
    @Path(value="/checkexists")
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public Response isConnectionExist(@QueryParam(value="name") String name) throws ConnectionServiceException {
        boolean exists = this.connectionService.isConnectionExist(name);
        try {
            if (exists) {
                return Response.ok().build();
            }
            return Response.notModified().build();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/getresponse")
    @Produces(value={"application/json"})
    @Facet(name="Unsupported")
    public Response getConnectionByNameWithResponse(@QueryParam(value="name") String name) throws ConnectionServiceException {
        Response response;
        IDatabaseConnection conn = null;
        try {
            conn = this.connectionService.getConnectionByName(name);
            this.sanitizer.unsanitizeConnectionParameters(conn);
            this.hidePassword(conn);
            response = Response.ok().entity((Object)conn).build();
        }
        catch (Exception ex) {
            response = Response.serverError().entity((Object)ex.getMessage()).build();
        }
        return response;
    }

    private void hidePassword(IDatabaseConnection conn) {
        conn.setPassword(null);
    }
}

