/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataParam;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.enunciate.Facet;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileAclDto;
import org.pentaho.platform.dataaccess.datasource.api.AnalysisService;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;

@Path(value="/data-access/api/mondrian")
public class AnalysisDatasourceService {
    private static final Log logger = LogFactory.getLog(AnalysisDatasourceService.class);
    private static final String XMLA_ENABLED_FLAG = "xmlaEnabledFlag";
    private static final String CATALOG_NAME = "catalogName";
    private static final String ORIG_CATALOG_NAME = "origCatalogName";
    private static final String DATASOURCE_NAME = "datasourceName";
    private static final String UPLOAD_ANALYSIS = "uploadAnalysis";
    private static final String PARAMETERS = "parameters";
    private static final String OVERWRITE_IN_REPOS = "overwrite";
    private static final String DATASOURCE_ACL = "acl";
    private static final int SUCCESS = 3;

    @PUT
    @Path(value="/putSchema")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @Facet(name="Unsupported")
    public Response putMondrianSchema(@FormDataParam(value="uploadAnalysis") InputStream dataInputStream, @FormDataParam(value="uploadAnalysis") FormDataContentDisposition schemaFileInfo, @FormDataParam(value="catalogName") String catalogName, @FormDataParam(value="origCatalogName") String origCatalogName, @FormDataParam(value="datasourceName") String datasourceName, @FormDataParam(value="overwrite") String overwrite, @FormDataParam(value="xmlaEnabledFlag") String xmlaEnabledFlag, @FormDataParam(value="parameters") String parameters, @FormDataParam(value="acl") RepositoryFileAclDto acl) throws PentahoAccessControlException {
        Response response = null;
        int statusCode = 2;
        try {
            AnalysisService service = new AnalysisService();
            boolean overWriteInRepository = "True".equalsIgnoreCase(overwrite);
            boolean xmlaEnabled = "True".equalsIgnoreCase(xmlaEnabledFlag);
            service.putMondrianSchema(dataInputStream, schemaFileInfo, catalogName, origCatalogName, datasourceName, overWriteInRepository, xmlaEnabled, parameters, acl);
            statusCode = 3;
        }
        catch (PentahoAccessControlException pac) {
            logger.error((Object)pac.getMessage());
            statusCode = 5;
        }
        catch (PlatformImportException pe) {
            statusCode = pe.getErrorStatus();
            logger.error((Object)("Error putMondrianSchema " + pe.getMessage() + " status = " + statusCode));
        }
        catch (Exception e) {
            logger.error((Object)("Error putMondrianSchema " + e.getMessage()));
            statusCode = 2;
        }
        response = Response.ok().status(statusCode).type("text/plain").build();
        logger.debug((Object)("putMondrianSchema Response " + response));
        return response;
    }

    @POST
    @Path(value="/postAnalysis")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain", "text/html"})
    @Facet(name="Unsupported")
    public Response postMondrainSchema(@FormDataParam(value="uploadAnalysis") InputStream dataInputStream, @FormDataParam(value="uploadAnalysis") FormDataContentDisposition schemaFileInfo, @FormDataParam(value="catalogName") String catalogName, @FormDataParam(value="origCatalogName") String origCatalogName, @FormDataParam(value="datasourceName") String datasourceName, @FormDataParam(value="overwrite") String overwrite, @FormDataParam(value="xmlaEnabledFlag") String xmlaEnabledFlag, @FormDataParam(value="parameters") String parameters, @FormDataParam(value="acl") RepositoryFileAclDto acl) throws PentahoAccessControlException {
        Response response = this.putMondrianSchema(dataInputStream, schemaFileInfo, catalogName, origCatalogName, datasourceName, overwrite, xmlaEnabledFlag, parameters, acl);
        Response.ResponseBuilder responseBuilder = Response.ok();
        responseBuilder.entity((Object)String.valueOf(response.getStatus()));
        responseBuilder.status(200);
        return responseBuilder.build();
    }
}

