/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.agile;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepErrorMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;
import org.pentaho.platform.dataaccess.datasource.wizard.service.agile.StagingTransformGenerator;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.csv.FileTransformStats;

public class TableInputTransformGenerator
extends StagingTransformGenerator {
    private static final long serialVersionUID = -185098401772609035L;
    private static final String TABLE_INPUT = "tableinput";
    private static final Log log = LogFactory.getLog(TableInputTransformGenerator.class);
    private DatabaseMeta sourceDatabaseMeta;
    private String sql;
    private int rowLimit = -1;

    public TableInputTransformGenerator(DatabaseMeta sourceDatabaseMeta, DatabaseMeta targetDatabaseMeta) {
        super(targetDatabaseMeta);
        this.sourceDatabaseMeta = sourceDatabaseMeta;
    }

    @Override
    protected String[] getIndexedColumnNames() {
        return new String[0];
    }

    @Override
    protected StepMeta[] getSteps(TransMeta transMeta) {
        StepMeta[] steps = new StepMeta[]{this.createInputStep(transMeta)};
        return steps;
    }

    protected StepMeta createInputStep(TransMeta transMeta) {
        TableInputMeta inputMeta = new TableInputMeta();
        inputMeta.setDatabaseMeta(this.sourceDatabaseMeta);
        inputMeta.setExecuteEachInputRow(false);
        inputMeta.setRowLimit(Integer.toString(this.rowLimit));
        inputMeta.setSQL(this.sql);
        inputMeta.setVariableReplacementActive(false);
        inputMeta.setLazyConversionActive(false);
        StepMeta inputStepMeta = new StepMeta(TABLE_INPUT, TABLE_INPUT, (StepMetaInterface)inputMeta);
        inputStepMeta.setStepErrorMeta(new StepErrorMeta((VariableSpace)transMeta, inputStepMeta));
        transMeta.addStep(inputStepMeta);
        final FileTransformStats stats = this.getTransformStats();
        StepErrorMeta inputErrorMeta = new StepErrorMeta((VariableSpace)transMeta, inputStepMeta){

            public void addErrorRowData(Object[] row, int startIndex, long nrErrors, String errorDescriptions, String fieldNames, String errorCodes) {
                StringBuffer sb = new StringBuffer();
                sb.append("Rejected Row: ");
                for (Object rowData : row) {
                    sb.append(rowData);
                    sb.append(", ");
                }
                sb.append("\r\n");
                ((ArrayList)stats.getErrors()).add(sb.toString() + errorDescriptions);
                super.addErrorRowData(row, startIndex, nrErrors, errorDescriptions, fieldNames, errorCodes);
            }
        };
        StepMeta outputDummyStepMeta = this.addDummyStep(transMeta, "InputErrorDummy");
        inputErrorMeta.setTargetStep(outputDummyStepMeta);
        inputErrorMeta.setEnabled(true);
        inputStepMeta.setStepErrorMeta(inputErrorMeta);
        return inputStepMeta;
    }

    @Override
    public Log getLogger() {
        return log;
    }

    public DatabaseMeta getSourceDatabaseMeta() {
        return this.sourceDatabaseMeta;
    }

    public void setSourceDatabaseMeta(DatabaseMeta databaseMeta) {
        this.sourceDatabaseMeta = databaseMeta;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }
}

