/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.models;

import com.google.gwt.http.client.URL;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.metadata.model.Category;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.concept.types.LocaleType;
import org.pentaho.platform.dataaccess.datasource.DatasourceType;
import org.pentaho.platform.dataaccess.datasource.wizard.models.CsvFileInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.models.GuiStateModel;
import org.pentaho.platform.dataaccess.datasource.wizard.models.IModelInfoValidationListener;
import org.pentaho.platform.dataaccess.datasource.wizard.models.IRelationalModelValidationListener;
import org.pentaho.platform.dataaccess.datasource.wizard.models.ModelInfo;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.binding.BindingException;
import org.pentaho.ui.xul.stereotype.Bindable;

@Deprecated
public class DatasourceModel
extends XulEventSourceAdapter
implements IRelationalModelValidationListener,
IModelInfoValidationListener {
    private boolean validated;
    private DatasourceType datasourceType = DatasourceType.NONE;
    private transient GuiStateModel guiStateModel = new GuiStateModel();
    private ModelInfo modelInfo;
    private Domain domain;
    private String datasourceName;
    private IDatabaseConnection selectedRelationalConnection;
    private String query;
    private boolean editMode;

    public DatasourceModel() {
        this.guiStateModel.addRelationalModelValidationListener(this);
        CsvFileInfo fileInfo = new CsvFileInfo();
        this.modelInfo = new ModelInfo();
        this.modelInfo.setFileInfo(fileInfo);
        this.modelInfo.addModelInfoValidationListener(this);
    }

    @Bindable
    public GuiStateModel getGuiStateModel() {
        return this.guiStateModel;
    }

    @Bindable
    public void setGuiStateModel(GuiStateModel guiStateModel) {
        this.guiStateModel = guiStateModel;
    }

    @Bindable
    public String getDatasourceName() {
        return this.datasourceName;
    }

    @Bindable
    public void setDatasourceName(String datasourceName) {
        String previousVal = this.datasourceName;
        this.datasourceName = datasourceName;
        if (this.domain != null) {
            this.domain.setId(datasourceName);
            LogicalModel model = (LogicalModel)this.domain.getLogicalModels().get(0);
            String localeCode = ((LocaleType)this.domain.getLocales().get(0)).getCode();
            model.getName().setString(localeCode, datasourceName);
        }
        this.getModelInfo().setStageTableName(this.generateTableName());
        this.firePropertyChange("datasourceName", previousVal, datasourceName);
        this.validate();
    }

    @Bindable
    public IDatabaseConnection getSelectedRelationalConnection() {
        return this.selectedRelationalConnection;
    }

    @Bindable
    public void setSelectedRelationalConnection(IDatabaseConnection value) {
        try {
            IDatabaseConnection previousValue = this.selectedRelationalConnection;
            this.selectedRelationalConnection = value;
            if (value != null) {
                this.firePropertyChange("selectedRelationalConnection", previousValue, value);
                this.validate();
            }
        }
        catch (BindingException bindingException) {
            // empty catch block
        }
    }

    @Bindable
    public String getQuery() {
        return this.query;
    }

    @Bindable
    public void setQuery(String value) {
        String previousVal = this.query;
        this.query = value;
        this.firePropertyChange("query", previousVal, value);
        this.validate();
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
        if (domain != null) {
            this.guiStateModel.setLogicalModels(domain.getLogicalModels());
            this.guiStateModel.setLocaleCode(((LocaleType)domain.getLocales().get(0)).getCode());
        } else {
            this.guiStateModel.setLogicalModels(null);
            this.guiStateModel.setLocaleCode(null);
        }
    }

    @Bindable
    public ModelInfo getModelInfo() {
        return this.modelInfo;
    }

    @Bindable
    public void setModelInfo(ModelInfo modelInfo) {
        this.modelInfo.getFileInfo().setSavedEncoding(modelInfo.getFileInfo().getEncoding());
        this.modelInfo.setColumns(modelInfo.getColumns());
        this.modelInfo.setData(modelInfo.getData());
        this.modelInfo.setStageTableName(modelInfo.getStageTableName());
        this.modelInfo.getFileInfo().setDelimiter(modelInfo.getFileInfo().getDelimiter());
        this.modelInfo.getFileInfo().setContents(modelInfo.getFileInfo().getContents());
        this.modelInfo.getFileInfo().setCurrencySymbol(modelInfo.getFileInfo().getCurrencySymbol());
        this.modelInfo.getFileInfo().setEnclosure(modelInfo.getFileInfo().getEnclosure());
        this.modelInfo.getFileInfo().setEncoding(modelInfo.getFileInfo().getEncoding());
        this.modelInfo.getFileInfo().setFilename(modelInfo.getFileInfo().getFilename());
        this.modelInfo.getFileInfo().setTmpFilename(modelInfo.getFileInfo().getTmpFilename());
        this.modelInfo.getFileInfo().setGroupSymbol(modelInfo.getFileInfo().getGroupSymbol());
        this.modelInfo.getFileInfo().setHeaderRows(modelInfo.getFileInfo().getHeaderRows());
        this.modelInfo.getFileInfo().setIfNull(modelInfo.getFileInfo().getIfNull());
        this.modelInfo.getFileInfo().setNullStr(modelInfo.getFileInfo().getNullStr());
        this.modelInfo.getFileInfo().setProject(modelInfo.getFileInfo().getProject());
        this.modelInfo.getFileInfo().setFriendlyFilename(modelInfo.getFileInfo().getFriendlyFilename());
        modelInfo.validate();
        this.validate();
    }

    @Bindable
    public boolean isValidated() {
        return this.validated;
    }

    @Bindable
    private void setValidated(boolean validated) {
        boolean prevVal = this.validated;
        this.validated = validated;
        this.firePropertyChange("validated", prevVal, validated);
    }

    @Bindable
    public DatasourceType getDatasourceType() {
        return this.datasourceType;
    }

    @Bindable
    public void setDatasourceType(DatasourceType datasourceType) {
        DatasourceType previousVal = this.datasourceType;
        this.datasourceType = datasourceType;
        this.firePropertyChange("datasourceType", (Object)previousVal, (Object)datasourceType);
        this.validate();
    }

    public void validate() {
        boolean value = false;
        if (this.datasourceName != null && this.datasourceName.length() > 0) {
            if (DatasourceType.SQL == this.getDatasourceType() && this.getSelectedRelationalConnection() != null && this.query != null && this.query.length() > 0) {
                this.guiStateModel.validateRelational();
                value = this.guiStateModel.isRelationalValidated();
            } else if (DatasourceType.CSV == this.getDatasourceType()) {
                this.guiStateModel.invalidateRelational();
                value = this.modelInfo.isValidated();
            }
        } else {
            this.guiStateModel.invalidateRelational();
        }
        this.setValidated(value);
    }

    public void clearModel() {
        this.setQuery("");
        this.setDatasourceName("");
        this.guiStateModel.clearModel();
        IDatabaseConnection firstConnection = this.guiStateModel.getConnections().size() > 0 ? this.guiStateModel.getConnections().get(0) : null;
        this.setSelectedRelationalConnection(firstConnection);
        this.modelInfo.clearModel();
        this.guiStateModel.setDataStagingComplete(false);
        this.setDatasourceType(DatasourceType.NONE);
        this.validate();
    }

    @Override
    public void onRelationalModelInValid() {
        if (DatasourceType.SQL == this.getDatasourceType()) {
            this.setValidated(false);
        }
    }

    @Override
    public void onRelationalModelValid() {
        if (DatasourceType.SQL == this.getDatasourceType()) {
            this.setValidated(true);
        }
    }

    public void copyOverMetadata(Domain oldDomain, Domain newDomain) {
        Category category = (Category)((LogicalModel)newDomain.getLogicalModels().get(0)).getCategories().get(0);
        LogicalModel oldModel = (LogicalModel)oldDomain.getLogicalModels().get(0);
        for (LogicalColumn column : category.getLogicalColumns()) {
            LogicalColumn oldColumn = oldModel.findLogicalColumn(column.getId());
            if (oldColumn == null) continue;
            column.setDataType(oldColumn.getDataType());
            column.setName(oldColumn.getName());
            column.setAggregationList(oldColumn.getAggregationList());
            column.setAggregationType(oldColumn.getAggregationType());
        }
    }

    @Override
    public void onModelInfoInvalid() {
        if (DatasourceType.CSV == this.getDatasourceType()) {
            this.setValidated(false);
        }
    }

    @Override
    public void onModelInfoValid() {
        if (DatasourceType.CSV == this.getDatasourceType()) {
            this.setValidated(true);
        }
    }

    public String generateTableName() {
        if (this.datasourceName == null) {
            throw new IllegalStateException("DatasourceName must not be null, cannot generate a valid table name");
        }
        return URL.encode((String)this.datasourceName.trim().replace(" ", "_")).replaceAll("[^A-Za-z0-9_-]", "").toLowerCase();
    }

    @Override
    public void onCsvInValid() {
    }

    @Override
    public void onCsvValid() {
    }

    public boolean isEditing() {
        return this.editMode;
    }

    public void setEditing(boolean editing) {
        this.editMode = editing;
    }
}

