/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.controllers;

import org.pentaho.platform.dataaccess.datasource.wizard.DatasourceMessages;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

public class MessageHandler
extends AbstractXulEventHandler {
    private XulDialog errorDialog;
    private XulDialog errorDetailsDialog;
    private DatasourceMessages messages;
    private XulDialog successDialog = null;
    private XulLabel successLabel = null;
    private XulDialog wizardDialog;
    private boolean showWizardDialog;
    public static final String MSG_OPENING_MODELER = "waiting.openingModeler";
    public static final String MSG_GENERAL_WAIT = "waiting.generalWaiting";
    public static final String MSG_STAGING_DATA = "physicalDatasourceDialog.STAGING_DATA";
    public static final String MSG_CREATING_DATA_SOURCE = "waiting.creatingDataSource";
    public static final String MSG_PLEASE_WAIT = "waiting.title";
    private static MessageHandler INSTANCE = new MessageHandler();

    private MessageHandler() {
    }

    public String getName() {
        return "messageHandler";
    }

    public void init() {
        this.errorDialog = (XulDialog)this.document.getElementById("errorDialog");
        this.errorDetailsDialog = (XulDialog)this.document.getElementById("errorDetailsDialog");
        this.successDialog = (XulDialog)this.document.getElementById("successDialog");
        this.successLabel = (XulLabel)this.document.getElementById("successLabel");
    }

    public void showErrorDialog(String message) {
        this.showErrorDialog(this.messages.getString("error"), message);
    }

    public void showErrorDialog(String title, String message) {
        this.showErrorDialog(title, message, false);
    }

    public void showErrorDialog(String title, String message, boolean showWizardDialog) {
        this.showWizardDialog = showWizardDialog;
        XulDialog errorDialog = (XulDialog)this.document.getElementById("errorDialog");
        errorDialog.setTitle(title);
        XulLabel errorLabel = (XulLabel)this.document.getElementById("errorLabel");
        errorLabel.setValue(message);
        errorDialog.show();
    }

    public void showErrorDetailsDialog(String title, String message, String detailMessage) {
        XulDialog errorDialog = (XulDialog)this.document.getElementById("errorDetailsDialog");
        errorDialog.setTitle(title);
        XulLabel errorLabel = (XulLabel)this.document.getElementById("errorDetailsLabel");
        errorLabel.setValue(message);
        XulLabel detailMessageBox = (XulLabel)this.document.getElementById("error_dialog_details");
        detailMessageBox.setValue(detailMessage);
        errorDialog.show();
    }

    @Bindable
    public void closeSuccessDetailsDialog() {
        XulDialog detailedSuccessDialog = (XulDialog)this.document.getElementById("successDetailsDialog");
        detailedSuccessDialog.hide();
    }

    @Bindable
    public void showDetailedSuccessDialog(String message, String detailMessage) {
        XulDialog detailedSuccessDialog = (XulDialog)this.document.getElementById("successDetailsDialog");
        XulLabel successLabel = (XulLabel)this.document.getElementById("success_details_label");
        successLabel.setValue(message);
        XulTextbox detailMessageBox = (XulTextbox)this.document.getElementById("success_dialog_details");
        detailMessageBox.setValue(detailMessage);
        detailedSuccessDialog.show();
    }

    @Bindable
    public void closeSuccessDialog() {
        this.successDialog.hide();
    }

    public void showSuccessDialog(String message) {
        this.successLabel.setValue(message);
        this.successDialog.show();
    }

    public void showWaitingDialog() {
        this.showWaitingDialog(this.messages.getString(MSG_CREATING_DATA_SOURCE));
    }

    public void showWaitingDialog(String msg) {
        MessageHandler.showBusyIndicator(MessageHandler.getString(MSG_PLEASE_WAIT), msg);
    }

    public void closeWaitingDialog() {
        MessageHandler.hideBusyIndicator();
    }

    public static native void showBusyIndicator(String var0, String var1);

    public static native void hideBusyIndicator();

    @Bindable
    public void closeErrorDetailsDialog() {
        if (!this.errorDetailsDialog.isHidden()) {
            this.errorDetailsDialog.hide();
        }
        this.wizardDialog.show();
    }

    @Bindable
    public void closeErrorDialog() {
        if (!this.errorDialog.isHidden()) {
            this.errorDialog.hide();
        }
        if (this.showWizardDialog) {
            this.wizardDialog.show();
        }
    }

    public void setMessages(DatasourceMessages messages) {
        this.messages = messages;
    }

    public void setWizardDialog(XulDialog wizardDialog) {
        this.wizardDialog = wizardDialog;
    }

    public static MessageHandler getInstance() {
        return INSTANCE;
    }

    public static String getString(String key) {
        return MessageHandler.getInstance().messages.getString(key);
    }

    public static String getString(String key, String ... params) {
        return MessageHandler.getInstance().messages.getString(key, params);
    }
}

