/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.controllers;

import com.google.gwt.http.client.URL;
import org.pentaho.platform.dataaccess.datasource.wizard.DatasourceMessages;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.MessageHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceModel;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulFileUpload;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.gwt.binding.GwtBindingFactory;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

public class FileImportController
extends AbstractXulEventHandler {
    private XulDialog datasourceDialog;
    private XulFileUpload fileUpload;
    private XulDialog errorDialog;
    private XulLabel errorLabel;
    private BindingFactory bf;
    private DatasourceMessages messages;
    private DatasourceModel datasourceModel;

    public FileImportController(DatasourceModel datasourceModel, DatasourceMessages messages) {
        this.datasourceModel = datasourceModel;
        this.setDatasourceMessages(messages);
    }

    @Bindable
    public void init() {
        this.bf = new GwtBindingFactory(this.document);
        this.fileUpload = (XulFileUpload)this.document.getElementById("fileUpload");
        this.datasourceDialog = (XulDialog)this.document.getElementById("fileImportEditorWindow");
        this.errorLabel = (XulLabel)this.document.getElementById("errorLabel");
        this.errorDialog = (XulDialog)this.document.getElementById("errorDialog");
        BindingConvertor<String, Boolean> isDisabledConvertor = new BindingConvertor<String, Boolean>(){

            public Boolean sourceToTarget(String aValue) {
                return aValue == null || "".equals(aValue);
            }

            public String targetToSource(Boolean aValue) {
                return null;
            }
        };
        this.bf.createBinding("fileUpload", "selectedFile", "okButton", "disabled", new BindingConvertor[]{isDisabledConvertor});
    }

    public String getName() {
        return "fileImportController";
    }

    @Bindable
    public void submitCsv() {
        String fileName = this.fileUpload.getSeletedFile();
        if (fileName != null) {
            fileName = this.extractFilename(fileName);
        }
        this.fileUpload.addParameter("file_name", fileName == null ? "" : URL.encodeQueryString((String)fileName));
        this.fileUpload.addParameter("mark_temporary", "true");
        this.fileUpload.addParameter("unzip", "true");
        this.showWaitingDialog();
        this.fileUpload.submit();
    }

    public void closeWaitingDialog() {
        MessageHandler.getInstance().closeWaitingDialog();
    }

    public void showWaitingDialog() {
        MessageHandler.getInstance().showWaitingDialog(this.messages.getString("fileImportDialog.UPLOADING", this.fileUpload.getSeletedFile()));
    }

    @Bindable
    public void showFileImportDialog() {
        this.fileUpload.setSelectedFile("");
        this.datasourceDialog.show();
    }

    @Bindable
    public void close() {
        this.datasourceDialog.hide();
    }

    @Bindable
    public void uploadSuccess(String uploadedFile) {
        this.closeWaitingDialog();
        this.close();
        String selectedFile = this.fileUpload.getSeletedFile();
        String selectedFileLc = selectedFile.toLowerCase();
        String uploadedFileLc = uploadedFile.toLowerCase();
        if (uploadedFile.indexOf("\n") != -1) {
            this.showErroDialog(this.messages.getString("fileImportDialog.COMPRESSED_TOO_MANY_FILES"));
            return;
        }
        if ((selectedFileLc.endsWith(".zip") || selectedFileLc.endsWith(".tgz") || selectedFileLc.endsWith(".tar")) && !uploadedFileLc.endsWith(".csv.tmp") && !uploadedFileLc.endsWith(".txt.tmp")) {
            this.showErroDialog(this.messages.getString("fileImportDialog.COMPRESSED_NO_CSV"));
            return;
        }
        if (selectedFileLc.endsWith(".csv") || selectedFileLc.endsWith(".txt") || selectedFileLc.endsWith(".zip") || selectedFileLc.endsWith(".tgz") || selectedFileLc.endsWith(".tar")) {
            this.datasourceModel.getModelInfo().getFileInfo().setTmpFilename(uploadedFile);
            this.datasourceModel.getModelInfo().getFileInfo().setFriendlyFilename(this.extractFilename(selectedFile));
        } else {
            this.showErroDialog(this.messages.getString("fileImportDialog.INVALID_FILE"));
        }
    }

    private String extractFilename(String path) {
        int idx = path.lastIndexOf(92);
        if (idx >= 0) {
            return path.substring(idx + 1);
        }
        idx = path.lastIndexOf(47);
        if (idx >= 0) {
            return path.substring(idx + 1);
        }
        return path;
    }

    @Bindable
    public void uploadFailure(Throwable t) {
        this.closeWaitingDialog();
        this.close();
        this.datasourceModel.getModelInfo().getFileInfo().setTmpFilename("");
        this.datasourceModel.getModelInfo().getFileInfo().setFriendlyFilename("");
        this.showErroDialog(t.getMessage());
    }

    public void showErroDialog(String error) {
        this.errorLabel.setValue(error);
        this.errorDialog.show();
    }

    @Bindable
    public void closeErrorDialog() {
        this.errorDialog.hide();
    }

    public void setDatasourceMessages(DatasourceMessages datasourceMessages) {
        this.messages = datasourceMessages;
    }
}

