/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.controllers;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Window;
import com.google.web.bindery.autobean.shared.AutoBean;
import com.google.web.bindery.autobean.shared.AutoBeanCodex;
import com.google.web.bindery.autobean.shared.AutoBeanFactory;
import com.google.web.bindery.autobean.shared.AutoBeanUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.model.IDatabaseType;
import org.pentaho.database.util.DatabaseTypeHelper;
import org.pentaho.gwt.widgets.client.utils.NameUtils;
import org.pentaho.platform.dataaccess.datasource.beans.AutobeanUtilities;
import org.pentaho.platform.dataaccess.datasource.utils.ExceptionParser;
import org.pentaho.platform.dataaccess.datasource.wizard.ConnectionDialogListener;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.MessageHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.models.DatasourceModel;
import org.pentaho.ui.database.event.DatabaseDialogListener;
import org.pentaho.ui.database.event.IConnectionAutoBeanFactory;
import org.pentaho.ui.database.event.IDatabaseConnectionList;
import org.pentaho.ui.database.gwt.GwtDatabaseDialog;
import org.pentaho.ui.database.gwt.GwtXulAsyncDatabaseDialectService;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulHbox;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.util.DialogController;

public class ConnectionController
extends AbstractXulEventHandler {
    private List<ConnectionDialogListener> listeners = new ArrayList<ConnectionDialogListener>();
    private DatasourceModel datasourceModel;
    private XulDialog removeConfirmationDialog;
    private XulDialog saveConnectionConfirmationDialog;
    private XulDialog overwriteConnectionConfirmationDialog;
    private XulDialog renameConnectionConfirmationDialog;
    private XulDialog errorDialog;
    private XulDialog successDialog;
    private XulLabel errorLabel = null;
    private XulLabel successLabel = null;
    GwtXulAsyncDatabaseDialectService dialectService = new GwtXulAsyncDatabaseDialectService();
    GwtDatabaseDialog databaseDialog;
    DatabaseTypeHelper databaseTypeHelper;
    IDatabaseConnection currentConnection;
    DatabaseConnectionSetter connectionSetter;
    protected IConnectionAutoBeanFactory connectionAutoBeanFactory;
    protected String previousConnectionName;
    protected String existingConnectionName;
    protected String existingConnectionId;
    private XulDialog successDetailsDialog;
    public static final String ATTRIBUTE_STANDARD_CONNECTION = "STANDARD_CONNECTION";

    public ConnectionController(Document document) {
        this.document = document;
        this.connectionAutoBeanFactory = (IConnectionAutoBeanFactory)GWT.create(IConnectionAutoBeanFactory.class);
        this.init();
    }

    protected void copyDatabaseConnectionProperties(IDatabaseConnection source, IDatabaseConnection target) {
        target.setId(source.getId());
        target.setAccessType(source.getAccessType());
        target.setDatabaseType(source.getDatabaseType());
        target.setExtraOptions(source.getExtraOptions());
        target.setExtraOptionsOrder(source.getExtraOptionsOrder());
        target.setName(source.getName());
        target.setHostname(source.getHostname());
        target.setDatabaseName(source.getDatabaseName());
        target.setDatabasePort(source.getDatabasePort());
        target.setUsername(source.getUsername());
        target.setPassword(source.getPassword());
        target.setStreamingResults(source.isStreamingResults());
        target.setDataTablespace(source.getDataTablespace());
        target.setIndexTablespace(source.getIndexTablespace());
        target.setUsingDoubleDecimalAsSchemaTableSeparator(source.isUsingDoubleDecimalAsSchemaTableSeparator());
        target.setInformixServername(source.getInformixServername());
        target.setAttributes(source.getAttributes());
        target.setChanged(source.getChanged());
        target.setQuoteAllFields(source.isQuoteAllFields());
        target.setForcingIdentifiersToLowerCase(source.isForcingIdentifiersToLowerCase());
        target.setForcingIdentifiersToUpperCase(source.isForcingIdentifiersToUpperCase());
        target.setConnectSql(source.getConnectSql());
        target.setUsingConnectionPool(source.isUsingConnectionPool());
        target.setInitialPoolSize(source.getInitialPoolSize());
        target.setMaximumPoolSize(source.getMaximumPoolSize());
        target.setPartitioned(source.isPartitioned());
        target.setConnectionPoolingProperties(source.getConnectionPoolingProperties());
        target.setPartitioningInformation(source.getPartitioningInformation());
    }

    protected AutoBean<IDatabaseConnection> createIDatabaseConnectionBean(IDatabaseConnection connection) {
        AutoBean bean = this.connectionAutoBeanFactory.iDatabaseConnection();
        IDatabaseConnection connectionBean = (IDatabaseConnection)bean.as();
        this.copyDatabaseConnectionProperties(connection, connectionBean);
        return AutoBeanUtils.getAutoBean((Object)connectionBean);
    }

    @Bindable
    public void init() {
        XulServiceCallback<List<IDatabaseType>> callback = new XulServiceCallback<List<IDatabaseType>>(){

            public void error(String message, Throwable error) {
                error.printStackTrace();
            }

            public void success(List<IDatabaseType> retVal) {
                ConnectionController.this.databaseTypeHelper = new DatabaseTypeHelper(retVal);
            }
        };
        this.dialectService.getDatabaseTypes((XulServiceCallback)callback);
        this.saveConnectionConfirmationDialog = (XulDialog)this.document.getElementById("saveConnectionConfirmationDialogConnectionController");
        this.overwriteConnectionConfirmationDialog = (XulDialog)this.document.getElementById("overwriteConnectionConfirmationDialogConnectionController");
        this.renameConnectionConfirmationDialog = (XulDialog)this.document.getElementById("renameConnectionConfirmationDialogConnectionController");
        this.errorDialog = (XulDialog)this.document.getElementById("errorDialog");
        this.errorLabel = (XulLabel)this.document.getElementById("errorLabel");
        this.successDialog = (XulDialog)this.document.getElementById("successDialog");
        this.successLabel = (XulLabel)this.document.getElementById("successLabel");
        this.removeConfirmationDialog = (XulDialog)this.document.getElementById("removeConfirmationDialogConnectionController");
        this.successDetailsDialog = (XulDialog)this.document.getElementById("successDetailsDialogConnectionController");
    }

    @Bindable
    public void openErrorDialog(String title, String message) {
        this.errorDialog.setTitle(title);
        this.errorLabel.setValue(message);
        this.errorDialog.show();
    }

    @Bindable
    public void closeErrorDialog() {
        if (!this.errorDialog.isHidden()) {
            this.errorDialog.hide();
        }
    }

    @Bindable
    public void openSuccesDialog(String title, String message) {
        this.successDialog.setTitle(title);
        this.successLabel.setValue(message);
        this.successDialog.show();
    }

    @Bindable
    public void closeSuccessDialog() {
        if (!this.successDialog.isHidden()) {
            this.successDialog.hide();
        }
    }

    @Bindable
    public void toggleDetails() {
        XulHbox details;
        details.setVisible(!(details = (XulHbox)this.document.getElementById("details_hider")).isVisible());
    }

    @Bindable
    public void toggleSuccessDetails() {
        XulHbox details;
        details.setVisible(!(details = (XulHbox)this.document.getElementById("success_details_hider")).isVisible());
    }

    public void setDatasourceModel(DatasourceModel model) {
        this.datasourceModel = model;
    }

    public DatasourceModel getDatasourceModel() {
        return this.datasourceModel;
    }

    public String getName() {
        return "connectionController";
    }

    @Bindable
    public void closeDialog() {
        for (ConnectionDialogListener listener : this.listeners) {
            listener.onDialogCancel();
        }
    }

    @Bindable
    public void handleDialogAccept() {
        RequestBuilder testConnectionBuilder = new RequestBuilder(RequestBuilder.PUT, ConnectionController.getServiceURL("test"));
        testConnectionBuilder.setHeader("Content-Type", "application/json");
        try {
            AutoBean<IDatabaseConnection> bean = this.createIDatabaseConnectionBean(this.currentConnection);
            testConnectionBuilder.sendRequest(AutoBeanCodex.encode(bean).getPayload(), new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    ConnectionController.this.saveConnectionConfirmationDialog.show();
                }

                public void onResponseReceived(Request request, Response response) {
                    try {
                        if (response.getStatusCode() == 200) {
                            ConnectionController.this.renameCheck();
                        } else {
                            ConnectionController.this.saveConnectionConfirmationDialog.show();
                        }
                    }
                    catch (Exception e) {
                        ConnectionController.this.displayErrorMessage(e);
                    }
                }
            });
        }
        catch (RequestException e) {
            this.displayErrorMessage(e);
        }
    }

    @Bindable
    public void renameCheck() {
        if (!this.saveConnectionConfirmationDialog.isHidden()) {
            this.closeSaveConnectionConfirmationDialog();
        }
        if (this.datasourceModel.isEditing() && !this.previousConnectionName.equals(this.currentConnection.getName())) {
            this.showRenameConnectionConfirmationDialog();
        } else {
            this.overwriteCheck();
        }
    }

    @Bindable
    public void overwriteCheck() {
        if (!this.saveConnectionConfirmationDialog.isHidden()) {
            this.closeSaveConnectionConfirmationDialog();
        }
        if (!this.renameConnectionConfirmationDialog.isHidden()) {
            this.closeRenameConnectionConfirmationDialog();
        }
        if (this.datasourceModel.isEditing() && this.previousConnectionName.equals(this.currentConnection.getName())) {
            this.updateConnection();
        } else {
            RequestBuilder checkConnectionBuilder = new RequestBuilder(RequestBuilder.GET, ConnectionController.getServiceURL("getid", new String[][]{{"name", this.currentConnection.getName()}}));
            checkConnectionBuilder.setHeader("Content-Type", "application/json");
            try {
                checkConnectionBuilder.sendRequest(null, new RequestCallback(){

                    public void onResponseReceived(Request request, Response response) {
                        switch (response.getStatusCode()) {
                            case 200: {
                                ConnectionController.this.existingConnectionId = response.getText();
                                ConnectionController.this.showOverwriteConnectionConfirmationDialog();
                                break;
                            }
                            case 404: {
                                ConnectionController.this.saveConnection();
                                break;
                            }
                            default: {
                                ConnectionController.this.saveConnection();
                            }
                        }
                    }

                    public void onError(Request request, Throwable exception) {
                        ConnectionController.this.displayErrorMessage(exception);
                    }
                });
            }
            catch (Exception e) {
                this.displayErrorMessage(e);
            }
        }
    }

    @Bindable
    public void updateConnection() {
        RequestBuilder updateConnectionBuilder = new RequestBuilder(RequestBuilder.POST, ConnectionController.getServiceURL("update"));
        updateConnectionBuilder.setHeader("Content-Type", "application/json");
        try {
            AutoBean<IDatabaseConnection> bean = this.createIDatabaseConnectionBean(this.currentConnection);
            updateConnectionBuilder.sendRequest(AutoBeanCodex.encode(bean).getPayload(), new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    ConnectionController.this.displayErrorMessage(exception);
                }

                public void onResponseReceived(Request request, Response response) {
                    try {
                        if (response.getStatusCode() == 200) {
                            ConnectionController.this.datasourceModel.getGuiStateModel().updateConnection(ConnectionController.this.existingConnectionName, ConnectionController.this.currentConnection);
                            ConnectionController.this.datasourceModel.setSelectedRelationalConnection(ConnectionController.this.currentConnection);
                            DialogController.DialogListener dialogListener = ConnectionController.this.connectionSetter.getOuterListener();
                            if (dialogListener != null) {
                                dialogListener.onDialogAccept((Object)ConnectionController.this.currentConnection);
                            }
                        } else {
                            ConnectionController.this.openErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("ConnectionController.ERROR_0004_UNABLE_TO_UPDATE_CONNECTION"));
                        }
                    }
                    catch (Exception e) {
                        ConnectionController.this.displayErrorMessage(e);
                    }
                }
            });
        }
        catch (RequestException e) {
            this.displayErrorMessage(e);
        }
    }

    @Bindable
    public void addConnection() {
        RequestBuilder addConnectionBuilder = new RequestBuilder(RequestBuilder.POST, ConnectionController.getServiceURL("add"));
        addConnectionBuilder.setHeader("Content-Type", "application/json");
        try {
            AutoBean<IDatabaseConnection> bean = this.createIDatabaseConnectionBean(this.currentConnection);
            addConnectionBuilder.sendRequest(AutoBeanCodex.encode(bean).getPayload(), new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    ConnectionController.this.displayErrorMessage(exception);
                }

                public void onResponseReceived(Request request, Response response) {
                    try {
                        if (response.getStatusCode() == 200) {
                            ConnectionController.this.datasourceModel.getGuiStateModel().addConnection(ConnectionController.this.currentConnection);
                            ConnectionController.this.datasourceModel.setSelectedRelationalConnection(ConnectionController.this.currentConnection);
                            DialogController.DialogListener dialogListener = ConnectionController.this.connectionSetter.getOuterListener();
                            if (dialogListener != null) {
                                dialogListener.onDialogAccept((Object)ConnectionController.this.currentConnection);
                            }
                        } else {
                            ConnectionController.this.openErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("ConnectionController.ERROR_0001_UNABLE_TO_ADD_CONNECTION"));
                        }
                    }
                    catch (Exception e) {
                        ConnectionController.this.displayErrorMessage(e);
                    }
                }
            });
        }
        catch (RequestException e) {
            this.displayErrorMessage(e);
        }
    }

    @Bindable
    public void overwriteConnection() {
        if (!this.saveConnectionConfirmationDialog.isHidden()) {
            this.closeSaveConnectionConfirmationDialog();
        }
        if (!this.renameConnectionConfirmationDialog.isHidden()) {
            this.closeRenameConnectionConfirmationDialog();
        }
        if (!this.overwriteConnectionConfirmationDialog.isHidden()) {
            this.overwriteConnectionConfirmationDialog.hide();
        }
        this.existingConnectionName = this.currentConnection.getName();
        this.currentConnection.setId(this.existingConnectionId);
        if (this.previousConnectionName != null) {
            RequestBuilder deleteConnectionBuilder = new RequestBuilder(RequestBuilder.DELETE, ConnectionController.getServiceURL("deletebyname", new String[][]{{"name", this.previousConnectionName}}));
            try {
                deleteConnectionBuilder.sendRequest(null, new RequestCallback(){

                    public void onError(Request request, Throwable exception) {
                        ConnectionController.this.displayErrorMessage(exception);
                    }

                    public void onResponseReceived(Request request, Response response) {
                        try {
                            if (response.getStatusCode() != 200) {
                                ConnectionController.this.openErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("ConnectionController.ERROR_0002_UNABLE_TO_DELETE_CONNECTION"));
                            }
                        }
                        catch (Exception e) {
                            ConnectionController.this.displayErrorMessage(e);
                        }
                    }
                });
            }
            catch (RequestException e) {
                this.displayErrorMessage(e);
            }
        }
        this.updateConnection();
    }

    @Bindable
    public void saveConnection() {
        if (!this.saveConnectionConfirmationDialog.isHidden()) {
            this.closeSaveConnectionConfirmationDialog();
        }
        if (!this.renameConnectionConfirmationDialog.isHidden()) {
            this.closeRenameConnectionConfirmationDialog();
        }
        if (!this.overwriteConnectionConfirmationDialog.isHidden()) {
            this.overwriteConnectionConfirmationDialog.hide();
        }
        if (this.datasourceModel.isEditing()) {
            this.updateConnection();
        } else {
            this.addConnection();
        }
    }

    @Bindable
    public void closeSaveConnectionConfirmationDialog() {
        this.saveConnectionConfirmationDialog.hide();
    }

    @Bindable
    public void testConnection() {
        RequestBuilder testConnectionBuilder = new RequestBuilder(RequestBuilder.PUT, ConnectionController.getServiceURL("test"));
        testConnectionBuilder.setHeader("Content-Type", "application/json");
        try {
            AutoBean bean = AutoBeanUtils.getAutoBean((Object)this.currentConnection);
            testConnectionBuilder.sendRequest(AutoBeanCodex.encode((AutoBean)bean).getPayload(), new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    ConnectionController.this.displayErrorMessage(exception);
                }

                public void onResponseReceived(Request request, Response response) {
                    Boolean testPassed = new Boolean(response.getText());
                    try {
                        if (testPassed.booleanValue()) {
                            ConnectionController.this.openSuccesDialog(MessageHandler.getString("SUCCESS"), MessageHandler.getString("ConnectionController.CONNECTION_TEST_SUCCESS"));
                        } else {
                            ConnectionController.this.openErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("ConnectionController.ERROR_0003_CONNECTION_TEST_FAILED"));
                        }
                    }
                    catch (Exception e) {
                        ConnectionController.this.displayErrorMessage(e);
                    }
                }
            });
        }
        catch (RequestException e) {
            this.displayErrorMessage(e);
        }
    }

    @Bindable
    public void deleteConnection() {
        this.removeConfirmationDialog.hide();
        RequestBuilder deleteConnectionBuilder = new RequestBuilder(RequestBuilder.DELETE, ConnectionController.getServiceURL("deletebyname", new String[][]{{"name", this.datasourceModel.getSelectedRelationalConnection().getName()}}));
        try {
            deleteConnectionBuilder.sendRequest(null, new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    ConnectionController.this.displayErrorMessage(exception);
                }

                public void onResponseReceived(Request request, Response response) {
                    try {
                        if (response.getStatusCode() == 200) {
                            ConnectionController.this.openSuccesDialog(MessageHandler.getString("SUCCESS"), MessageHandler.getString("ConnectionController.CONNECTION_DELETED"));
                            ConnectionController.this.datasourceModel.getGuiStateModel().deleteConnection(ConnectionController.this.datasourceModel.getSelectedRelationalConnection().getName());
                            List<IDatabaseConnection> connections = ConnectionController.this.datasourceModel.getGuiStateModel().getConnections();
                            if (connections != null && connections.size() > 0) {
                                ConnectionController.this.datasourceModel.setSelectedRelationalConnection(connections.get(connections.size() - 1));
                            } else {
                                ConnectionController.this.datasourceModel.setSelectedRelationalConnection(null);
                            }
                        } else {
                            ConnectionController.this.openErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("ConnectionController.ERROR_0002_UNABLE_TO_DELETE_CONNECTION"));
                        }
                    }
                    catch (Exception e) {
                        ConnectionController.this.displayErrorMessage(e);
                    }
                }
            });
        }
        catch (RequestException e) {
            this.displayErrorMessage(e);
        }
    }

    public void addConnectionDialogListener(ConnectionDialogListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeConnectionDialogListener(ConnectionDialogListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void displayErrorMessage(Throwable th) {
        this.errorDialog.setTitle(ExceptionParser.getErrorHeader(th, MessageHandler.getString("DatasourceEditor.USER_ERROR_TITLE")));
        this.errorLabel.setValue(ExceptionParser.getErrorMessage(th, MessageHandler.getString("DatasourceEditor.ERROR_0001_UNKNOWN_ERROR_HAS_OCCURED")));
        this.errorDialog.show();
    }

    public void showAddConnectionDialog(DialogController.DialogListener listener) {
        this.existingConnectionName = this.previousConnectionName = null;
        this.connectionSetter = new DatabaseConnectionSetter(listener);
        this.showAddConnectionDialog();
    }

    @Bindable
    public void showAddConnectionDialog() {
        this.datasourceModel.setEditing(false);
        if (this.databaseDialog != null) {
            this.databaseDialog.setDatabaseConnection(null);
            this.databaseDialog.show();
        } else {
            this.createNewDatabaseDialog();
        }
    }

    private void createNewDatabaseDialog() {
        if (this.databaseTypeHelper == null) {
            XulServiceCallback<List<IDatabaseType>> callback = new XulServiceCallback<List<IDatabaseType>>(){

                public void error(String message, Throwable error) {
                    Window.alert((String)(message + ":  " + error.getLocalizedMessage()));
                }

                public void success(List<IDatabaseType> retVal) {
                    ConnectionController.this.databaseTypeHelper = new DatabaseTypeHelper(retVal);
                    ConnectionController.this.databaseDialog = new GwtDatabaseDialog(ConnectionController.this.databaseTypeHelper, GWT.getModuleBaseURL() + "dataaccess-databasedialog.xul", (DatabaseDialogListener)ConnectionController.this.connectionSetter);
                }
            };
            this.dialectService.getDatabaseTypes((XulServiceCallback)callback);
        } else {
            this.databaseDialog = new GwtDatabaseDialog(this.databaseTypeHelper, GWT.getModuleBaseURL() + "dataaccess-databasedialog.xul", (DatabaseDialogListener)this.connectionSetter);
        }
    }

    @Bindable
    public void showEditConnectionDialog() {
        this.showEditConnectionDialog(null);
    }

    public void showEditConnectionDialog(DialogController.DialogListener dialogListener) {
        IDatabaseConnection connection = this.datasourceModel.getSelectedRelationalConnection();
        this.showEditConnectionDialog(dialogListener, connection);
    }

    public void showEditConnectionDialog(DialogController.DialogListener dialogListener, IDatabaseConnection connection) {
        this.connectionSetter = new DatabaseConnectionSetter(dialogListener);
        this.datasourceModel.setEditing(true);
        if (this.databaseDialog != null) {
            if (connection != null) {
                this.databaseDialog.setDatabaseConnection(connection);
                this.existingConnectionName = this.previousConnectionName = connection.getName();
                this.databaseDialog.show();
            } else {
                this.openErrorDialog(MessageHandler.getString("DatasourceEditor.USER_ERROR_TITLE"), MessageHandler.getString("DatasourceEditor.ERROR_0001_UNKNOWN_ERROR_HAS_OCCURED"));
            }
        } else {
            this.createNewDatabaseDialog();
        }
    }

    @Bindable
    public void showRemoveConnectionDialog() {
        this.removeConfirmationDialog.show();
    }

    @Bindable
    public void closeRemoveConfirmationDialog() {
        this.removeConfirmationDialog.hide();
    }

    public void showRenameConnectionConfirmationDialog() {
        this.renameConnectionConfirmationDialog.show();
    }

    @Bindable
    public void closeRenameConnectionConfirmationDialog() {
        this.renameConnectionConfirmationDialog.hide();
    }

    public void showOverwriteConnectionConfirmationDialog() {
        this.overwriteConnectionConfirmationDialog.show();
    }

    @Bindable
    public void closeOverwriteConnectionConfirmationDialog() {
        this.existingConnectionId = null;
        this.overwriteConnectionConfirmationDialog.hide();
    }

    @Bindable
    public void closeSuccessDetailsDialog() {
        if (!this.successDetailsDialog.isHidden()) {
            this.successDetailsDialog.hide();
        }
    }

    public void reloadConnections() {
        String cacheBuster = String.valueOf(new Date().getTime());
        String[][] params = new String[][]{{"ts", cacheBuster}};
        RequestBuilder listConnectionBuilder = new RequestBuilder(RequestBuilder.GET, ConnectionController.getServiceURL("list", params));
        listConnectionBuilder.setHeader("Content-Type", "application/json");
        try {
            listConnectionBuilder.sendRequest(null, new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    MessageHandler.getInstance().showErrorDialog(MessageHandler.getString("ERROR"), MessageHandler.getString("DatasourceEditor.ERROR_0002_UNABLE_TO_SHOW_DIALOG", exception.getLocalizedMessage()));
                }

                public void onResponseReceived(Request request, Response response) {
                    AutoBean bean = AutoBeanCodex.decode((AutoBeanFactory)ConnectionController.this.connectionAutoBeanFactory, IDatabaseConnectionList.class, (String)response.getText());
                    List connectionBeanList = ((IDatabaseConnectionList)bean.as()).getDatabaseConnections();
                    ArrayList<IDatabaseConnection> connectionImplList = new ArrayList<IDatabaseConnection>();
                    for (IDatabaseConnection connectionBean : connectionBeanList) {
                        try {
                            if (connectionBean.getAttributes() != null && connectionBean.getAttributes().get(ConnectionController.ATTRIBUTE_STANDARD_CONNECTION) != null && connectionBean.getAttributes().get(ConnectionController.ATTRIBUTE_STANDARD_CONNECTION) != Boolean.TRUE.toString()) continue;
                            connectionImplList.add(AutobeanUtilities.connectionBeanToImpl(connectionBean));
                        }
                        catch (Exception exception) {}
                    }
                    if (ConnectionController.this.datasourceModel != null) {
                        ConnectionController.this.datasourceModel.getGuiStateModel().setConnections(connectionImplList);
                    }
                }
            });
        }
        catch (RequestException e) {
            MessageHandler.getInstance().showErrorDialog(MessageHandler.getString("ERROR"), "DatasourceEditor.ERROR_0004_CONNECTION_SERVICE_NULL");
        }
    }

    public static String getBaseURL() {
        String moduleUrl = GWT.getModuleBaseURL();
        if (moduleUrl.indexOf("content") > -1) {
            String baseUrl = moduleUrl.substring(0, moduleUrl.indexOf("content"));
            return baseUrl + "plugin/data-access/api/connection/";
        }
        return moduleUrl + "plugin/data-access/api/connection/";
    }

    public static String getServiceURL(String action) {
        return ConnectionController.getBaseURL() + action;
    }

    public static String getServiceURL(String action, String[][] parameters) {
        StringBuilder stringBuilder = new StringBuilder(action);
        String[] encodeArguments = new String[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            stringBuilder.append(i == 0 ? "?" : "&");
            stringBuilder.append(parameters[i][0]);
            stringBuilder.append("=");
            stringBuilder.append("{" + i + "}");
            encodeArguments[i] = parameters[i][1];
        }
        return ConnectionController.getServiceURL(NameUtils.URLEncode((String)stringBuilder.toString(), (String[])encodeArguments));
    }

    class DatabaseConnectionSetter
    implements DatabaseDialogListener {
        final DialogController.DialogListener wrappedListener;

        public DatabaseConnectionSetter(DialogController.DialogListener listener) {
            this.wrappedListener = listener;
        }

        public DialogController.DialogListener getOuterListener() {
            return this.wrappedListener;
        }

        public void onDialogAccept(IDatabaseConnection connection) {
            ConnectionController.this.currentConnection = connection;
            ConnectionController.this.handleDialogAccept();
        }

        public void onDialogCancel() {
            this.wrappedListener.onDialogCancel();
        }

        public void onDialogReady() {
            if (!ConnectionController.this.datasourceModel.isEditing()) {
                ConnectionController.this.showAddConnectionDialog(this.wrappedListener);
            } else {
                ConnectionController.this.showEditConnectionDialog(this.wrappedListener);
            }
        }
    }
}

