/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard;

import org.pentaho.platform.dataaccess.datasource.wizard.IWizardDatasource;
import org.pentaho.platform.dataaccess.datasource.wizard.IWizardStep;
import org.pentaho.platform.dataaccess.datasource.wizard.models.IWizardModel;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulImage;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.containers.XulGrid;
import org.pentaho.ui.xul.containers.XulRow;
import org.pentaho.ui.xul.containers.XulRows;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.gwt.GwtXulDomContainer;
import org.pentaho.ui.xul.gwt.binding.GwtBindingFactory;
import org.pentaho.ui.xul.gwt.tags.GwtImage;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

public abstract class AbstractWizardStep
extends AbstractXulEventHandler
implements IWizardStep {
    public static final String VALID_PROPERTY_NAME = "valid";
    public static final String PREVIEWABLE_PROPERTY_NAME = "previewable";
    public static final String FINISHABLE_PROPERTY_NAME = "finishable";
    public static final String DISABLED_PROPERTY_NAME = "disabled";
    public static final String STEP_GRID_ID = "step_grid";
    public static final String STEP_ROWS_ID = "step_rows";
    public static final String XUL_ROW_TYPE = "row";
    public static final String XUL_IMAGE_TYPE = "image";
    public static final String XUL_LABEL_TYPE = "label";
    public static final String STEP_IMAGE_SRC = "images/spacer.gif";
    public static final String SPACER_IMAGE_SRC = "images/empty_spacer.png";
    protected GwtXulDomContainer mainContainer;
    private boolean disabled = false;
    private boolean valid;
    protected BindingFactory bf;
    protected XulImage stepImage;
    protected XulLabel stepLabel;
    protected XulRow stepRow;
    protected boolean activated;
    protected IWizardDatasource parentDatasource;
    protected IWizardModel wizardModel;

    protected AbstractWizardStep(IWizardDatasource parentDatasource) {
        this.parentDatasource = parentDatasource;
    }

    @Override
    @Bindable
    public boolean isValid() {
        return this.valid;
    }

    @Override
    @Bindable
    public void setValid(boolean valid) {
        this.valid = valid;
        this.firePropertyChange(VALID_PROPERTY_NAME, !valid, this.valid);
    }

    @Override
    public void init(IWizardModel wizardModel) throws XulException {
        this.wizardModel = wizardModel;
        this.bf = new GwtBindingFactory(this.document);
        this.setBindings();
    }

    @Override
    public void activating() throws XulException {
        XulGrid stepGrid = (XulGrid)this.document.getElementById(STEP_GRID_ID);
        XulRows stepRows = (XulRows)this.document.getElementById(STEP_ROWS_ID);
        this.stepRow = (XulRow)this.document.createElement(XUL_ROW_TYPE);
        stepRows.addChild((Element)this.stepRow);
        this.stepImage = (XulImage)this.document.createElement(XUL_IMAGE_TYPE);
        this.stepImage.setSrc(STEP_IMAGE_SRC);
        this.stepImage.setId(this.getStepName());
        this.stepImage.setVisible(false);
        ((GwtImage)this.stepImage).setAttribute("pen:classname", "pentaho-chevron");
        this.stepRow.addChild((Element)this.stepImage);
        this.stepLabel = (XulLabel)this.document.createElement(XUL_LABEL_TYPE);
        this.stepLabel.setValue(this.getStepName());
        this.stepLabel.setFlex(1);
        this.stepRow.addChild((Element)this.stepLabel);
        stepGrid.update();
        this.activated = true;
    }

    @Override
    public void deactivate() {
        XulGrid stepGrid = (XulGrid)this.document.getElementById(STEP_GRID_ID);
        XulRows stepRows = (XulRows)this.document.getElementById(STEP_ROWS_ID);
        stepRows.removeChild((Element)this.stepRow);
        stepGrid.update();
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        boolean oldDisabled = this.disabled;
        this.disabled = disabled;
        if (this.stepLabel != null) {
            this.stepLabel.setDisabled(this.disabled);
        }
        this.firePropertyChange(DISABLED_PROPERTY_NAME, oldDisabled, this.disabled);
    }

    @Override
    public void stepActivatingForward() {
        this.setStepImageVisible(true);
    }

    @Override
    public void stepActivatingReverse() {
        this.setStepImageVisible(true);
    }

    @Override
    public boolean stepDeactivatingForward() {
        this.setStepImageVisible(false);
        return true;
    }

    public void setStepImageVisible(boolean visible) {
        if (this.stepImage != null) {
            this.stepImage.setVisible(visible);
        }
    }

    @Override
    public boolean stepDeactivatingReverse() {
        return this.stepDeactivatingForward();
    }
}

