/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.ui.admindialog;

import com.google.gwt.user.client.Window;
import java.util.List;
import org.pentaho.agilebi.modeler.services.IModelerServiceAsync;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.gwt.widgets.client.dialogs.MessageDialogBox;
import org.pentaho.metadata.model.Domain;
import org.pentaho.platform.dataaccess.datasource.DatasourceInfo;
import org.pentaho.platform.dataaccess.datasource.IDatasourceInfo;
import org.pentaho.platform.dataaccess.datasource.beans.LogicalModelSummary;
import org.pentaho.platform.dataaccess.datasource.ui.admindialog.DatasourceAdminDialogModel;
import org.pentaho.platform.dataaccess.datasource.ui.service.DSWUIDatasourceService;
import org.pentaho.platform.dataaccess.datasource.ui.service.IUIDatasourceAdminService;
import org.pentaho.platform.dataaccess.datasource.ui.service.JdbcDatasourceService;
import org.pentaho.platform.dataaccess.datasource.ui.service.MetadataUIDatasourceService;
import org.pentaho.platform.dataaccess.datasource.ui.service.MondrianUIDatasourceService;
import org.pentaho.platform.dataaccess.datasource.ui.service.UIDatasourceServiceManager;
import org.pentaho.platform.dataaccess.datasource.wizard.GwtDatasourceEditorEntryPoint;
import org.pentaho.platform.dataaccess.datasource.wizard.GwtDatasourceMessages;
import org.pentaho.platform.dataaccess.datasource.wizard.service.IXulAsyncDSWDatasourceService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.IXulAsyncDatasourceServiceManager;
import org.pentaho.ui.database.gwt.GwtDatabaseDialog;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingException;
import org.pentaho.ui.xul.binding.BindingExceptionHandler;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulMenuitem;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulMenupopup;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulTreeCols;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.util.AbstractXulDialogController;
import org.pentaho.ui.xul.util.DialogController;

public class DatasourceAdminDialogController
extends AbstractXulDialogController<IDatasourceInfo>
implements BindingExceptionHandler {
    private static final String IMPORT_MSG_ID = "datasourceAdminDialog.IMPORT";
    private static final String PLUGIN_MSG_ID = "datasourceAdminDialog.PLUGIN";
    private static final String REMOVE_DS_MSG_ID = "removeDatasourceConfirmationDialog.message";
    private BindingFactory bf;
    private IXulAsyncDatasourceServiceManager datasourceServiceManager;
    private IModelerServiceAsync modelerService;
    private IXulAsyncDSWDatasourceService dswService;
    private DatasourceAdminDialogModel datasourceAdminDialogModel = new DatasourceAdminDialogModel();
    private XulDialog datasourceAdminDialog;
    private XulDialog datasourceAdminErrorDialog;
    private XulDialog removeDatasourceConfirmationDialog;
    private XulLabel datasourceAdminErrorLabel = null;
    private XulButton datasourceAddButton;
    private XulMenupopup datasourceTypeMenuPopup;
    private XulMenuitem exportDatasourceMenuItem;
    private XulMenuitem editDatasourceMenuItem;
    private XulMenuitem removeDatasourceMenuItem;
    private Binding editDatasourceButtonBinding;
    private Binding removeDatasourceButtonBinding;
    private Binding exportDatasourceButtonBinding;
    private GwtDatabaseDialog databaseDialog;
    private boolean administrator;
    XulTree datasourceTable = null;
    XulTreeCols datasourceTreeCols = null;
    UIDatasourceServiceManager manager;
    private GwtDatasourceEditorEntryPoint entryPoint;
    private DialogController.DialogListener adminDatasourceListener;
    private GwtDatasourceMessages messageBundle;

    @Bindable
    public void init() {
        this.datasourceTable = (XulTree)this.document.getElementById("datasourcesListTable");
        this.datasourceTreeCols = (XulTreeCols)this.document.getElementById("datasourcesListCols");
        this.datasourceAdminDialog = (XulDialog)this.document.getElementById("datasourceAdminDialog");
        this.datasourceAdminErrorDialog = (XulDialog)this.document.getElementById("datasourceAdminErrorDialog");
        this.removeDatasourceConfirmationDialog = (XulDialog)this.document.getElementById("removeDatasourceConfirmationDialog");
        this.datasourceAdminErrorLabel = (XulLabel)this.document.getElementById("datasourceAdminErrorLabel");
        this.datasourceAddButton = (XulButton)this.document.getElementById("datasourceAddButton");
        this.datasourceTypeMenuPopup = (XulMenupopup)this.document.getElementById("datasourceTypeMenuPopup");
        this.exportDatasourceMenuItem = (XulMenuitem)this.document.getElementById("exportDatasourceMenuItem");
        this.editDatasourceMenuItem = (XulMenuitem)this.document.getElementById("editDatasourceMenuItem");
        this.removeDatasourceMenuItem = (XulMenuitem)this.document.getElementById("removeDatasourceMenuItem");
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        try {
            BindingConvertor<IDatasourceInfo, Boolean> removeDatasourceButtonConvertor = new BindingConvertor<IDatasourceInfo, Boolean>(){

                public Boolean sourceToTarget(IDatasourceInfo datasourceInfo) {
                    return datasourceInfo.isRemovable();
                }

                public IDatasourceInfo targetToSource(Boolean value) {
                    throw new UnsupportedOperationException();
                }
            };
            BindingConvertor<IDatasourceInfo, Boolean> editDatasourceButtonConvertor = new BindingConvertor<IDatasourceInfo, Boolean>(){

                public Boolean sourceToTarget(IDatasourceInfo datasourceInfo) {
                    return datasourceInfo.isEditable();
                }

                public IDatasourceInfo targetToSource(Boolean value) {
                    throw new UnsupportedOperationException();
                }
            };
            BindingConvertor<IDatasourceInfo, Boolean> exportDatasourceButtonConvertor = new BindingConvertor<IDatasourceInfo, Boolean>(){

                public Boolean sourceToTarget(IDatasourceInfo datasourceInfo) {
                    return datasourceInfo.isExportable();
                }

                public IDatasourceInfo targetToSource(Boolean value) {
                    throw new UnsupportedOperationException();
                }
            };
            this.removeDatasourceButtonBinding = this.bf.createBinding((Object)this.datasourceAdminDialogModel, "selectedDatasource", (Object)this.removeDatasourceMenuItem, "!disabled", new BindingConvertor[]{removeDatasourceButtonConvertor});
            this.editDatasourceButtonBinding = this.bf.createBinding((Object)this.datasourceAdminDialogModel, "selectedDatasource", (Object)this.editDatasourceMenuItem, "!disabled", new BindingConvertor[]{editDatasourceButtonConvertor});
            this.exportDatasourceButtonBinding = this.bf.createBinding((Object)this.datasourceAdminDialogModel, "selectedDatasource", (Object)this.exportDatasourceMenuItem, "!disabled", new BindingConvertor[]{exportDatasourceButtonConvertor});
            this.bf.createBinding((Object)this.datasourceAdminDialogModel, "datasources", (Object)this.datasourceTable, "elements", new BindingConvertor[0]);
            this.bf.createBinding((Object)this.datasourceTable, "selectedItems", (Object)this.datasourceAdminDialogModel, "selectedDatasource", new BindingConvertor[]{new BindingConvertor<List, IDatasourceInfo>(){

                public IDatasourceInfo sourceToTarget(List datasources) {
                    if (datasources != null && datasources.size() > 0) {
                        return (IDatasourceInfo)datasources.get(0);
                    }
                    return null;
                }

                public List targetToSource(IDatasourceInfo arg0) {
                    throw new UnsupportedOperationException();
                }
            }}).fireSourceChanged();
            this.bf.createBinding((Object)this.datasourceTable, "selectedItem", (Object)this.datasourceAdminDialogModel, "selectedDatasource", new BindingConvertor[0]).fireSourceChanged();
            this.removeDatasourceButtonBinding.fireSourceChanged();
            this.editDatasourceButtonBinding.fireSourceChanged();
            this.exportDatasourceButtonBinding.fireSourceChanged();
            this.setupNativeHooks(this);
            this.adminDatasourceListener = new DialogController.DialogListener(){

                public void onDialogAccept(Object returnValue) {
                    DatasourceAdminDialogController.this.refreshDatasourceList();
                }

                public void onDialogCancel() {
                }

                public void onDialogReady() {
                }

                public void onDialogError(String errorMessage) {
                    DatasourceAdminDialogController.this.openErrorDialog("Error", errorMessage);
                }
            };
            this.manager = UIDatasourceServiceManager.getInstance();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private native void setupNativeHooks(DatasourceAdminDialogController var1);

    public String getName() {
        return "datasourceAdminDialogController";
    }

    public void setBindingFactory(BindingFactory bf) {
        this.bf = bf;
        this.bf.setExceptionHandler((BindingExceptionHandler)this);
    }

    public void setDatasourceServiceManager(IXulAsyncDatasourceServiceManager datasourceServiceManager) {
        this.datasourceServiceManager = datasourceServiceManager;
    }

    public void setModelerService(IModelerServiceAsync modelerService) {
        this.modelerService = modelerService;
    }

    public void setDSWService(IXulAsyncDSWDatasourceService dswService) {
        this.dswService = dswService;
    }

    private void refreshDatasourceList() {
        if (this.messageBundle != null) {
            DatasourceInfo.setMessageBundle(this.messageBundle);
        }
        this.datasourceAdminDialogModel.setDatasourcesList(null);
        this.manager.getIds(new XulServiceCallback<List<IDatasourceInfo>>(){

            public void success(List<IDatasourceInfo> infoList) {
                DatasourceAdminDialogController.super.showDialog();
                DatasourceAdminDialogController.this.datasourceAdminDialogModel.setDatasourcesList(infoList);
                DatasourceAdminDialogController.this.getDatasourceTypes();
                DatasourceAdminDialogController.this.exportDatasourceMenuItem.setDisabled(true);
                DatasourceAdminDialogController.this.editDatasourceMenuItem.setDisabled(true);
                DatasourceAdminDialogController.this.removeDatasourceMenuItem.setDisabled(true);
            }

            public void error(String message, Throwable error) {
                DatasourceAdminDialogController.this.openErrorDialog("Error", message + error.getMessage());
            }
        });
    }

    private void getDatasourceTypes() {
        List<String> datasourceTypes = this.manager.getTypes();
        List components = this.datasourceTypeMenuPopup.getChildNodes();
        for (int i = 0; i < components.size(); ++i) {
            XulComponent component = (XulComponent)components.get(i);
            if (component.getId() == null || !component.getId().startsWith("import") && !component.getId().startsWith("plugin")) continue;
            this.datasourceTypeMenuPopup.removeComponent(component);
        }
        components = this.datasourceTypeMenuPopup.getChildNodes();
        int beforePlugins = 0;
        XulComponent beforePluginsMenuItem = null;
        for (int i = 0; i < components.size(); ++i) {
            XulComponent component = (XulComponent)components.get(i);
            if (!"beforePlugins".equals(component.getId())) continue;
            beforePlugins = i;
            beforePluginsMenuItem = component;
        }
        List<IDatasourceInfo> datasourceInfoList = this.datasourceAdminDialogModel.getDatasourcesList();
        for (String datasourceType : datasourceTypes) {
            IUIDatasourceAdminService datasourceAdminService = this.manager.getService(datasourceType);
            if (datasourceAdminService instanceof DSWUIDatasourceService || datasourceAdminService instanceof JdbcDatasourceService || !(datasourceAdminService instanceof MondrianUIDatasourceService) && !(datasourceAdminService instanceof MetadataUIDatasourceService) || !datasourceAdminService.isCreatable()) continue;
            try {
                String displayName = DatasourceInfo.getDisplayType(datasourceType, this.messageBundle);
                String label = this.messageBundle.getString(IMPORT_MSG_ID, displayName);
                XulMenuitem menuItem = (XulMenuitem)this.document.createElement("menuitem");
                menuItem.setLabel(label);
                menuItem.setCommand(this.getName() + ".launchNewUI(\"" + datasourceType + "\")");
                menuItem.setId("import" + datasourceType);
                this.datasourceTypeMenuPopup.addChildAt((Element)menuItem, beforePlugins++);
            }
            catch (XulException e) {
                throw new RuntimeException(e);
            }
        }
        boolean hasPlugins = false;
        ++beforePlugins;
        for (String datasourceType : datasourceTypes) {
            IUIDatasourceAdminService datasourceAdminService = this.manager.getService(datasourceType);
            if (datasourceAdminService instanceof DSWUIDatasourceService || datasourceAdminService instanceof JdbcDatasourceService || datasourceAdminService instanceof MondrianUIDatasourceService || datasourceAdminService instanceof MetadataUIDatasourceService || !datasourceAdminService.isCreatable()) continue;
            hasPlugins = true;
            try {
                String displayName = DatasourceInfo.getDisplayType(datasourceType, this.messageBundle);
                String label = this.messageBundle.getString(PLUGIN_MSG_ID, displayName);
                XulMenuitem menuItem = (XulMenuitem)this.document.createElement("menuitem");
                menuItem.setLabel(label);
                menuItem.setCommand(this.getName() + ".launchNewUI(\"" + datasourceType + "\")");
                menuItem.setId("plugin" + datasourceType);
                this.datasourceTypeMenuPopup.addChildAt((Element)menuItem, beforePlugins++);
            }
            catch (XulException e) {
                throw new RuntimeException(e);
            }
        }
        beforePluginsMenuItem.setVisible(hasPlugins);
        this.datasourceAdminDialogModel.setDatasourceTypeList(datasourceTypes);
    }

    @Bindable
    public void launchNewUI(String datasourceType) {
        IUIDatasourceAdminService service = this.manager.getService(datasourceType);
        String newUI = service.getNewUI();
        if (newUI != null && newUI.length() > 0) {
            if (newUI.indexOf("builtin:") >= 0) {
                if (service.getType().equals("JDBC")) {
                    this.entryPoint.showDatabaseDialog((DialogController.DialogListener<IDatabaseConnection>)this.adminDatasourceListener);
                } else if (service.getType().equals("Analysis")) {
                    this.entryPoint.showAnalysisImportDialog(this.adminDatasourceListener);
                } else if (service.getType().equals("Metadata")) {
                    this.entryPoint.showMetadataImportDialog(this.adminDatasourceListener);
                } else if (service.getType().equals("Data Source Wizard")) {
                    this.entryPoint.showWizard(true, (DialogController.DialogListener<Domain>)this.adminDatasourceListener);
                }
            } else if (newUI.indexOf("javascript:") >= 0) {
                String script = newUI.substring(newUI.indexOf(":") + 1);
                this.executeJavaScript(script);
            }
        }
    }

    private native void executeJavaScript(String var1);

    public void showDialog() {
        this.refreshDatasourceList();
    }

    protected XulDialog getDialog() {
        return this.datasourceAdminDialog;
    }

    protected IDatasourceInfo getDialogResult() {
        return this.datasourceAdminDialogModel.getDatasourcesList().get(this.datasourceAdminDialogModel.getSelectedIndex());
    }

    @Bindable
    public void openErrorDialog(String title, String message) {
        this.datasourceAdminErrorDialog.setTitle(title);
        this.datasourceAdminErrorLabel.setValue(message);
        this.datasourceAdminErrorDialog.show();
    }

    @Bindable
    public void closeErrorDialog() {
        if (!this.datasourceAdminErrorDialog.isHidden()) {
            this.datasourceAdminErrorDialog.hide();
            this.refreshDatasourceList();
        }
    }

    public void setEntryPoint(GwtDatasourceEditorEntryPoint entryPoint) {
        this.entryPoint = entryPoint;
    }

    public void handleException(BindingException t) {
        t.printStackTrace();
    }

    @Bindable
    public void export() {
        IDatasourceInfo dsInfo = this.datasourceAdminDialogModel.getSelectedDatasource();
        if (dsInfo == null) {
            this.showErrorDialog("datasourceAdminErrorDialog.SELECT_DATASOURCE", "datasourceAdminErrorDialog.SELECT_DATASOURCE_EXPORT");
            return;
        }
        if ("JDBC".equals(dsInfo.getType())) {
            this.showErrorDialog("datasourceAdminErrorDialog.CANNOT_EXPORT_HEADER", "datasourceAdminErrorDialog.CANNOT_EXPORT_TEXT");
            return;
        }
        this.manager.exportDatasource(dsInfo);
    }

    @Bindable
    public void remove() {
        IDatasourceInfo dsInfo = this.datasourceAdminDialogModel.getSelectedDatasource();
        if (dsInfo == null) {
            this.showErrorDialog("datasourceAdminErrorDialog.SELECT_DATASOURCE", "datasourceAdminErrorDialog.SELECT_DATASOURCE_DELETE");
            return;
        }
        if (this.messageBundle != null) {
            XulLabel removeDatasourceConfirmationDialogLabel = (XulLabel)this.removeDatasourceConfirmationDialog.getElementById("removeDatasourceConfirmationDialogLabel");
            removeDatasourceConfirmationDialogLabel.setValue(this.messageBundle.getString(REMOVE_DS_MSG_ID, dsInfo.getName()));
        }
        this.removeDatasourceConfirmationDialog.show();
    }

    @Bindable
    public void edit() {
        IDatasourceInfo dsInfo = this.datasourceAdminDialogModel.getSelectedDatasource();
        if (dsInfo == null) {
            this.showErrorDialog("datasourceAdminErrorDialog.SELECT_DATASOURCE", "datasourceAdminErrorDialog.SELECT_DATASOURCE_EDIT");
            return;
        }
        String type = dsInfo.getType();
        final String dsId = dsInfo.getId();
        if ("Data Source Wizard".equals(type)) {
            this.dswService.getLogicalModels(dsId, new XulServiceCallback<List<LogicalModelSummary>>(){

                public void success(List<LogicalModelSummary> retVal) {
                    for (LogicalModelSummary logicalModelSummary : retVal) {
                        if (!dsId.equals(logicalModelSummary.getDomainId())) continue;
                        DatasourceAdminDialogController.this.entryPoint.showWizardEdit(logicalModelSummary.getDomainId(), logicalModelSummary.getModelId(), false, new DialogController.DialogListener<Domain>(){

                            public void onDialogAccept(Domain returnValue) {
                            }

                            public void onDialogCancel() {
                            }

                            public void onDialogReady() {
                            }

                            public void onDialogError(String errorMessage) {
                            }
                        });
                    }
                }

                public void error(String message, Throwable error) {
                }
            });
        } else if ("JDBC".equals(type)) {
            this.entryPoint.showEditDatabaseDialog(this.adminDatasourceListener, dsId);
        } else if ("Analysis".equals(type)) {
            IDatasourceInfo datasourceInfo = this.datasourceAdminDialogModel.getSelectedDatasource();
            this.entryPoint.showEditAnalysisDialog(this.adminDatasourceListener, datasourceInfo);
        } else if ("Metadata".equals(type)) {
            this.showErrorDialog("datasourceAdminErrorDialog.CANNOT_EDIT_HEADER", "datasourceAdminErrorDialog.CANNOT_EDIT_TEXT");
            return;
        }
    }

    @Bindable
    public void newConnection() {
        this.launchNewUI("JDBC");
    }

    @Bindable
    public void newDataSource() {
        this.launchNewUI("Data Source Wizard");
    }

    @Bindable
    public void removeDatasourceAccept() {
        final IDatasourceInfo dsInfo = this.datasourceAdminDialogModel.getSelectedDatasource();
        this.manager.remove(dsInfo, new XulServiceCallback<Boolean>(){

            public void success(Boolean isOk) {
                if (isOk.booleanValue()) {
                    DatasourceAdminDialogController.this.refreshDatasourceList();
                    DatasourceAdminDialogController.this.editDatasourceMenuItem.setDisabled(true);
                } else {
                    Window.alert((String)(DatasourceAdminDialogController.this.messageBundle.getString("datasourceAdminDialogController.COULD_NOT_REMOVE") + ": " + dsInfo.getId()));
                }
            }

            public void error(String message, Throwable error) {
                Window.alert((String)(DatasourceAdminDialogController.this.messageBundle.getString("datasourceAdminDialogController.ERROR_REMOVING") + ": " + dsInfo.getId() + "." + DatasourceAdminDialogController.this.messageBundle.getString("ERROR") + "=" + error.getLocalizedMessage()));
            }
        });
        this.removeDatasourceConfirmationDialog.hide();
    }

    @Bindable
    public void removeDatasourceCancel() {
        this.removeDatasourceConfirmationDialog.hide();
    }

    public void setMessageBundle(GwtDatasourceMessages messageBundle) {
        this.messageBundle = messageBundle;
    }

    private void showErrorDialog(String titleKey, String messageKey) {
        MessageDialogBox b = new MessageDialogBox(this.messageBundle.getString(titleKey), this.messageBundle.getString(messageKey), false, false, true, this.messageBundle.getString("dialog.button.ok"));
        b.getElement().getStyle().setZIndex(Short.MAX_VALUE);
        b.center();
        b.show();
    }
}

