/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.modeler;

import com.google.gwt.core.client.GWT;
import org.pentaho.agilebi.modeler.ColResolverController;
import org.pentaho.agilebi.modeler.IModelerMessages;
import org.pentaho.agilebi.modeler.IModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerController;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.ModelerUiHelper;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.geo.GeoContext;
import org.pentaho.agilebi.modeler.gwt.BogoPojo;
import org.pentaho.agilebi.modeler.gwt.GwtModelerMessages;
import org.pentaho.agilebi.modeler.gwt.GwtModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.services.IModelerServiceAsync;
import org.pentaho.agilebi.modeler.services.impl.GwtModelerServiceImpl;
import org.pentaho.gwt.widgets.client.utils.i18n.ResourceBundle;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.platform.dataaccess.datasource.wizard.EmbeddedWizard;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.MessageHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.service.IXulAsyncDSWDatasourceService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.gwt.ICsvDatasourceService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.gwt.ICsvDatasourceServiceAsync;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.DSWDatasourceServiceGwtImpl;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.gwt.GwtXulRunner;
import org.pentaho.ui.xul.gwt.binding.GwtBindingFactory;
import org.pentaho.ui.xul.gwt.util.AsyncConstructorListener;
import org.pentaho.ui.xul.gwt.util.AsyncXulLoader;
import org.pentaho.ui.xul.gwt.util.IXulLoaderCallback;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.util.AbstractXulDialogController;
import org.pentaho.ui.xul.util.DialogController;

public class ModelerDialog
extends AbstractXulDialogController<Domain>
implements IXulLoaderCallback {
    private XulDomContainer container;
    private DialogController.DialogListener<Domain> listener;
    private IModelerServiceAsync service = new GwtModelerServiceImpl();
    private ModelerWorkspace model = new ModelerWorkspace((IModelerWorkspaceHelper)new GwtModelerWorkspaceHelper());
    private ModelerController controller;
    private IModelerMessages messages;
    private XulDialog errorDialog;
    private EmbeddedWizard wizard;
    private IXulAsyncDSWDatasourceService datasourceService;
    private ICsvDatasourceServiceAsync csvService;
    private AsyncConstructorListener constructorListener;
    private static ModelerDialog instance;
    private static String EDIT_TOOLBAR_BUTTON_ID;

    private ModelerDialog(AsyncConstructorListener<ModelerDialog> constructorListener) {
        this(null, constructorListener);
    }

    private ModelerDialog(EmbeddedWizard wizard, AsyncConstructorListener<ModelerDialog> constructorListener) {
        this.wizard = wizard;
        this.constructorListener = constructorListener;
        AsyncXulLoader.loadXulFromUrl((String)(GWT.getModuleBaseURL() + "modeler.xul"), (String)(GWT.getModuleBaseURL() + "modeler"), (IXulLoaderCallback)this);
    }

    public static ModelerDialog getInstance(AsyncConstructorListener<ModelerDialog> constructorListener) {
        if (instance != null) {
            constructorListener.asyncConstructorDone((Object)instance);
            return instance;
        }
        instance = new ModelerDialog(constructorListener);
        return instance;
    }

    public static ModelerDialog getInstance(EmbeddedWizard wizard, AsyncConstructorListener<ModelerDialog> constructorListener) {
        if (instance != null) {
            constructorListener.asyncConstructorDone((Object)instance);
            return instance;
        }
        instance = new ModelerDialog(wizard, constructorListener);
        return instance;
    }

    protected XulDialog getDialog() {
        return (XulDialog)this.container.getDocumentRoot().getElementById("modeler_dialog");
    }

    protected Domain getDialogResult() {
        return null;
    }

    @Bindable
    public void onAccept() {
        this.enableWaitCursor(true);
        try {
            this.model.getWorkspaceHelper().populateDomain(this.model);
        }
        catch (ModelerException e) {
            e.printStackTrace();
            this.showErrorDialog(this.messages.getString("ModelEditor.ERROR", new String[0]), this.messages.getString("ModelEditor.ERROR_0001_SAVING_MODELS", new String[0]));
        }
        boolean doOlap = true;
        LogicalModel lModel = this.model.getLogicalModel(ModelerPerspective.ANALYSIS);
        if (lModel == null) {
            lModel = this.model.getLogicalModel(ModelerPerspective.REPORTING);
        }
        if (lModel.getProperty("MondrianCatalogRef") == null && (lModel.getProperty("DUAL_MODELING_SCHEMA") == null || "false".equals(lModel.getProperty("DUAL_MODELING_SCHEMA")))) {
            doOlap = false;
        }
        this.service.serializeModels(this.model.getDomain(), this.model.getModelName(), doOlap, (XulServiceCallback)new XulServiceCallback<String>(){

            public void success(String retVal) {
                ModelerDialog.this.enableWaitCursor(false);
                ModelerDialog.this.hideDialog();
                ModelerDialog.this.model.getDomain().setId(retVal);
                ModelerDialog.this.listener.onDialogAccept((Object)ModelerDialog.this.model.getDomain());
            }

            public void error(String message, Throwable error) {
                ModelerDialog.this.enableWaitCursor(false);
                ModelerDialog.this.showErrorDialog(ModelerDialog.this.messages.getString("ModelEditor.ERROR", new String[0]), ModelerDialog.this.messages.getString("ModelEditor.ERROR_0001_SAVING_MODELS", new String[0]));
            }
        });
    }

    protected void showErrorDialog(String title, String message) {
        this.errorDialog = (XulDialog)this.container.getDocumentRoot().getElementById("errorDialog");
        XulLabel errorLabel = (XulLabel)this.container.getDocumentRoot().getElementById("errorLabel");
        this.errorDialog.setTitle(title);
        errorLabel.setValue(message);
        this.errorDialog.show();
    }

    @Bindable
    public void onLoad() {
    }

    public void xulLoaded(GwtXulRunner gwtXulRunner) {
        this.container = (XulDomContainer)gwtXulRunner.getXulDomContainers().get(0);
        this.container.addEventHandler((XulEventHandler)this);
        BogoPojo bogo = new BogoPojo();
        this.service.gwtWorkaround(bogo, (XulServiceCallback)new XulServiceCallback<BogoPojo>(){

            public void success(BogoPojo retVal) {
            }

            public void error(String message, Throwable error) {
            }
        });
        this.datasourceService = new DSWDatasourceServiceGwtImpl();
        this.csvService = (ICsvDatasourceServiceAsync)GWT.create(ICsvDatasourceService.class);
        if (this.wizard == null) {
            this.wizard = new EmbeddedWizard(false);
            this.wizard.setDatasourceService(this.datasourceService);
            this.wizard.setCsvDatasourceService(this.csvService);
            this.wizard.init(null);
        }
        this.messages = new GwtModelerMessages((ResourceBundle)this.container.getResourceBundles().get(0));
        try {
            ModelerMessagesHolder.setMessages((IModelerMessages)this.messages);
        }
        catch (Exception exception) {
            // empty catch block
        }
        IModelerWorkspaceHelper workspacehelper = this.model.getWorkspaceHelper();
        this.controller = new ModelerController(this.model);
        this.controller.setWorkspaceHelper(workspacehelper);
        GwtBindingFactory bf = new GwtBindingFactory(this.container.getDocumentRoot());
        this.controller.setBindingFactory((BindingFactory)bf);
        this.container.addEventHandler((XulEventHandler)this.controller);
        try {
            this.controller.init();
        }
        catch (ModelerException e) {
            e.printStackTrace();
        }
        bf.setBindingType(Binding.Type.ONE_WAY);
        bf.createBinding((Object)this.model, "valid", "modeler_dialog_accept", "disabled", new BindingConvertor[]{new BindingConvertor<Boolean, Boolean>(){

            public Boolean sourceToTarget(Boolean value) {
                return value == false;
            }

            public Boolean targetToSource(Boolean value) {
                return value == false;
            }
        }});
        bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.datasourceService.getGeoContext(new XulServiceCallback<GeoContext>((BindingFactory)bf){
            final /* synthetic */ BindingFactory val$bf;
            {
                this.val$bf = bindingFactory;
            }

            public void success(GeoContext geoContext) {
                ModelerDialog.this.model.setGeoContext(geoContext);
                ModelerUiHelper.configureControllers((XulDomContainer)ModelerDialog.this.container, (ModelerWorkspace)ModelerDialog.this.model, (BindingFactory)this.val$bf, (ModelerController)ModelerDialog.this.controller, (ColResolverController)new ColResolverController());
                ModelerDialog.this.constructorListener.asyncConstructorDone((Object)ModelerDialog.this);
            }

            public void error(String s, Throwable throwable) {
                throwable.printStackTrace();
                ModelerDialog.this.model.setGeoContext(new GeoContext());
                ModelerUiHelper.configureControllers((XulDomContainer)ModelerDialog.this.container, (ModelerWorkspace)ModelerDialog.this.model, (BindingFactory)this.val$bf, (ModelerController)ModelerDialog.this.controller, (ColResolverController)new ColResolverController());
                ModelerDialog.this.constructorListener.asyncConstructorDone((Object)ModelerDialog.this);
            }
        });
    }

    public void overlayLoaded() {
    }

    public void overlayRemoved() {
    }

    public void showDialog(Domain domain) {
        this.enableWaitCursor(true);
        this.model.setDomain(domain);
        if (this.model.getLogicalModel(ModelerPerspective.ANALYSIS) != null) {
            this.controller.setModelerPerspective(ModelerPerspective.ANALYSIS);
        } else {
            this.controller.setModelerPerspective(ModelerPerspective.REPORTING);
        }
        this.controller.resetPropertyForm();
        this.showDialog();
        this.enableWaitCursor(false);
    }

    public void showDialog(String domainId, String modelId) {
        this.showDialog(domainId, modelId, ModelerPerspective.ANALYSIS);
    }

    public void showDialog(String domainId, String modelId, final ModelerPerspective modelerPerspective) {
        this.enableWaitCursor(true);
        this.service.loadDomain(domainId, (XulServiceCallback)new XulServiceCallback<Domain>(){

            public void success(Domain retVal) {
                ModelerDialog.this.model.setDomain(retVal);
                if (ModelerDialog.this.model.getLogicalModel(modelerPerspective) != null) {
                    ModelerDialog.this.controller.setModelerPerspective(modelerPerspective);
                } else {
                    ModelerDialog.this.controller.setModelerPerspective(ModelerPerspective.REPORTING);
                }
                ModelerDialog.this.controller.resetPropertyForm();
                XulComponent editIcon = ModelerDialog.this.container.getDocumentRoot().getElementById(EDIT_TOOLBAR_BUTTON_ID);
                boolean disabled = ((LogicalModel)ModelerDialog.this.model.getDomain().getLogicalModels().get(0)).getProperty("datasourceModel") == null;
                editIcon.setDisabled(disabled);
                ModelerDialog.this.enableWaitCursor(false);
                ModelerDialog.this.showDialog();
            }

            public void error(String message, Throwable error) {
                ModelerDialog.this.enableWaitCursor(false);
                ModelerDialog.this.showErrorDialog(ModelerDialog.this.messages.getString("ModelEditor.ERROR", new String[0]), ModelerDialog.this.messages.getString("ModelEditor.ERROR_0002_LOADING_DOMAIN", new String[0]));
            }
        });
    }

    private void enableWaitCursor(boolean enable) {
        if (enable) {
            MessageHandler.getInstance().showWaitingDialog(MessageHandler.getString("waiting.generalWaiting"));
        } else {
            MessageHandler.getInstance().closeWaitingDialog();
        }
    }

    public String getName() {
        return "modelerDialogController";
    }

    @Bindable
    public void closeErrorDialog() {
        this.errorDialog.hide();
    }

    @Bindable
    public void onCancel() {
        this.hideDialog();
        this.listener.onDialogCancel();
    }

    @Bindable
    public void onEditSource() {
        this.showEditSourceDialog();
    }

    public void showEditSourceDialog() {
        this.wizard.showEditDialog(this.model.getDomain(), new DialogController.DialogListener<Domain>(){

            public void onDialogAccept(Domain domain) {
                try {
                    ModelerDialog.this.model.refresh(domain);
                }
                catch (ModelerException e) {
                    ModelerDialog.this.showErrorDialog("Error", e.getMessage());
                }
            }

            public void onDialogCancel() {
            }

            public void onDialogReady() {
            }

            public void onDialogError(String errorMessage) {
            }
        });
    }

    public void addDialogListener(DialogController.DialogListener<Domain> listener) {
        super.addDialogListener(listener);
        this.listener = listener;
        listener.onDialogReady();
    }

    static {
        EDIT_TOOLBAR_BUTTON_ID = "edit-icon";
    }
}

