/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.api.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.pentaho.platform.repository2.unified.fileio.RepositoryFileInputStream;

public class ResourceUtil {
    public static final String APPLICATION_ZIP = "application/zip";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response createAttachment(Map<String, InputStream> fileData, String domainId) {
        String quotedFileName = null;
        if (fileData.size() > 1) {
            FileInputStream is;
            File zipFile = null;
            try {
                zipFile = this.createTempFile("datasourceExport", ".zip");
                zipFile.deleteOnExit();
                ZipOutputStream zos = this.createZipOutputStream(zipFile);
                for (String fileName : fileData.keySet()) {
                    InputStream zipEntryIs = null;
                    try {
                        ZipEntry entry = this.createZipEntry(fileName);
                        zos.putNextEntry(entry);
                        zipEntryIs = fileData.get(fileName);
                        this.copy(zipEntryIs, zos);
                    }
                    catch (Exception e) {}
                    continue;
                    finally {
                        zos.closeEntry();
                        if (zipEntryIs == null) continue;
                        zipEntryIs.close();
                    }
                }
                zos.close();
                is = this.createFileInputStream(zipFile);
            }
            catch (IOException ioe) {
                return this.buildServerErrorResponse(ioe);
            }
            StreamingOutput streamingOutput = this.createStreamingOutput(is);
            int xmiIndex = domainId.lastIndexOf(".xmi");
            quotedFileName = "\"" + (xmiIndex > 0 ? domainId.substring(0, xmiIndex) : domainId) + ".zip\"";
            return this.buildOkResponse(streamingOutput, APPLICATION_ZIP, quotedFileName);
        }
        if (fileData.size() == 1) {
            String fileName = (String)fileData.keySet().toArray()[0];
            quotedFileName = "\"" + fileName + "\"";
            InputStream is = fileData.get(fileName);
            String mimeType = this.getMimeType(is);
            StreamingOutput streamingOutput = this.getStreamingOutput(is);
            return this.buildOkResponse(streamingOutput, mimeType, quotedFileName);
        }
        return this.buildServerErrorResponse();
    }

    protected StreamingOutput createStreamingOutput(final InputStream is) {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException {
                IOUtils.copy((InputStream)is, (OutputStream)output);
            }
        };
    }

    protected FileInputStream createFileInputStream(File zipFile) throws FileNotFoundException {
        return new FileInputStream(zipFile);
    }

    protected void copy(InputStream zipEntryIs, ZipOutputStream zos) throws IOException {
        IOUtils.copy((InputStream)zipEntryIs, (OutputStream)zos);
    }

    protected File createTempFile(String fileName, String extension) throws IOException {
        return File.createTempFile(fileName, extension);
    }

    protected ZipEntry createZipEntry(String fileName) {
        return new ZipEntry(fileName);
    }

    protected ZipOutputStream createZipOutputStream(File zipFile) throws IOException {
        return new ZipOutputStream(new FileOutputStream(zipFile));
    }

    protected Response buildOkResponse(StreamingOutput streamingOutput, String mimeType, String quotedFileName) {
        return Response.ok((Object)streamingOutput, (String)mimeType).header("Content-Disposition", (Object)("attachment; filename=" + quotedFileName)).build();
    }

    protected Response buildServerErrorResponse() {
        return Response.serverError().build();
    }

    protected Response buildServerErrorResponse(Exception ioe) {
        return Response.serverError().entity((Object)ioe.toString()).build();
    }

    protected String getMimeType(InputStream is) {
        return is instanceof RepositoryFileInputStream ? ((RepositoryFileInputStream)is).getMimeType() : "text/plain";
    }

    protected StreamingOutput getStreamingOutput(final InputStream is) {
        return new StreamingOutput(){

            public void write(OutputStream output) throws IOException {
                IOUtils.copy((InputStream)is, (OutputStream)output);
            }
        };
    }

    static class ImportFailedException
    extends WebApplicationException {
        public ImportFailedException(String error) {
            super(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)error).type("text/plain").build());
        }
    }

    static class AccessControlException
    extends WebApplicationException {
        public AccessControlException(String error) {
            super(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)error).type("text/plain").build());
        }
    }

    static class PublishProhibitedException
    extends WebApplicationException {
        public PublishProhibitedException(String error) {
            super(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)error).type("text/plain").build());
        }
    }

    static class UnspecifiedErrorException
    extends WebApplicationException {
        public UnspecifiedErrorException(String error) {
            super(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)error).type("text/plain").build());
        }
    }

    static class ContentAlreadyExistsException
    extends WebApplicationException {
        public ContentAlreadyExistsException(String error) {
            super(Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)error).type("text/plain").build());
        }
    }
}

