/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.api.resources;

import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataParam;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.codehaus.enunciate.Facet;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository.RepositoryException;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileAclDto;
import org.pentaho.platform.dataaccess.datasource.api.AnalysisService;
import org.pentaho.platform.dataaccess.datasource.api.resources.ResourceUtil;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.web.http.api.resources.JaxbList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/data-access/api/datasource/analysis")
public class AnalysisResource {
    protected static final String UPLOAD_ANALYSIS = "uploadInput";
    protected static final String CATALOG_ID = "catalogId";
    protected static final String ORIG_CATALOG_NAME = "origCatalogName";
    protected static final String DATASOURCE_NAME = "datasourceName";
    protected static final String OVERWRITE_IN_REPOS = "overwrite";
    protected static final String XMLA_ENABLED_FLAG = "xmlaEnabledFlag";
    protected static final String PARAMETERS = "parameters";
    private static final String DATASOURCE_ACL = "acl";
    private static final int SUCCESS = 3;
    protected static final Logger logger = LoggerFactory.getLogger(AnalysisResource.class);
    protected AnalysisService service = this.createAnalysisService();
    protected ResourceUtil resourceUtil = new ResourceUtil();

    protected AnalysisService createAnalysisService() {
        return new AnalysisService();
    }

    @GET
    @Path(value="/catalog/{catalogId : .+}")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully downloaded the analysis file"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=500, condition="Unabled to download analysis file")})
    public Response downloadSchema(@PathParam(value="catalogId") String catalog) {
        try {
            Map<String, InputStream> fileData = this.service.doGetAnalysisFilesAsDownload(catalog);
            return this.createAttachment(fileData, catalog);
        }
        catch (PentahoAccessControlException e) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        catch (RepositoryException e) {
            throw new WebApplicationException(Response.Status.BAD_REQUEST);
        }
    }

    @DELETE
    @Path(value="/catalog/{catalogId : .+}")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully removed the analysis data"), @ResponseCode(code=401, condition="User is not authorized to delete the analysis datasource"), @ResponseCode(code=500, condition="Unable to remove the analysis data.")})
    public Response deleteSchema(@PathParam(value="catalogId") String catalog) {
        try {
            this.service.removeAnalysis(catalog);
            return this.buildOkResponse();
        }
        catch (PentahoAccessControlException e) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }

    @GET
    @Path(value="/catalog")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the list of analysis IDs")})
    public JaxbList<String> getSchemaIds() {
        return this.createNewJaxbList(this.service.getAnalysisDatasourceIds());
    }

    @PUT
    @Path(value="/catalog/{catalogId : .+}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=409, condition="Content already exists (use overwrite flag to force)"), @ResponseCode(code=401, condition="Import failed because publish is prohibited"), @ResponseCode(code=500, condition="Unspecified general error has occurred"), @ResponseCode(code=412, condition="Analysis datasource import failed.  Error code or message included in response entity"), @ResponseCode(code=403, condition="Access Control Forbidden"), @ResponseCode(code=201, condition="Indicates successful import")})
    public Response putSchema(@PathParam(value="catalogId") String catalog, @FormDataParam(value="uploadInput") InputStream uploadAnalysis, @FormDataParam(value="uploadInput") FormDataContentDisposition schemaFileInfo, @FormDataParam(value="origCatalogName") String origCatalogName, @FormDataParam(value="datasourceName") String datasourceName, @FormDataParam(value="overwrite") Boolean overwrite, @FormDataParam(value="xmlaEnabledFlag") Boolean xmlaEnabledFlag, @FormDataParam(value="parameters") String parameters, @FormDataParam(value="acl") RepositoryFileAclDto acl) throws PentahoAccessControlException {
        try {
            this.service.putMondrianSchema(uploadAnalysis, schemaFileInfo, catalog, origCatalogName, datasourceName, overwrite, xmlaEnabledFlag, parameters, acl);
            Response response = Response.status((Response.Status)Response.Status.CREATED).build();
            logger.debug("putMondrianSchema Response " + response);
            return response;
        }
        catch (PentahoAccessControlException pac) {
            int statusCode = 5;
            logger.error("Error putMondrianSchema " + pac.getMessage() + " status = " + statusCode);
            throw new ResourceUtil.AccessControlException(pac.getMessage());
        }
        catch (PlatformImportException pe) {
            int status;
            if (pe.getErrorStatus() == 10) {
                throw new ResourceUtil.PublishProhibitedException(pe.getMessage());
            }
            String msg = pe.getMessage();
            logger.error("Error import analysis: " + msg + " status = " + pe.getErrorStatus());
            Throwable throwable = pe.getCause();
            if (throwable != null) {
                msg = throwable.getMessage();
                logger.error("Root cause: " + msg);
            }
            if ((status = pe.getErrorStatus()) == 8) {
                throw new ResourceUtil.ContentAlreadyExistsException(msg);
            }
            throw new ResourceUtil.ImportFailedException(msg);
        }
        catch (Exception e) {
            int statusCode = 2;
            logger.error("Error putMondrianSchema " + e.getMessage() + " status = " + statusCode);
            throw new ResourceUtil.UnspecifiedErrorException(e.getMessage());
        }
    }

    public Response importMondrianSchema(@FormDataParam(value="uploadInput") InputStream uploadAnalysis, @FormDataParam(value="uploadInput") FormDataContentDisposition schemaFileInfo, @FormDataParam(value="catalogId") String catalogName, @FormDataParam(value="origCatalogName") String origCatalogName, @FormDataParam(value="datasourceName") String datasourceName, @FormDataParam(value="overwrite") String overwrite, @FormDataParam(value="xmlaEnabledFlag") String xmlaEnabledFlag, @FormDataParam(value="parameters") String parameters, @FormDataParam(value="acl") RepositoryFileAclDto acl) throws PentahoAccessControlException {
        Response response = null;
        int statusCode = 2;
        try {
            boolean overWriteInRepository = "True".equalsIgnoreCase(overwrite);
            boolean xmlaEnabled = "True".equalsIgnoreCase(xmlaEnabledFlag);
            this.service.putMondrianSchema(uploadAnalysis, schemaFileInfo, catalogName, origCatalogName, datasourceName, overWriteInRepository, xmlaEnabled, parameters, acl);
            statusCode = 3;
        }
        catch (PentahoAccessControlException pac) {
            logger.error(pac.getMessage());
            statusCode = 5;
        }
        catch (PlatformImportException pe) {
            statusCode = pe.getErrorStatus();
            logger.error("Error putMondrianSchema " + pe.getMessage() + " status = " + statusCode);
        }
        catch (Exception e) {
            logger.error("Error putMondrianSchema " + e.getMessage());
            statusCode = 2;
        }
        response = this.buildOkResponse(String.valueOf(statusCode));
        logger.debug("putMondrianSchema Response " + response);
        return response;
    }

    protected JaxbList<String> createNewJaxbList(List<String> DSWDatasources) {
        return new JaxbList(DSWDatasources);
    }

    protected Response buildOkResponse(String statusCode) {
        return Response.ok((Object)statusCode).type("text/plain").build();
    }

    protected Response createAttachment(Map<String, InputStream> fileData, String catalog) {
        return this.resourceUtil.createAttachment(fileData, catalog);
    }

    protected Response buildOkResponse() {
        return Response.ok().build();
    }

    protected Response buildUnauthorizedResponse() {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    protected Response buildServerErrorResponse() {
        return Response.serverError().build();
    }

    @GET
    @Path(value="/ids")
    @Produces(value={"application/xml", "application/json"})
    @Facet(name="Unsupported")
    public JaxbList<String> getAnalysisDatasourceIds() {
        return this.getSchemaIds();
    }

    @GET
    @Path(value="/{catalog : .+}/download")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully downloaded the analysis file"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=500, condition="Unabled to download analysis file")})
    public Response doGetAnalysisFilesAsDownload(@PathParam(value="catalog") String catalog) {
        return this.downloadSchema(catalog);
    }

    @PUT
    @Path(value="/import")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Status code indicating a success or failure while importing Mondrian schema XML. A response of:\n   *  2: Unspecified general error has occurred\n   *  3: Success\n   *  5: Authorization error")})
    public Response putMondrianSchema(@FormDataParam(value="uploadInput") InputStream uploadAnalysis, @FormDataParam(value="uploadInput") FormDataContentDisposition schemaFileInfo, @FormDataParam(value="catalogId") String catalogName, @FormDataParam(value="origCatalogName") String origCatalogName, @FormDataParam(value="datasourceName") String datasourceName, @FormDataParam(value="overwrite") String overwrite, @FormDataParam(value="xmlaEnabledFlag") String xmlaEnabledFlag, @FormDataParam(value="parameters") String parameters, @FormDataParam(value="acl") RepositoryFileAclDto acl) throws PentahoAccessControlException {
        return this.importMondrianSchema(uploadAnalysis, schemaFileInfo, catalogName, origCatalogName, datasourceName, overwrite, xmlaEnabledFlag, parameters, acl);
    }

    @POST
    @Path(value="/{catalog : .+}/remove")
    @Produces(value={"*/*"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully removed the analysis data"), @ResponseCode(code=401, condition="User is not authorized to delete the analysis datasource"), @ResponseCode(code=500, condition="Unable to remove the analysis data.")})
    public Response doRemoveAnalysis(@PathParam(value="catalog") String catalog) {
        try {
            this.service.removeAnalysis(catalog);
            return this.buildOkResponse();
        }
        catch (PentahoAccessControlException e) {
            return this.buildUnauthorizedResponse();
        }
    }

    @GET
    @Path(value="/{catalog : .+}/acl")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully got the ACL"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=404, condition="ACL doesn't exist"), @ResponseCode(code=409, condition="Analysis DS doesn't exist"), @ResponseCode(code=500, condition="ACL failed to be retrieved. This could be caused by an invalid path, or the file does not exist.")})
    public RepositoryFileAclDto doGetAnalysisDatasourceAcl(@PathParam(value="catalog") String catalog) {
        try {
            RepositoryFileAclDto acl = this.service.getAnalysisDatasourceAcl(catalog);
            if (acl == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            return acl;
        }
        catch (FileNotFoundException e) {
            throw new WebApplicationException(Response.Status.CONFLICT);
        }
        catch (PentahoAccessControlException e) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }

    @PUT
    @Path(value="/{catalog : .+}/acl")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully updated the ACL"), @ResponseCode(code=401, condition="Unauthorized"), @ResponseCode(code=409, condition="Analysis DS doesn't exist"), @ResponseCode(code=500, condition="Failed to save acls due to another error.")})
    public Response doSetAnalysisDatasourceAcl(@PathParam(value="catalog") String catalog, RepositoryFileAclDto acl) throws PentahoAccessControlException {
        try {
            this.service.setAnalysisDatasourceAcl(catalog, acl);
            return this.buildOkResponse();
        }
        catch (PentahoAccessControlException e) {
            return this.buildUnauthorizedResponse();
        }
        catch (FileNotFoundException e) {
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        catch (Exception e) {
            return this.buildServerErrorResponse();
        }
    }
}

