/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.api;

import com.sun.jersey.core.header.FormDataContentDisposition;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import mondrian.olap.Util;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository2.unified.IPlatformImportBundle;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFileAcl;
import org.pentaho.platform.api.repository2.unified.webservices.RepositoryFileAclDto;
import org.pentaho.platform.dataaccess.datasource.api.DatasourceService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.ConnectionServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.messages.Messages;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.mondrian.catalog.IAclAwareMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.services.importer.IPlatformImporter;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.importer.RepositoryFileImportBundle;
import org.pentaho.platform.plugin.services.importexport.legacy.MondrianCatalogRepositoryHelper;

public class AnalysisService
extends DatasourceService {
    public static final String METADATA_EXT = ".xmi";
    private static final String OVERWRITE_IN_REPOS = "overwrite";
    private static final String DATASOURCE_NAME = "datasourceName";
    private static final String ENABLE_XMLA = "EnableXmla";
    private static final String PARAMETERS = "parameters";
    private static final String DOMAIN_ID = "domain-id";
    private static final String MONDRIAN_MIME_TYPE = "application/vnd.pentaho.mondrian+xml";
    private static final String CATALOG_NAME = "catalogName";
    private static final String UTF_8 = "UTF-8";
    private static final String ZIP_EXTENSION = ".zip";
    private static final String MONDRIAN_FILE_EXTENSION = ".mondrian.xml";
    private static final String ANNOTATIONS_FILE = "annotations.xml";
    private static final Log logger = LogFactory.getLog(AnalysisService.class);
    private static final String ANNOTATION_FOLDER = "/etc/mondrian/";
    protected IPlatformImporter importer = (IPlatformImporter)PentahoSystem.get(IPlatformImporter.class);
    protected IAclAwareMondrianCatalogService aclAwareMondrianCatalogService;

    public AnalysisService() {
        if (this.mondrianCatalogService instanceof IAclAwareMondrianCatalogService) {
            this.aclAwareMondrianCatalogService = (IAclAwareMondrianCatalogService)this.mondrianCatalogService;
        }
    }

    public Map<String, InputStream> doGetAnalysisFilesAsDownload(String analysisId) throws PentahoAccessControlException {
        if (!this.canManageACL()) {
            throw new PentahoAccessControlException();
        }
        MondrianCatalogRepositoryHelper helper = this.createNewMondrianCatalogRepositoryHelper();
        Map fileData = helper.getModrianSchemaFiles(analysisId);
        DatasourceService.parseMondrianSchemaName(analysisId, fileData);
        return fileData;
    }

    public void removeAnalysis(String analysisId) throws PentahoAccessControlException {
        try {
            this.ensureDataAccessPermissionCheck();
        }
        catch (ConnectionServiceException e) {
            throw new PentahoAccessControlException();
        }
        this.mondrianCatalogService.removeCatalog(this.fixEncodedSlashParam(analysisId), this.getSession());
    }

    public List<String> getAnalysisDatasourceIds() {
        ArrayList<String> analysisIds = new ArrayList<String>();
        List mockMondrianCatalogList = this.mondrianCatalogService.listCatalogs(this.getSession(), false);
        Set ids = this.metadataDomainRepository.getDomainIds();
        for (MondrianCatalog mondrianCatalog : mockMondrianCatalogList) {
            String domainId = mondrianCatalog.getName() + METADATA_EXT;
            if (ids.contains(domainId)) continue;
            analysisIds.add(mondrianCatalog.getName());
        }
        return analysisIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMondrianSchema(InputStream dataInputStream, FormDataContentDisposition schemaFileInfo, String catalogName, String origCatalogName, String datasourceName, boolean overwrite, boolean xmlaEnabledFlag, String parameters, RepositoryFileAclDto acl) throws PentahoAccessControlException, PlatformImportException, Exception {
        this.accessValidation();
        String fileName = schemaFileInfo.getFileName();
        this.fileNameValidation(fileName);
        ZipInputStream zis = null;
        ByteArrayOutputStream mondrian = null;
        ByteArrayOutputStream annotations = null;
        if (fileName.endsWith(ZIP_EXTENSION)) {
            zis = new ZipInputStream(dataInputStream);
            ZipEntry ze = null;
            boolean len = false;
            while ((ze = zis.getNextEntry()) != null) {
                if (ze.getName().endsWith(MONDRIAN_FILE_EXTENSION)) {
                    mondrian = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)zis, (OutputStream)mondrian);
                } else if (ze.getName().equals(ANNOTATIONS_FILE)) {
                    annotations = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)zis, (OutputStream)annotations);
                }
                zis.closeEntry();
            }
            if (mondrian != null) {
                dataInputStream = new ByteArrayInputStream(mondrian.toByteArray());
            }
        }
        try {
            this.processMondrianImport(dataInputStream, catalogName, origCatalogName, overwrite, xmlaEnabledFlag, parameters, fileName, acl);
            if (annotations != null) {
                String catName = catalogName != null ? catalogName : fileName.substring(0, fileName.indexOf(46));
                ByteArrayInputStream annots = new ByteArrayInputStream(annotations.toByteArray());
                RepositoryFileImportBundle mondrianBundle = new RepositoryFileImportBundle.Builder().input((InputStream)annots).path(ANNOTATION_FOLDER + catName).name(ANNOTATIONS_FILE).charSet(UTF_8).overwriteFile(true).mime("text/xml").withParam(DOMAIN_ID, catName).build();
                this.importer.importFile((IPlatformImportBundle)mondrianBundle);
                logger.debug((Object)"imported mondrian annotations");
                annots.close();
            }
        }
        finally {
            if (zis != null) {
                zis.close();
            }
            if (mondrian != null) {
                mondrian.close();
            }
            if (annotations != null) {
                annotations.close();
            }
        }
    }

    public RepositoryFileAclDto getAnalysisDatasourceAcl(String analysisId) throws PentahoAccessControlException, FileNotFoundException {
        this.checkAnalysisExists(analysisId);
        if (this.aclAwareMondrianCatalogService != null) {
            RepositoryFileAcl acl = this.aclAwareMondrianCatalogService.getAclFor(analysisId);
            return acl == null ? null : this.repositoryFileAclAdapter.marshal(acl);
        }
        return null;
    }

    public void setAnalysisDatasourceAcl(String analysisId, RepositoryFileAclDto aclDto) throws PentahoAccessControlException, FileNotFoundException {
        RepositoryFileAcl acl;
        this.checkAnalysisExists(analysisId);
        RepositoryFileAcl repositoryFileAcl = acl = aclDto == null ? null : this.repositoryFileAclAdapter.unmarshal(aclDto);
        if (this.aclAwareMondrianCatalogService != null) {
            this.aclAwareMondrianCatalogService.setAclFor(analysisId, acl);
        }
        this.flushDataSources();
    }

    private void checkAnalysisExists(String analysisId) throws FileNotFoundException, PentahoAccessControlException {
        if (!this.canManageACL()) {
            throw new PentahoAccessControlException();
        }
        if (this.mondrianCatalogService.getCatalog(analysisId, PentahoSessionHolder.getSession()) == null) {
            throw new FileNotFoundException(analysisId + " doesn't exist");
        }
    }

    protected void processMondrianImport(InputStream dataInputStream, String catalogName, String origCatalogName, boolean overwrite, boolean xmlaEnabledFlag, String parameters, String fileName, RepositoryFileAclDto acl) throws PlatformImportException {
        IMondrianCatalogService catalogService;
        boolean overWriteInRepository = this.determineOverwriteFlag(parameters, overwrite);
        IPlatformImportBundle bundle = this.createPlatformBundle(parameters, dataInputStream, catalogName, overWriteInRepository, fileName, xmlaEnabledFlag, acl);
        if (this.isChangeCatalogName(origCatalogName, bundle)) {
            catalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, (IPentahoSession)PentahoSessionHolder.getSession());
            catalogService.removeCatalog(origCatalogName, PentahoSessionHolder.getSession());
        }
        if (this.isOverwriteAnnotations(parameters, overWriteInRepository)) {
            catalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, (IPentahoSession)PentahoSessionHolder.getSession());
            List catalogs = catalogService.listCatalogs(PentahoSessionHolder.getSession(), false);
            for (MondrianCatalog catalog : catalogs) {
                if (!catalog.getName().equals(bundle.getName())) continue;
                catalogService.removeCatalog(bundle.getName(), PentahoSessionHolder.getSession());
                break;
            }
        }
        this.importer.importFile(bundle);
    }

    private boolean isChangeCatalogName(String origCatalogName, IPlatformImportBundle bundle) {
        return !StringUtils.isEmpty((String)origCatalogName) && !bundle.getName().equals(origCatalogName);
    }

    private boolean isOverwriteAnnotations(String parameters, boolean overWriteInRepository) {
        return overWriteInRepository && !"true".equalsIgnoreCase(this.getValue(parameters, "retainInlineAnnotations"));
    }

    private boolean determineOverwriteFlag(String parameters, boolean overWriteInRepository) {
        String overwriteStr = this.getValue(parameters, OVERWRITE_IN_REPOS);
        if (overwriteStr != null) {
            overWriteInRepository = "True".equalsIgnoreCase(overwriteStr);
        }
        return overWriteInRepository;
    }

    private IPlatformImportBundle createPlatformBundle(String parameters, InputStream dataInputStream, String catalogName, boolean overWriteInRepository, String fileName, boolean xmlaEnabled, RepositoryFileAclDto acl) {
        byte[] bytes = null;
        try {
            bytes = IOUtils.toByteArray((InputStream)dataInputStream);
            if (bytes.length == 0 && catalogName != null) {
                MondrianCatalogRepositoryHelper helper = new MondrianCatalogRepositoryHelper((IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class));
                Map fileData = helper.getModrianSchemaFiles(catalogName);
                dataInputStream = (InputStream)fileData.get("schema.xml");
                bytes = IOUtils.toByteArray((InputStream)dataInputStream);
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        String datasource = this.getValue(parameters, "Datasource");
        String domainId = this.determineDomainCatalogName(parameters, catalogName, fileName, new ByteArrayInputStream(bytes));
        String sep = ";";
        if (StringUtils.isEmpty((String)parameters)) {
            parameters = "Provider=mondrian";
            parameters = parameters + sep + DATASOURCE_NAME + "=" + datasource;
            parameters = parameters + sep + ENABLE_XMLA + "=" + xmlaEnabled;
        }
        RepositoryFileImportBundle.Builder bundleBuilder = new RepositoryFileImportBundle.Builder().input((InputStream)new ByteArrayInputStream(bytes)).charSet(UTF_8).hidden(Boolean.valueOf(false)).name(domainId).overwriteFile(overWriteInRepository).mime(MONDRIAN_MIME_TYPE).withParam(PARAMETERS, parameters).withParam(DOMAIN_ID, domainId);
        if (acl != null) {
            bundleBuilder.acl(this.repositoryFileAclAdapter.unmarshal(acl)).applyAclSettings(true);
        }
        bundleBuilder.withParam(ENABLE_XMLA, Boolean.toString(xmlaEnabled));
        RepositoryFileImportBundle bundle = bundleBuilder.build();
        return bundle;
    }

    private String getValue(String parameters, String key) {
        Util.PropertyList propertyList = Util.parseConnectString((String)parameters);
        return propertyList.get(key);
    }

    XMLInputFactory getXMLInputFactory() {
        return XMLInputFactory.newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getSchemaName(String encoding, InputStream inputStream) throws XMLStreamException, IOException {
        String domainId = null;
        XMLStreamReader reader = null;
        try {
            XMLInputFactory factory = this.getXMLInputFactory();
            factory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
            factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
            reader = StringUtils.isEmpty((String)encoding) ? factory.createXMLStreamReader(inputStream) : factory.createXMLStreamReader(inputStream, encoding);
            while (reader.next() != 8) {
                if (reader.getEventType() != 1 || !reader.getLocalName().equalsIgnoreCase("Schema")) continue;
                domainId = reader.getAttributeValue("", "name");
                if (domainId == null) {
                    domainId = reader.getAttributeValue(null, "name");
                }
                String string = domainId;
                return string;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            inputStream.reset();
        }
        return domainId;
    }

    private String determineDomainCatalogName(String parameters, String catalogName, String fileName, InputStream inputStream) {
        String domainId = null;
        try {
            domainId = this.getSchemaName(null, inputStream);
        }
        catch (Exception e) {
            try {
                domainId = this.getSchemaName(UTF_8, inputStream);
            }
            catch (Exception e1) {
                logger.error((Object)e1);
            }
        }
        if (!StringUtils.isEmpty((String)domainId)) {
            return domainId;
        }
        String string = domainId = this.getValue(parameters, CATALOG_NAME) == null ? catalogName : this.getValue(parameters, CATALOG_NAME);
        if (domainId == null || "".equals(domainId)) {
            domainId = fileName.contains(".") ? fileName.substring(0, fileName.indexOf(".")) : fileName;
        } else if (domainId.contains(".")) {
            domainId = domainId.substring(0, domainId.indexOf("."));
        }
        return domainId;
    }

    protected MondrianCatalogRepositoryHelper createNewMondrianCatalogRepositoryHelper() {
        return new MondrianCatalogRepositoryHelper((IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class));
    }

    protected boolean canAdministerCheck() {
        return DatasourceService.canAdminister();
    }

    protected void ensureDataAccessPermissionCheck() throws ConnectionServiceException {
        super.ensureDataAccessPermission();
    }

    protected void accessValidation() throws PentahoAccessControlException {
        DatasourceService.validateAccess();
    }

    protected IPentahoSession getSession() {
        return PentahoSessionHolder.getSession();
    }

    private void fileNameValidation(String fileName) throws PlatformImportException {
        if (fileName == null) {
            throw new PlatformImportException(Messages.getString("AnalysisService.ERROR_001_ANALYSIS_DATASOURCE_ERROR"), 2);
        }
        if (fileName.endsWith(METADATA_EXT)) {
            throw new PlatformImportException(Messages.getString("AnalysisService.ERROR_002_ANALYSIS_DATASOURCE_ERROR"), 2);
        }
    }
}

