/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.jdbcimpl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import org.netbeans.mdr.persistence.Index;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.MultivaluedOrderedIndex;
import org.netbeans.mdr.persistence.ObjectResolver;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageClient;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.StoragePersistentDataException;
import org.netbeans.mdr.persistence.Streamable;
import org.netbeans.mdr.persistence.jdbcimpl.JdbcIndex;
import org.netbeans.mdr.persistence.jdbcimpl.JdbcMultivaluedIndex;
import org.netbeans.mdr.persistence.jdbcimpl.JdbcMultivaluedOrderedIndex;
import org.netbeans.mdr.persistence.jdbcimpl.JdbcPrimaryIndex;
import org.netbeans.mdr.persistence.jdbcimpl.JdbcSinglevaluedIndex;
import org.netbeans.mdr.persistence.jdbcimpl.JdbcStorageException;
import org.netbeans.mdr.persistence.jdbcimpl.LazyPreparedStatement;
import org.netbeans.mdr.util.IOUtils;

class JdbcStorage
implements Storage {
    public static final String MOFID_SEQ_TABLE_NAME = "MOFID_SEQ";
    public static final String MOFID_SEQ_COL_NAME = "MOFID_SEQ_NEXT";
    public static final String KEY_COL_PREFIX = "IDX_KEY";
    public static final String SINGLE_VAL_COL_PREFIX = "IDX_SVAL";
    public static final String MULTI_VAL_COL_PREFIX = "IDX_MVAL";
    public static final String ORDINAL_COL_NAME = "IDX_ORD";
    public static final String SURROGATE_COL_NAME = "IDX_SUR";
    public static final String PRIMARY_INDEX_NAME = "PRIMARY_INDEX";
    private Connection jdbcConnection;
    private final DatabaseMetaData dbMetaData;
    private final String idQuote;
    private final String schemaName;
    private final String schemaAuthName;
    private final String userName;
    private final String storageId;
    private final boolean realSchema;
    private final boolean debugPrint;
    private final boolean queryDuplicates;
    private final Map entryTypeToDataTypeMap;
    private Statement jdbcStmt;
    private ResultSet jdbcResultSet;
    private long firstSerialNumber;
    private long nextSerialNumber;
    private Map nameToIndexMap;
    private LazyPreparedStatement sqlUpdateSerialNumber;
    private Map sqlToPreparedStatementMap;
    private List lazyPreparedStatements;
    private JdbcPrimaryIndex primaryIndex;

    JdbcStorage(Properties properties, String storageId) throws StorageException {
        this.storageId = storageId;
        this.schemaName = properties.getProperty("org.netbeans.mdr.persistence.jdbcimpl.schemaName");
        this.schemaAuthName = properties.getProperty("org.netbeans.mdr.persistence.jdbcimpl.schemaAuthName");
        this.userName = properties.getProperty("org.netbeans.mdr.persistence.jdbcimpl.userName");
        this.entryTypeToDataTypeMap = new HashMap();
        this.createTypeMap(properties);
        String url = properties.getProperty("org.netbeans.mdr.persistence.jdbcimpl.url");
        String password = properties.getProperty("org.netbeans.mdr.persistence.jdbcimpl.password");
        String firstSerialNumberString = properties.getProperty("org.netbeans.mdr.persistence.jdbcimpl.firstSerialNumber");
        if (firstSerialNumberString == null) {
            this.firstSerialNumber = 1L;
        } else {
            try {
                this.firstSerialNumber = Long.decode(firstSerialNumberString);
            }
            catch (NumberFormatException ex) {
                throw new StorageBadRequestException(ex.toString());
            }
        }
        this.debugPrint = JdbcStorage.getBooleanProperty(properties, "org.netbeans.mdr.persistence.jdbcimpl.debugPrint", false);
        this.queryDuplicates = JdbcStorage.getBooleanProperty(properties, "org.netbeans.mdr.persistence.jdbcimpl.queryDuplicates", false);
        this.sqlToPreparedStatementMap = new HashMap();
        this.lazyPreparedStatements = new ArrayList();
        boolean success = false;
        try {
            this.jdbcConnection = DriverManager.getConnection(url, this.userName, password);
            this.jdbcConnection.setAutoCommit(false);
            this.jdbcStmt = this.jdbcConnection.createStatement();
            this.dbMetaData = this.jdbcConnection.getMetaData();
            this.realSchema = this.dbMetaData.supportsSchemasInTableDefinitions();
            this.idQuote = this.dbMetaData.getIdentifierQuoteString();
            success = true;
        }
        catch (SQLException ex) {
            throw this.newJdbcException(ex);
        }
        finally {
            if (!success) {
                this.rollbackConnection();
                this.closeConnection();
            }
        }
    }

    private static boolean getBooleanProperty(Properties properties, String propName, boolean defaultValue) {
        String value = properties.getProperty(propName);
        if (value == null) {
            return defaultValue;
        }
        return value.equalsIgnoreCase("true");
    }

    private JdbcStorageException newJdbcException(SQLException ex) {
        if (this.debugPrint) {
            ex.printStackTrace();
        }
        return new JdbcStorageException(ex);
    }

    private void createTypeMap(Properties properties) {
        this.entryTypeToDataTypeMap.put(Storage.EntryType.MOFID, properties.getProperty("org.netbeans.mdr.persistence.jdbcimpl.datatype.mofid", "BIGINT"));
        this.entryTypeToDataTypeMap.put(Storage.EntryType.STREAMABLE, properties.getProperty("org.netbeans.mdr.persistence.jdbcimpl.datatype.streamable", "LONGVARBINARY"));
        this.entryTypeToDataTypeMap.put(Storage.EntryType.STRING, properties.getProperty("org.netbeans.mdr.persistence.jdbcimpl.datatype.string", "VARCHAR(2000)"));
        this.entryTypeToDataTypeMap.put(Storage.EntryType.INT, properties.getProperty("org.netbeans.mdr.persistence.jdbcimpl.datatype.int", "BIGINT"));
    }

    public String getName() {
        return this.schemaName + ".jdbc";
    }

    public String getStorageId() {
        return this.storageId;
    }

    private void writeSerialNumber(long serialNumber) throws StorageException {
        this.executeUpdate(this.sqlUpdateSerialNumber, new Object[]{new Long(serialNumber)});
    }

    public synchronized long getSerialNumber() {
        return this.nextSerialNumber++;
    }

    public MOFID readMOFID(InputStream inputStream) throws StorageException {
        try {
            String storageId = IOUtils.readString((InputStream)inputStream);
            if (storageId == null) {
                storageId = this.storageId;
            }
            long serial = IOUtils.readLong((InputStream)inputStream);
            return new MOFID(serial, storageId);
        }
        catch (IOException ioException) {
            throw new StorageIOException(ioException);
        }
    }

    public void writeMOFID(OutputStream outputStream, MOFID mofid) throws StorageException {
        try {
            if (this.storageId.equals(mofid.getStorageID())) {
                IOUtils.writeString((OutputStream)outputStream, null);
            } else {
                IOUtils.writeString((OutputStream)outputStream, (String)mofid.getStorageID());
            }
            IOUtils.writeLong((OutputStream)outputStream, (long)mofid.getSerialNumber());
        }
        catch (IOException ioException) {
            throw new StorageIOException(ioException);
        }
    }

    DatabaseMetaData getDatabaseMetaData() {
        return this.dbMetaData;
    }

    private String getQualifiedTableName(String tableName) {
        if (this.realSchema) {
            return this.idQuote + this.schemaName + this.idQuote + "." + this.idQuote + tableName + this.idQuote;
        }
        return this.idQuote + this.schemaName + "_" + tableName + this.idQuote;
    }

    private String getQualifiedSchemaName() {
        return this.idQuote + this.schemaName + this.idQuote;
    }

    private void rollbackConnection() {
        this.closeResultSet();
        if (this.jdbcConnection != null) {
            try {
                this.jdbcConnection.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private long readSerialNumber() {
        try {
            this.jdbcResultSet = this.jdbcStmt.executeQuery("select * from " + this.getQualifiedTableName(MOFID_SEQ_TABLE_NAME));
            this.jdbcResultSet.next();
            long x = this.jdbcResultSet.getLong(1);
            return x;
        }
        catch (SQLException ex) {
            return -1L;
        }
    }

    public synchronized boolean exists() throws StorageException {
        long x = this.readSerialNumber();
        return x != -1L;
    }

    public synchronized boolean delete() throws StorageException {
        this.rollbackConnection();
        try {
            if (this.realSchema) {
                this.jdbcResultSet = this.dbMetaData.getSchemas();
                boolean found = false;
                while (this.jdbcResultSet.next()) {
                    String name = this.jdbcResultSet.getString(1);
                    if (!name.equals(this.schemaName)) continue;
                    found = true;
                    break;
                }
                this.closeResultSet();
                if (!found) {
                    return true;
                }
                this.jdbcStmt.execute("drop schema " + this.getQualifiedSchemaName() + " cascade");
            } else {
                this.jdbcResultSet = this.dbMetaData.getTables(null, null, this.schemaName + "%", null);
                ArrayList<String> tables = new ArrayList<String>();
                while (this.jdbcResultSet.next()) {
                    tables.add(this.jdbcResultSet.getString("TABLE_NAME"));
                }
                this.closeResultSet();
                Iterator iter = tables.iterator();
                while (iter.hasNext()) {
                    String tableName = (String)iter.next();
                    this.jdbcStmt.execute("drop table " + this.idQuote + tableName + this.idQuote);
                }
            }
            this.jdbcConnection.commit();
            return true;
        }
        catch (SQLException ex) {
            this.rollbackConnection();
            return false;
        }
    }

    private boolean isBlank(String s) {
        return s == null || s.length() == 0;
    }

    public synchronized void create(boolean replace, ObjectResolver resolver) throws StorageException {
        try {
            if (replace) {
                this.delete();
            }
            this.rollbackConnection();
            if (this.realSchema) {
                String sql = "create schema " + this.getQualifiedSchemaName();
                String authName = null;
                if (!this.isBlank(this.schemaAuthName)) {
                    if (!this.schemaAuthName.equals("!NONE")) {
                        authName = this.schemaAuthName;
                    }
                } else if (!this.isBlank(this.userName)) {
                    authName = this.userName;
                }
                if (authName != null) {
                    sql = sql + " authorization " + authName;
                }
                this.jdbcStmt.execute(sql);
            }
            String intType = this.getDataType(Storage.EntryType.INT);
            this.jdbcStmt.execute("create table " + this.getQualifiedTableName(MOFID_SEQ_TABLE_NAME) + "(" + MOFID_SEQ_COL_NAME + " " + intType + " not null primary key)");
            this.jdbcStmt.executeUpdate("insert into " + this.getQualifiedTableName(MOFID_SEQ_TABLE_NAME) + " values(1)");
            this.nextSerialNumber = this.firstSerialNumber;
            this.openImpl();
            this.createSinglevaluedIndex(PRIMARY_INDEX_NAME, Storage.EntryType.MOFID, Storage.EntryType.STREAMABLE);
            this.loadPrimaryIndex();
            this.jdbcConnection.commit();
        }
        catch (SQLException ex) {
            this.rollbackConnection();
            throw this.newJdbcException(ex);
        }
    }

    public synchronized void open(boolean createOnNoExist, ObjectResolver resolver) throws StorageException {
        this.nextSerialNumber = this.readSerialNumber();
        if (this.nextSerialNumber == -1L) {
            if (createOnNoExist) {
                this.create(false, resolver);
                return;
            }
            throw new StorageBadRequestException("Storage " + this.getName() + " does not exist.");
        }
        try {
            this.openImpl();
            this.loadPrimaryIndex();
        }
        catch (SQLException ex) {
            throw this.newJdbcException(ex);
        }
    }

    private void openImpl() throws SQLException {
        this.nameToIndexMap = new HashMap();
        this.sqlUpdateSerialNumber = new LazyPreparedStatement("update " + this.getQualifiedTableName(MOFID_SEQ_TABLE_NAME) + " set " + MOFID_SEQ_COL_NAME + " = ?");
    }

    private void loadPrimaryIndex() throws StorageException {
        this.primaryIndex = (JdbcPrimaryIndex)this.getIndex(PRIMARY_INDEX_NAME);
    }

    public synchronized void close() throws StorageException {
        this.nameToIndexMap = null;
        this.sqlUpdateSerialNumber = null;
        this.closeAllPreparedStatements();
        this.rollbackConnection();
    }

    private void closeAllPreparedStatements() {
        Iterator<Object> iter = this.sqlToPreparedStatementMap.values().iterator();
        while (iter.hasNext()) {
            PreparedStatement ps = (PreparedStatement)iter.next();
            this.closePreparedStatement(ps);
        }
        iter = this.lazyPreparedStatements.iterator();
        while (iter.hasNext()) {
            LazyPreparedStatement lps = (LazyPreparedStatement)iter.next();
            lps.ps = null;
        }
        this.sqlToPreparedStatementMap = new HashMap();
        this.lazyPreparedStatements = new ArrayList();
    }

    private void closePreparedStatement(PreparedStatement ps) {
        if (ps == null) {
            return;
        }
        try {
            ps.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStatement() {
        if (this.jdbcStmt == null) {
            return;
        }
        try {
            this.jdbcStmt.close();
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.jdbcStmt = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeResultSet() {
        if (this.jdbcResultSet == null) {
            return;
        }
        try {
            this.jdbcResultSet.close();
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.jdbcResultSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection() {
        if (this.jdbcConnection == null) {
            return;
        }
        try {
            this.jdbcConnection.close();
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.jdbcConnection = null;
        }
    }

    public synchronized SinglevaluedIndex createSinglevaluedIndex(String name, Storage.EntryType keyType, Storage.EntryType valueType) throws StorageException {
        this.createIndex(name, keyType, valueType, true, true, false);
        return this.getSinglevaluedIndex(name);
    }

    public synchronized MultivaluedOrderedIndex createMultivaluedOrderedIndex(String name, Storage.EntryType keyType, Storage.EntryType valueType, boolean unique) throws StorageException {
        this.createIndex(name, keyType, valueType, false, false, true);
        return this.getMultivaluedOrderedIndex(name);
    }

    public synchronized MultivaluedIndex createMultivaluedIndex(String name, Storage.EntryType keyType, Storage.EntryType valueType, boolean unique) throws StorageException {
        this.createIndex(name, keyType, valueType, false, unique, false);
        return this.getMultivaluedIndex(name);
    }

    private String getDataType(Storage.EntryType entryType) {
        return (String)this.entryTypeToDataTypeMap.get(entryType);
    }

    private Storage.EntryType getEntryType(ResultSetMetaData md, int i) throws SQLException {
        String colName = md.getColumnName(i).toUpperCase();
        int lastUnderscore = colName.lastIndexOf(95);
        String entryTypeName = colName.substring(lastUnderscore + 1);
        return Storage.EntryType.decodeEntryType((String)entryTypeName);
    }

    private String stripMofId(String indexName) {
        int i = indexName.indexOf(this.storageId);
        if (i == -1) {
            return indexName;
        }
        int j = i + this.storageId.length();
        if (indexName.charAt(j) != ':') {
            return indexName;
        }
        int n = indexName.length();
        ++j;
        while (j < n && indexName.charAt(j) == '0') {
            ++j;
        }
        return indexName.substring(0, i) + indexName.substring(j);
    }

    private String getTableNameForIndex(String indexName) {
        indexName = this.stripMofId(indexName);
        indexName = this.stripMofId(indexName);
        indexName = indexName.replace(':', '_');
        return this.getQualifiedTableName(indexName);
    }

    private void createIndex(String name, Storage.EntryType keyType, Storage.EntryType valueType, boolean singleValued, boolean uniqueValued, boolean ordered) throws StorageException {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("create table ");
            sb.append(this.getTableNameForIndex(name));
            sb.append("(");
            String keyColName = "IDX_KEY_" + keyType;
            sb.append(keyColName);
            sb.append(" ");
            sb.append(this.getDataType(keyType));
            sb.append(" not null, ");
            String valColName = singleValued ? SINGLE_VAL_COL_PREFIX : MULTI_VAL_COL_PREFIX;
            valColName = valColName + "_" + valueType;
            sb.append(valColName);
            sb.append(" ");
            sb.append(this.getDataType(valueType));
            sb.append(" not null,");
            String intType = this.getDataType(Storage.EntryType.INT);
            if (ordered) {
                sb.append(ORDINAL_COL_NAME);
                sb.append(" ");
                sb.append(intType);
                sb.append(" not null,");
            }
            if (!uniqueValued) {
                sb.append(SURROGATE_COL_NAME);
                sb.append(" ");
                sb.append(intType);
                sb.append(" not null,");
            }
            sb.append(" primary key(");
            sb.append(keyColName);
            if (!singleValued) {
                if (uniqueValued) {
                    sb.append(",");
                    sb.append(valColName);
                } else {
                    if (ordered) {
                        sb.append(",");
                        sb.append(ORDINAL_COL_NAME);
                    }
                    sb.append(",");
                    sb.append(SURROGATE_COL_NAME);
                }
            }
            sb.append(")");
            sb.append(")");
            this.jdbcStmt.execute(sb.toString());
        }
        catch (SQLException ex) {
            throw this.newJdbcException(ex);
        }
    }

    public synchronized SinglevaluedIndex getPrimaryIndex() throws StorageException {
        return this.getSinglevaluedIndex(PRIMARY_INDEX_NAME);
    }

    private Index loadIndex(String name) throws StorageException {
        PreparedStatement ps = null;
        try {
            JdbcIndex index;
            ps = this.jdbcConnection.prepareStatement("select * from " + this.getTableNameForIndex(name));
            ResultSetMetaData md = null;
            try {
                md = ps.getMetaData();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            if (md == null) {
                this.jdbcResultSet = ps.executeQuery();
                md = this.jdbcResultSet.getMetaData();
            }
            Storage.EntryType keyType = this.getEntryType(md, 1);
            Storage.EntryType valueType = this.getEntryType(md, 2);
            boolean singleValued = false;
            boolean ordered = false;
            boolean needSurrogate = false;
            String keyColName = md.getColumnName(1).toUpperCase();
            String valColName = md.getColumnName(2).toUpperCase();
            if (valColName.startsWith(SINGLE_VAL_COL_PREFIX)) {
                singleValued = true;
            }
            for (int i = 3; i <= md.getColumnCount(); ++i) {
                String colName = md.getColumnName(i).toUpperCase();
                if (colName.equals(ORDINAL_COL_NAME)) {
                    ordered = true;
                    continue;
                }
                if (!colName.equals(SURROGATE_COL_NAME)) continue;
                needSurrogate = true;
            }
            if (singleValued) {
                index = name.equals(PRIMARY_INDEX_NAME) ? new JdbcPrimaryIndex() : new JdbcSinglevaluedIndex();
            } else {
                index = ordered ? new JdbcMultivaluedOrderedIndex() : new JdbcMultivaluedIndex();
                if (this.queryDuplicates && !needSurrogate) {
                    ((JdbcMultivaluedIndex)index).queryDuplicates = true;
                }
            }
            index.init(this, this.getTableNameForIndex(name), name, keyColName, valColName, keyType, valueType, needSurrogate);
            this.nameToIndexMap.put(name, index);
            JdbcIndex jdbcIndex = index;
            this.closeResultSet();
            this.closePreparedStatement(ps);
            return jdbcIndex;
        }
        catch (SQLException ex) {
            try {
                throw this.newJdbcException(ex);
            }
            catch (Throwable throwable) {
                this.closeResultSet();
                this.closePreparedStatement(ps);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Index getIndex(String name) throws StorageException {
        Map map = this.nameToIndexMap;
        synchronized (map) {
            Index index = (Index)this.nameToIndexMap.get(name);
            if (index == null) {
                index = this.loadIndex(name);
            }
            return index;
        }
    }

    public synchronized SinglevaluedIndex getSinglevaluedIndex(String name) throws StorageException {
        return (SinglevaluedIndex)this.getIndex(name);
    }

    public synchronized MultivaluedIndex getMultivaluedIndex(String name) throws StorageException {
        return (MultivaluedIndex)this.getIndex(name);
    }

    public synchronized MultivaluedOrderedIndex getMultivaluedOrderedIndex(String name) throws StorageException {
        return (MultivaluedOrderedIndex)this.getIndex(name);
    }

    public synchronized void dropIndex(String name) throws StorageException {
        try {
            this.jdbcStmt.execute("drop table " + this.getTableNameForIndex(name));
        }
        catch (SQLException ex) {
            throw this.newJdbcException(ex);
        }
        this.nameToIndexMap.remove(name);
    }

    public void objectStateWillChange(Object key) throws StorageException {
    }

    public synchronized void objectStateChanged(Object key) throws StorageException {
        this.primaryIndex.objectStateChanged(key);
    }

    public synchronized void commitChanges() throws StorageException {
        try {
            this.writeSerialNumber(this.nextSerialNumber);
            this.primaryIndex.flushChanges();
            if (!this.dbMetaData.supportsOpenStatementsAcrossCommit()) {
                this.closeAllPreparedStatements();
            }
            this.jdbcConnection.commit();
        }
        catch (SQLException ex) {
            throw this.newJdbcException(ex);
        }
    }

    public synchronized void rollBackChanges() throws StorageException {
        try {
            if (!this.dbMetaData.supportsOpenStatementsAcrossRollback()) {
                this.closeAllPreparedStatements();
            }
            this.jdbcConnection.rollback();
        }
        catch (SQLException ex) {
            throw this.newJdbcException(ex);
        }
        if (this.primaryIndex != null) {
            this.primaryIndex.shutDown();
        }
        this.nameToIndexMap = new HashMap();
        this.loadPrimaryIndex();
    }

    public synchronized void shutDown() throws StorageException {
        if (this.sqlUpdateSerialNumber != null) {
            this.commitChanges();
        }
        this.closeStatement();
        this.closeConnection();
    }

    private PreparedStatement prepareStatement(LazyPreparedStatement lps) throws StorageException {
        if (lps.ps != null) {
            return lps.ps;
        }
        this.lazyPreparedStatements.add(lps);
        PreparedStatement ps = (PreparedStatement)this.sqlToPreparedStatementMap.get(lps.sql);
        if (ps != null) {
            lps.ps = ps;
            return ps;
        }
        try {
            ps = this.jdbcConnection.prepareStatement(lps.sql);
            this.sqlToPreparedStatementMap.put(lps.sql, ps);
            lps.ps = ps;
            return ps;
        }
        catch (SQLException ex) {
            throw this.newJdbcException(ex);
        }
    }

    private void bindArgs(PreparedStatement ps, Object[] args) throws SQLException, StorageException {
        if (args == null) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            int iParam = i + 1;
            if (arg instanceof MOFID) {
                MOFID mofid = (MOFID)arg;
                if (!mofid.getStorageID().equals(this.storageId)) {
                    throw new IllegalArgumentException("Foreign MOFID");
                }
                ps.setLong(iParam, mofid.getSerialNumber());
                continue;
            }
            if (arg instanceof Streamable) {
                ps.setBytes(iParam, this.writeByteArray((Streamable)arg));
                continue;
            }
            ps.setObject(iParam, arg);
        }
    }

    private Object getResultObj(Storage.EntryType entryType) throws StorageException, SQLException {
        if (entryType == Storage.EntryType.MOFID) {
            return new MOFID(this.jdbcResultSet.getLong(1), this.storageId);
        }
        if (entryType == Storage.EntryType.STRING) {
            return this.jdbcResultSet.getString(1);
        }
        if (entryType == Storage.EntryType.INT) {
            return new Long(this.jdbcResultSet.getLong(1));
        }
        byte[] bytes = this.jdbcResultSet.getBytes(1);
        byte[] copy = new byte[bytes.length];
        System.arraycopy(bytes, 0, copy, 0, bytes.length);
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized ListIterator getResultSetIterator(LazyPreparedStatement lps, Object[] args, Storage.EntryType entryType) throws StorageException {
        try {
            PreparedStatement ps = this.prepareStatement(lps);
            this.bindArgs(ps, args);
            this.jdbcResultSet = ps.executeQuery();
            ArrayList<Object> list = new ArrayList<Object>();
            try {
                while (this.jdbcResultSet.next()) {
                    Object obj = this.getResultObj(entryType);
                    list.add(obj);
                }
            }
            finally {
                this.closeResultSet();
            }
            if (entryType == Storage.EntryType.STREAMABLE) {
                ListIterator<Streamable> listIter = list.listIterator();
                while (listIter.hasNext()) {
                    byte[] bytes = (byte[])listIter.next();
                    listIter.set(this.readByteArray(bytes));
                }
            }
            return list.listIterator();
        }
        catch (SQLException ex) {
            throw this.newJdbcException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int getResultSetCount(LazyPreparedStatement lps, Object[] args) throws StorageException {
        PreparedStatement ps = this.prepareStatement(lps);
        this.bindArgs(ps, args);
        this.jdbcResultSet = ps.executeQuery();
        try {
            int n = 0;
            while (this.jdbcResultSet.next()) {
                ++n;
            }
            int n2 = n;
            this.closeResultSet();
            return n2;
        }
        catch (Throwable throwable) {
            try {
                this.closeResultSet();
                throw throwable;
            }
            catch (SQLException ex) {
                throw this.newJdbcException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized int getSingletonInt(LazyPreparedStatement lps, Object[] args) throws StorageException {
        try {
            PreparedStatement ps = this.prepareStatement(lps);
            this.bindArgs(ps, args);
            this.jdbcResultSet = ps.executeQuery();
            try {
                int n;
                if (!this.jdbcResultSet.next()) {
                    int n2 = -1;
                    return n2;
                }
                int n3 = n = this.jdbcResultSet.getInt(1);
                return n3;
            }
            finally {
                this.closeResultSet();
            }
        }
        catch (SQLException ex) {
            throw this.newJdbcException(ex);
        }
    }

    private byte[] writeByteArray(Streamable data) throws StorageException {
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(byteStream);
            dataStream.writeUTF(data.getClass().getName());
            data.write((OutputStream)dataStream);
            dataStream.flush();
            return byteStream.toByteArray();
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }

    private Streamable readByteArray(byte[] bytes) throws StorageException {
        Streamable data;
        String className;
        ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
        DataInputStream dataStream = new DataInputStream(byteStream);
        try {
            className = dataStream.readUTF();
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
        try {
            Class<?> cls = Class.forName(className);
            data = (Streamable)cls.newInstance();
        }
        catch (Exception ex) {
            throw new StoragePersistentDataException(ex.getMessage());
        }
        if (data instanceof StorageClient) {
            ((StorageClient)data).setStorage((Storage)this);
        }
        data.read((InputStream)dataStream);
        return data;
    }

    synchronized int executeUpdate(LazyPreparedStatement lps, Object[] args) throws StorageException {
        try {
            PreparedStatement ps = this.prepareStatement(lps);
            this.bindArgs(ps, args);
            return ps.executeUpdate();
        }
        catch (SQLException ex) {
            throw this.newJdbcException(ex);
        }
    }
}

