/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.jdbcimpl;

import java.util.Collection;
import java.util.ListIterator;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.jdbcimpl.JdbcCollection;
import org.netbeans.mdr.persistence.jdbcimpl.JdbcIndex;
import org.netbeans.mdr.persistence.jdbcimpl.LazyPreparedStatement;

class JdbcSinglevaluedIndex
extends JdbcIndex
implements SinglevaluedIndex {
    protected LazyPreparedStatement sqlValuesIterator;
    protected LazyPreparedStatement sqlValuesSize;
    protected LazyPreparedStatement sqlValuesContains;
    protected LazyPreparedStatement sqlUpdate;

    JdbcSinglevaluedIndex() {
    }

    protected void defineSql() {
        super.defineSql();
        this.sqlValuesIterator = new LazyPreparedStatement("select " + this.valColName + " from " + this.tableName);
        this.sqlValuesSize = new LazyPreparedStatement("select count(*) from " + this.tableName);
        this.sqlValuesContains = new LazyPreparedStatement("select count(*) from " + this.tableName + " where " + this.valColName + " = ?");
        this.sqlUpdate = new LazyPreparedStatement("update " + this.tableName + " set " + this.valColName + " = ? where " + this.keyColName + " = ?");
    }

    protected boolean isKeyUnique() {
        return true;
    }

    public boolean put(Object key, Object value) throws StorageException {
        return this.putImpl(key, value);
    }

    protected boolean putImpl(Object key, Object value) throws StorageException {
        int rowCount = this.storage.executeUpdate(this.sqlUpdate, new Object[]{value, key});
        if (rowCount == 0) {
            this.addImpl(key, value);
            return false;
        }
        return true;
    }

    public void replace(Object key, Object value) throws StorageException, StorageBadRequestException {
        this.replaceImpl(key, value);
    }

    protected void replaceImpl(Object key, Object value) throws StorageException, StorageBadRequestException {
        if (!this.putImpl(key, value)) {
            throw new StorageBadRequestException("Cannot replace item that does not exist in the index.");
        }
    }

    public Object get(Object key) throws StorageException, StorageBadRequestException {
        Object obj = this.getIfExists(key);
        if (obj == null) {
            throw new StorageBadRequestException("Item not found: " + key);
        }
        return obj;
    }

    public Object getObject(Object key, SinglevaluedIndex repos) throws StorageException {
        if (this.keyType == Storage.EntryType.MOFID) {
            return repos.get(this.get(key));
        }
        return this.get(key);
    }

    public Object getIfExists(Object key) throws StorageException {
        ListIterator iter = this.storage.getResultSetIterator(this.sqlFind, new Object[]{key}, this.getValueType());
        if (!iter.hasNext()) {
            return null;
        }
        return iter.next();
    }

    public Object getObjectIfExists(Object key, SinglevaluedIndex repos) throws StorageException {
        Object val = this.getIfExists(key);
        if (val == null) {
            return null;
        }
        if (this.keyType == Storage.EntryType.MOFID) {
            return repos.get(val);
        }
        return val;
    }

    public Collection values() throws StorageException {
        return new JdbcCollection(this.storage, this.getValueType(), this.sqlValuesIterator, this.sqlValuesSize, this.sqlValuesContains);
    }

    public Collection queryByKeyPrefix(Object prefix, SinglevaluedIndex repos) throws StorageException {
        throw new RuntimeException("oops, not yet implemented");
    }
}

