/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.jdbcimpl;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.mdr.persistence.MultivaluedIndex;
import org.netbeans.mdr.persistence.RuntimeStorageException;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.jdbcimpl.JdbcIndex;
import org.netbeans.mdr.persistence.jdbcimpl.LazyPreparedStatement;

class JdbcMultivaluedIndex
extends JdbcIndex
implements MultivaluedIndex {
    protected boolean queryDuplicates;
    protected LazyPreparedStatement sqlDeleteWithValue;
    protected LazyPreparedStatement sqlDeleteWithSurrogate;
    protected LazyPreparedStatement sqlFindCount;
    protected LazyPreparedStatement sqlFindCountWithValue;
    protected LazyPreparedStatement sqlFindSurrogate;

    JdbcMultivaluedIndex() {
    }

    protected void defineSql() {
        super.defineSql();
        this.sqlDeleteWithValue = new LazyPreparedStatement("delete from " + this.tableName + " where " + this.keyColName + " = ?" + " and " + this.valColName + " = ?");
        this.sqlDeleteWithSurrogate = new LazyPreparedStatement("delete from " + this.tableName + " where " + this.keyColName + " = ?" + " and " + "IDX_SUR" + " = ?");
        this.sqlFindCount = new LazyPreparedStatement("select count(*) from " + this.tableName + " where " + this.keyColName + " = ?");
        this.sqlFindCountWithValue = new LazyPreparedStatement("select count(*) from " + this.tableName + " where " + this.keyColName + " = ?" + " and " + this.valColName + " = ?");
        this.sqlFindSurrogate = new LazyPreparedStatement("select IDX_SUR from " + this.tableName + " where " + this.keyColName + " = ?" + " and " + this.valColName + " = ?");
    }

    public Collection getItems(Object key) throws StorageException {
        return new ItemCollection(key, null);
    }

    public Collection getObjects(Object key, SinglevaluedIndex repos) throws StorageException {
        if (this.keyType == Storage.EntryType.MOFID) {
            return new ItemCollection(key, repos);
        }
        return this.getItems(key);
    }

    public boolean isUnique() throws StorageException {
        return !this.needSurrogate;
    }

    public void add(Object key, Object value) throws StorageException {
        int n;
        if (this.queryDuplicates && (n = this.storage.getSingletonInt(this.sqlFindCountWithValue, new Object[]{key, value})) > 0) {
            throw new StorageBadRequestException("duplicate detected");
        }
        this.addImpl(key, value);
    }

    public boolean remove(Object key, Object value) throws StorageException {
        int rowCount;
        Object[] pair = new Object[]{key, value};
        if (this.isUnique()) {
            rowCount = this.storage.executeUpdate(this.sqlDeleteWithValue, pair);
        } else {
            int surrogateKey = this.storage.getSingletonInt(this.sqlFindSurrogate, pair);
            if (surrogateKey == -1) {
                return false;
            }
            rowCount = this.storage.executeUpdate(this.sqlDeleteWithSurrogate, new Object[]{key, new Integer(surrogateKey)});
        }
        return rowCount > 0;
    }

    public Collection queryByKeyPrefix(Object prefix, SinglevaluedIndex repos) throws StorageException {
        throw new RuntimeException("oops, not yet implemented");
    }

    private class ItemCollectionIter
    implements Iterator {
        private Iterator iter;
        private SinglevaluedIndex repos;
        private Object key;
        private Object value;

        ItemCollectionIter(Iterator iter, SinglevaluedIndex repos, Object key) {
            this.iter = iter;
            this.repos = repos;
            this.key = key;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            this.value = this.iter.next();
            if (this.repos != null) {
                try {
                    return this.repos.get(this.value);
                }
                catch (StorageException ex) {
                    throw new RuntimeStorageException(ex);
                }
            }
            return this.value;
        }

        public void remove() {
            try {
                JdbcMultivaluedIndex.this.remove(this.key, this.value);
            }
            catch (StorageException ex) {
                throw new RuntimeStorageException(ex);
            }
        }
    }

    private class ItemCollection
    extends AbstractCollection {
        private Object key;
        private SinglevaluedIndex repos;

        ItemCollection(Object key, SinglevaluedIndex repos) {
            this.key = key;
            this.repos = repos;
        }

        public Iterator iterator() {
            try {
                return new ItemCollectionIter(JdbcMultivaluedIndex.this.storage.getResultSetIterator(JdbcMultivaluedIndex.this.sqlFind, new Object[]{this.key}, JdbcMultivaluedIndex.this.getValueType()), this.repos, this.key);
            }
            catch (StorageException ex) {
                throw new RuntimeStorageException(ex);
            }
        }

        public int size() {
            try {
                return JdbcMultivaluedIndex.this.storage.getSingletonInt(JdbcMultivaluedIndex.this.sqlFindCount, new Object[]{this.key});
            }
            catch (StorageException ex) {
                throw new RuntimeStorageException(ex);
            }
        }

        public boolean add(Object value) {
            try {
                JdbcMultivaluedIndex.this.add(this.key, value);
                return true;
            }
            catch (StorageException ex) {
                throw new RuntimeStorageException(ex);
            }
        }
    }
}

