/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.designtime.swing;

import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.pentaho.reporting.libraries.designtime.swing.SmartComboBox;

public class FontFamilyComboBox
extends SmartComboBox {
    private DefaultComboBoxModel model;

    public FontFamilyComboBox() {
        String[] availableFontFamilyNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.model = new DefaultComboBoxModel<String>(availableFontFamilyNames);
        this.setModel(this.model);
        this.setRenderer(new FontListCellRenderer());
    }

    public void setValueFromModel(Object o) {
        Action oldAction = this.getAction();
        this.setAction(null);
        this.model.setSelectedItem(o);
        this.setAction(oldAction);
    }

    private static class FontListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private FontListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Font listFont = list.getFont();
            if (value == null) {
                this.setText("");
                this.setFont(listFont);
                return this;
            }
            String fontName = String.valueOf(value);
            this.setFont(listFont);
            this.setText(fontName);
            return this;
        }
    }
}

