/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.stringoperations;

import java.util.HashSet;
import java.util.Set;
import org.pentaho.di.core.Const;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.stringoperations.StringOperationsMeta;
import org.pentaho.metaverse.api.ChangeType;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.ComponentDerivationRecord;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;
import org.pentaho.metaverse.api.model.Operation;

public class StringOperationsStepAnalyzer
extends StepAnalyzer<StringOperationsMeta> {
    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        HashSet<Class<? extends BaseStepMeta>> set = new HashSet<Class<? extends BaseStepMeta>>(1);
        set.add(StringOperationsMeta.class);
        return set;
    }

    public Set<ComponentDerivationRecord> getChangeRecords(StringOperationsMeta stringOperationsMeta) throws MetaverseAnalyzerException {
        HashSet<ComponentDerivationRecord> changeRecords = new HashSet<ComponentDerivationRecord>();
        for (int i = 0; i < stringOperationsMeta.getFieldInStream().length; ++i) {
            String fieldInString = stringOperationsMeta.getFieldInStream()[i];
            String fieldOutString = stringOperationsMeta.getFieldOutStream()[i];
            if (Const.isEmpty((String)fieldOutString)) {
                fieldOutString = fieldInString;
            }
            ComponentDerivationRecord changeRecord = new ComponentDerivationRecord(fieldInString, fieldOutString, ChangeType.DATA);
            String trimTypeDescription = StringOperationsMeta.getTrimTypeDesc((int)stringOperationsMeta.getTrimType()[i]);
            String lowerUpperDescription = StringOperationsMeta.getLowerUpperDesc((int)stringOperationsMeta.getLowerUpper()[i]);
            String initCapDescription = StringOperationsMeta.getInitCapDesc((int)stringOperationsMeta.getInitCap()[i]);
            String digitsDescription = StringOperationsMeta.getDigitsDesc((int)stringOperationsMeta.getDigits()[i]);
            String maskXMLDescription = StringOperationsMeta.getMaskXMLDesc((int)stringOperationsMeta.getMaskXML()[i]);
            String paddingDescription = StringOperationsMeta.getPaddingDesc((int)stringOperationsMeta.getPaddingType()[i]);
            String specialCharactersDescription = StringOperationsMeta.getRemoveSpecialCharactersDesc((int)stringOperationsMeta.getRemoveSpecialCharacters()[i]);
            String changeOperation = fieldOutString;
            changeOperation = changeOperation + " { trim = [ " + trimTypeDescription + " ] && ";
            changeOperation = changeOperation + "lower/upper = [ " + lowerUpperDescription + " ] && ";
            changeOperation = changeOperation + "padding = [ " + paddingDescription + (stringOperationsMeta.getPaddingType()[i] == 0 ? "" : ", " + stringOperationsMeta.getPadChar()[i]) + ", " + stringOperationsMeta.getPadLen()[i] + " ] && ";
            changeOperation = changeOperation + "cap = [ " + initCapDescription + " ] && ";
            changeOperation = changeOperation + "maskXML = [ " + maskXMLDescription + " ] && ";
            changeOperation = changeOperation + "digits = [ " + digitsDescription + " ] && ";
            changeOperation = changeOperation + "remove = [ " + specialCharactersDescription + " ] } -> ";
            changeOperation = changeOperation + fieldOutString;
            changeRecord.addOperation(new Operation("calculation", ChangeType.DATA, "transforms", changeOperation));
            changeRecords.add(changeRecord);
        }
        return changeRecords;
    }

    protected Set<StepField> getUsedFields(StringOperationsMeta meta) {
        HashSet<StepField> usedFields = new HashSet<StepField>();
        for (String fieldInString : meta.getFieldInStream()) {
            usedFields.addAll(this.createStepFields(fieldInString, this.getInputs()));
        }
        return usedFields;
    }

    protected boolean isPassthrough(StepField originalFieldName) {
        String[] inFields = ((StringOperationsMeta)this.baseStepMeta).getFieldInStream();
        String origFieldName = originalFieldName.getFieldName();
        for (int i = 0; i < inFields.length; ++i) {
            if (!inFields[i].equals(origFieldName) || !Const.isEmpty((String)((StringOperationsMeta)this.baseStepMeta).getFieldOutStream()[i])) continue;
            return false;
        }
        return true;
    }

    protected void customAnalyze(StringOperationsMeta meta, IMetaverseNode rootNode) throws MetaverseAnalyzerException {
    }

    protected void setStepMeta(StringOperationsMeta meta) {
        this.baseStepMeta = meta;
    }
}

