/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.singlethreader;

import com.tinkerpop.blueprints.Vertex;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.pentaho.di.trans.ISubTransAwareMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.singlethreader.SingleThreaderMeta;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.KettleAnalyzerUtil;
import org.pentaho.metaverse.api.analyzer.kettle.step.IClonableStepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;

public class SingleThreaderStepAnalyzer
extends StepAnalyzer<SingleThreaderMeta> {
    protected Set<StepField> getUsedFields(SingleThreaderMeta meta) {
        return null;
    }

    protected void customAnalyze(SingleThreaderMeta meta, IMetaverseNode rootNode) throws MetaverseAnalyzerException {
        rootNode.setProperty("injectorStep", (Object)this.parentTransMeta.environmentSubstitute(meta.getInjectStep()));
        rootNode.setProperty("retrieveStep", (Object)this.parentTransMeta.environmentSubstitute(meta.getRetrieveStep()));
        rootNode.setProperty("batchSize", (Object)this.parentTransMeta.environmentSubstitute(meta.getBatchSize()));
        rootNode.setProperty("batchTime", (Object)this.parentTransMeta.environmentSubstitute(meta.getBatchTime()));
        KettleAnalyzerUtil.analyze((StepAnalyzer)this, (TransMeta)this.parentTransMeta, (ISubTransAwareMeta)meta, (IMetaverseNode)rootNode);
    }

    public void postAnalyze(SingleThreaderMeta meta) throws MetaverseAnalyzerException {
        String injectStepName = this.parentTransMeta.environmentSubstitute(meta.getInjectStep());
        String retrieveStepName = this.parentTransMeta.environmentSubstitute(meta.getRetrieveStep());
        String transformationPath = this.parentTransMeta.environmentSubstitute(meta.getFileName());
        TransMeta subTransMeta = KettleAnalyzerUtil.getSubTransMeta((ISubTransAwareMeta)meta);
        subTransMeta.setFilename(transformationPath);
        List singleThreaderOutputFields = this.findFieldVertices(this.parentTransMeta, this.parentStepMeta.getName());
        List injectorOutputFields = this.findFieldVertices(subTransMeta, injectStepName);
        block0: for (Vertex outputField : singleThreaderOutputFields) {
            for (Vertex derivedField : injectorOutputFields) {
                if (!outputField.getProperty("name").equals(derivedField.getProperty("name"))) continue;
                this.getMetaverseBuilder().addLink(outputField, "derives", derivedField);
                continue block0;
            }
        }
        List retrieverOutputFields = this.findFieldVertices(subTransMeta, retrieveStepName);
        block2: for (Vertex outputField : retrieverOutputFields) {
            for (Vertex derivedField : singleThreaderOutputFields) {
                if (!outputField.getProperty("name").equals(derivedField.getProperty("name"))) continue;
                this.getMetaverseBuilder().addLink(outputField, "derives", derivedField);
                continue block2;
            }
        }
    }

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        return new HashSet<Class<? extends BaseStepMeta>>(){
            {
                this.add(SingleThreaderMeta.class);
            }
        };
    }

    public IClonableStepAnalyzer newInstance() {
        return new SingleThreaderStepAnalyzer();
    }
}

