/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.mergejoin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.ProgressNullMonitorListener;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.mergejoin.MergeJoinMeta;
import org.pentaho.metaverse.api.ChangeType;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.ComponentDerivationRecord;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;
import org.pentaho.metaverse.api.model.Operation;

public class MergeJoinStepAnalyzer
extends StepAnalyzer<MergeJoinMeta> {
    protected RowMetaInterface leftStepFields;
    protected RowMetaInterface rightStepFields;

    protected void customAnalyze(MergeJoinMeta mergeJoinMeta, IMetaverseNode node) throws MetaverseAnalyzerException {
        String[] keyFields1 = mergeJoinMeta.getKeyFields1();
        String[] keyFields2 = mergeJoinMeta.getKeyFields2();
        String joinType = mergeJoinMeta.getJoinType();
        String[] prevStepNames = this.parentTransMeta.getPrevStepNames(this.getStepName());
        node.setProperty("joinType", (Object)joinType);
        node.setProperty("leftFields", Arrays.asList(keyFields1));
        node.setProperty("rightFields", Arrays.asList(keyFields2));
        boolean isInner = MergeJoinMeta.join_types[0].equals(joinType);
        boolean isLeftOuter = MergeJoinMeta.join_types[1].equals(joinType);
        boolean isRightOuter = MergeJoinMeta.join_types[2].equals(joinType);
        boolean isFullOuter = MergeJoinMeta.join_types[3].equals(joinType);
        for (int i = 0; i < keyFields1.length; ++i) {
            IMetaverseNode leftNode = this.getInputs().findNode(prevStepNames[0], keyFields1[i]);
            IMetaverseNode rightNode = this.getInputs().findNode(prevStepNames[1], keyFields2[i]);
            if ((isInner || isLeftOuter || isFullOuter) && leftNode != null && rightNode != null) {
                this.metaverseBuilder.addLink(leftNode, "joins", rightNode);
            }
            if (!isInner && !isRightOuter && !isFullOuter || leftNode == null || rightNode == null) continue;
            this.metaverseBuilder.addLink(rightNode, "joins", leftNode);
        }
    }

    public Set<ComponentDerivationRecord> getChangeRecords(MergeJoinMeta meta) throws MetaverseAnalyzerException {
        HashSet<ComponentDerivationRecord> changeRecords = new HashSet<ComponentDerivationRecord>();
        String[] prevStepNames = this.parentTransMeta.getPrevStepNames(this.getStepName());
        if (this.getOutputs() != null) {
            Set outputFields = this.getOutputs().getFieldNames();
            for (StepField outputField : outputFields) {
                String unsuffixName;
                StepField rightSideInputField;
                if (!outputField.getFieldName().matches(".*_\\d*$") || this.isPassthrough(rightSideInputField = new StepField(prevStepNames[1], unsuffixName = outputField.getFieldName().replaceAll("_\\d*$", "")))) continue;
                ComponentDerivationRecord renameFieldRecord = new ComponentDerivationRecord(rightSideInputField, outputField, ChangeType.METADATA);
                renameFieldRecord.addOperation(Operation.getRenameOperation());
                changeRecords.add(renameFieldRecord);
            }
        }
        return changeRecords;
    }

    protected Set<StepField> getUsedFields(MergeJoinMeta meta) {
        HashSet<StepField> usedFields = new HashSet<StepField>();
        String[] keyFields1 = meta.getKeyFields1();
        String[] keyFields2 = meta.getKeyFields2();
        String[] prevStepNames = this.parentTransMeta.getPrevStepNames(this.getStepName());
        for (int i = 0; i < keyFields1.length; ++i) {
            String leftField = keyFields1[i];
            String rightField = keyFields2[i];
            usedFields.add(new StepField(prevStepNames[0], leftField));
            usedFields.add(new StepField(prevStepNames[1], rightField));
        }
        return usedFields;
    }

    public Map<String, RowMetaInterface> getInputFields(MergeJoinMeta meta) {
        HashMap<String, RowMetaInterface> rowMeta = null;
        try {
            this.validateState(null, (BaseStepMeta)meta);
        }
        catch (MetaverseAnalyzerException metaverseAnalyzerException) {
            // empty catch block
        }
        if (this.parentTransMeta != null) {
            rowMeta = new HashMap<String, RowMetaInterface>();
            try {
                StepMeta stepMeta1 = ((StreamInterface)meta.getStepIOMeta().getInfoStreams().get(0)).getStepMeta();
                ProgressNullMonitorListener progress = new ProgressNullMonitorListener();
                this.leftStepFields = this.parentTransMeta.getStepFields(stepMeta1, (ProgressMonitorListener)progress);
                progress.done();
                progress = new ProgressNullMonitorListener();
                StepMeta stepMeta2 = ((StreamInterface)meta.getStepIOMeta().getInfoStreams().get(1)).getStepMeta();
                this.rightStepFields = this.parentTransMeta.getStepFields(stepMeta2, (ProgressMonitorListener)progress);
                progress.done();
                rowMeta.put(stepMeta1.getName(), this.leftStepFields);
                rowMeta.put(stepMeta2.getName(), this.rightStepFields);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return rowMeta;
    }

    protected boolean isPassthrough(StepField originalField) {
        boolean isBothSidesOfJoin;
        List inputFieldNamesMatching = this.getInputs().findNodes(originalField.getFieldName());
        String[] prevStepNames = this.parentTransMeta.getPrevStepNames(this.getStepName());
        boolean isRightSideOfJoin = originalField.getStepName().equals(prevStepNames[1]);
        boolean bl = isBothSidesOfJoin = inputFieldNamesMatching.size() > 1;
        if (!isRightSideOfJoin) {
            return true;
        }
        return isRightSideOfJoin && !isBothSidesOfJoin;
    }

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        HashSet<Class<? extends BaseStepMeta>> set = new HashSet<Class<? extends BaseStepMeta>>(1);
        set.add(MergeJoinMeta.class);
        return set;
    }

    protected void setParentTransMeta(TransMeta parent) {
        this.parentTransMeta = parent;
    }

    protected void setParentStepMeta(StepMeta parent) {
        this.parentStepMeta = parent;
    }
}

