/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.master;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationSerDeHelper;
import org.apache.hadoop.hbase.replication.ReplicationStateZKBase;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TableCFsUpdater
extends ReplicationStateZKBase {
    private static final Log LOG = LogFactory.getLog(TableCFsUpdater.class);

    public TableCFsUpdater(ZooKeeperWatcher zookeeper, Configuration conf, Abortable abortable) {
        super(zookeeper, conf, abortable);
    }

    public void update() {
        List znodes = null;
        try {
            znodes = ZKUtil.listChildrenNoWatch((ZooKeeperWatcher)this.zookeeper, (String)this.peersZNode);
        }
        catch (KeeperException e) {
            LOG.warn((Object)"", (Throwable)e);
        }
        if (znodes != null) {
            for (String peerId : znodes) {
                if (this.update(peerId)) continue;
                LOG.error((Object)("upgrade tableCFs failed for peerId=" + peerId));
            }
        }
    }

    public boolean update(String peerId) {
        String tableCFsNode = this.getTableCFsNode(peerId);
        try {
            if (ZKUtil.checkExists((ZooKeeperWatcher)this.zookeeper, (String)tableCFsNode) != -1) {
                String peerNode = this.getPeerNode(peerId);
                ReplicationPeerConfig rpc = this.getReplicationPeerConig(peerNode);
                if (rpc.getTableCFsMap() == null || rpc.getTableCFsMap().size() == 0) {
                    LOG.info((Object)("copy tableCFs into peerNode:" + peerId));
                    ZooKeeperProtos.TableCF[] tableCFs = ReplicationSerDeHelper.parseTableCFs((byte[])ZKUtil.getData((ZooKeeperWatcher)this.zookeeper, (String)tableCFsNode));
                    rpc.setTableCFsMap(ReplicationSerDeHelper.convert2Map((ZooKeeperProtos.TableCF[])tableCFs));
                    ZKUtil.setData((ZooKeeperWatcher)this.zookeeper, (String)peerNode, (byte[])ReplicationSerDeHelper.toByteArray((ReplicationPeerConfig)rpc));
                } else {
                    LOG.info((Object)("No tableCFs in peerNode:" + peerId));
                }
            }
        }
        catch (KeeperException e) {
            LOG.warn((Object)("NOTICE!! Update peerId failed, peerId=" + peerId), (Throwable)e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.warn((Object)("NOTICE!! Update peerId failed, peerId=" + peerId), (Throwable)e);
            return false;
        }
        catch (IOException e) {
            LOG.warn((Object)("NOTICE!! Update peerId failed, peerId=" + peerId), (Throwable)e);
            return false;
        }
        return true;
    }

    private ReplicationPeerConfig getReplicationPeerConig(String peerNode) throws KeeperException, InterruptedException {
        byte[] data = null;
        data = ZKUtil.getData((ZooKeeperWatcher)this.zookeeper, (String)peerNode);
        if (data == null) {
            LOG.error((Object)("Could not get configuration for peer because it doesn't exist. peer=" + peerNode));
            return null;
        }
        try {
            return ReplicationSerDeHelper.parsePeerFrom((byte[])data);
        }
        catch (DeserializationException e) {
            LOG.warn((Object)("Failed to parse cluster key from peer=" + peerNode));
            return null;
        }
    }
}

