/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.runtime.test.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.runtime.test.RuntimeTest;
import org.pentaho.runtime.test.RuntimeTestProgressCallback;
import org.pentaho.runtime.test.impl.RuntimeTestStatusImpl;
import org.pentaho.runtime.test.module.impl.RuntimeTestModuleResultsImpl;
import org.pentaho.runtime.test.result.RuntimeTestEntrySeverity;
import org.pentaho.runtime.test.result.RuntimeTestResult;
import org.pentaho.runtime.test.result.RuntimeTestResultSummary;
import org.pentaho.runtime.test.result.org.pentaho.runtime.test.result.impl.RuntimeTestResultSummaryImpl;
import org.pentaho.runtime.test.test.impl.RuntimeTestDelegateWithMoreDependencies;
import org.pentaho.runtime.test.test.impl.RuntimeTestResultEntryImpl;
import org.pentaho.runtime.test.test.impl.RuntimeTestResultImpl;

public class RuntimeTestRunner {
    private static final Class<?> PKG = RuntimeTestRunner.class;
    private final Set<RuntimeTest> remainingTests;
    private final Object objectUnderTest;
    private final RuntimeTestProgressCallback runtimeTestProgressCallback;
    private final ExecutorService executorService;
    private final Set<String> satisfiedDependencies;
    private final Set<String> failedDependencies;
    private final List<String> runtimeModuleList;
    private final Map<String, List<String>> stringRuntimeTestModuleToTestIdMap;
    private final Map<String, RuntimeTestResult> runtimeTestResultMap;
    private final Set<String> outstandingTestIds;
    private final Set<String> runningTestIds;
    private final int numberOfTests;

    public RuntimeTestRunner(Collection<? extends RuntimeTest> runtimeTests, Object objectUnderTest, RuntimeTestProgressCallback runtimeTestProgressCallback, ExecutorService executorService) {
        this.objectUnderTest = objectUnderTest;
        this.runtimeModuleList = new ArrayList<String>();
        this.stringRuntimeTestModuleToTestIdMap = new HashMap<String, List<String>>();
        this.runtimeTestResultMap = new HashMap<String, RuntimeTestResult>();
        this.outstandingTestIds = new HashSet<String>();
        this.runningTestIds = new HashSet<String>();
        HashSet<RuntimeTest> initTests = new HashSet<RuntimeTest>();
        HashSet<String> initTestIds = new HashSet<String>();
        HashSet<RuntimeTest> nonInitTests = new HashSet<RuntimeTest>();
        int numberOfTests = 0;
        for (RuntimeTest runtimeTest : runtimeTests) {
            if (!runtimeTest.accepts(objectUnderTest)) continue;
            ++numberOfTests;
            String runtimeTestModule = runtimeTest.getModule();
            List<String> runtimeIdsForModule = this.stringRuntimeTestModuleToTestIdMap.get(runtimeTestModule);
            if (runtimeIdsForModule == null) {
                this.runtimeModuleList.add(runtimeTestModule);
                runtimeIdsForModule = new ArrayList<String>();
                this.stringRuntimeTestModuleToTestIdMap.put(runtimeTestModule, runtimeIdsForModule);
            }
            String runtimeTestId = runtimeTest.getId();
            runtimeIdsForModule.add(runtimeTestId);
            if (runtimeTest.isConfigInitTest()) {
                initTests.add(runtimeTest);
                initTestIds.add(runtimeTestId);
                continue;
            }
            nonInitTests.add(runtimeTest);
        }
        this.numberOfTests = numberOfTests;
        this.remainingTests = new HashSet<RuntimeTest>(initTests);
        for (RuntimeTest runtimeTest : nonInitTests) {
            this.remainingTests.add(new RuntimeTestDelegateWithMoreDependencies(runtimeTest, initTestIds));
        }
        for (RuntimeTest runtimeTest : this.remainingTests) {
            String remainingTestId = runtimeTest.getId();
            this.runtimeTestResultMap.put(remainingTestId, new RuntimeTestResultImpl(runtimeTest, false, new RuntimeTestResultSummaryImpl(), 0L));
            this.outstandingTestIds.add(remainingTestId);
        }
        this.satisfiedDependencies = new HashSet<String>();
        this.failedDependencies = new HashSet<String>();
        this.runtimeTestProgressCallback = runtimeTestProgressCallback;
        this.executorService = executorService;
    }

    private void markSkipped(RuntimeTest runtimeTest) {
        String failedDependencyId;
        RuntimeTestResult runtimeTestResult;
        HashSet<String> relevantFailed = new HashSet<String>(this.failedDependencies);
        relevantFailed.retainAll(runtimeTest.getDependencies());
        String failedDependencyName = "a prerequisite";
        if (!relevantFailed.isEmpty() && (runtimeTestResult = this.runtimeTestResultMap.get(failedDependencyId = (String)relevantFailed.iterator().next())) != null) {
            failedDependencyName = runtimeTestResult.getRuntimeTest().getName();
        }
        String runtimeTestId = runtimeTest.getId();
        this.failedDependencies.add(runtimeTestId);
        this.outstandingTestIds.remove(runtimeTestId);
        this.runningTestIds.remove(runtimeTestId);
        this.runtimeTestResultMap.put(runtimeTestId, new RuntimeTestResultImpl(runtimeTest, true, new RuntimeTestResultSummaryImpl(new RuntimeTestResultEntryImpl(RuntimeTestEntrySeverity.SKIPPED, BaseMessages.getString(PKG, (String)"RuntimeTestRunner.Skipped.Desc", (String[])new String[]{failedDependencyName}), BaseMessages.getString(PKG, (String)"RuntimeTestRunner.Skipped.Message", (Object[])new Object[]{runtimeTest.getName(), relevantFailed}), (Throwable)null)), 0L));
    }

    private void callbackState() {
        this.callbackState(false);
    }

    private void callbackState(boolean done) {
        if (this.runtimeTestProgressCallback != null) {
            ArrayList<RuntimeTestModuleResultsImpl> moduleResults = new ArrayList<RuntimeTestModuleResultsImpl>(this.runtimeModuleList.size());
            for (String runtimeModule : this.runtimeModuleList) {
                ArrayList<RuntimeTestResult> runtimeTestResults = new ArrayList<RuntimeTestResult>();
                HashSet<RuntimeTest> runningTests = new HashSet<RuntimeTest>();
                HashSet<RuntimeTest> outstandingTests = new HashSet<RuntimeTest>();
                for (String testId : this.stringRuntimeTestModuleToTestIdMap.get(runtimeModule)) {
                    RuntimeTestResult runtimeTestResult = this.runtimeTestResultMap.get(testId);
                    runtimeTestResults.add(runtimeTestResult);
                    if (this.runningTestIds.contains(testId)) {
                        runningTests.add(runtimeTestResult.getRuntimeTest());
                        continue;
                    }
                    if (!this.outstandingTestIds.contains(testId)) continue;
                    outstandingTests.add(runtimeTestResult.getRuntimeTest());
                }
                moduleResults.add(new RuntimeTestModuleResultsImpl(runtimeModule, runtimeTestResults, runningTests, outstandingTests));
            }
            int testsRunning = this.runningTestIds.size();
            int testsOutstanding = this.outstandingTestIds.size();
            int testsDone = this.numberOfTests - testsOutstanding - testsRunning;
            this.runtimeTestProgressCallback.onProgress(new RuntimeTestStatusImpl(Collections.unmodifiableList(moduleResults), testsDone, testsRunning, testsOutstanding, done));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(RuntimeTest runtimeTest) {
        RuntimeTestEntrySeverity overallSeverity;
        RuntimeTestResultSummary runtimeTestResultSummary;
        String eligibleTestId = runtimeTest.getId();
        long before = System.currentTimeMillis();
        try {
            runtimeTestResultSummary = runtimeTest.runTest(this.objectUnderTest);
            overallSeverity = runtimeTestResultSummary.getOverallStatusEntry().getSeverity();
        }
        catch (Throwable e) {
            overallSeverity = RuntimeTestEntrySeverity.FATAL;
            runtimeTestResultSummary = new RuntimeTestResultSummaryImpl(new RuntimeTestResultEntryImpl(RuntimeTestEntrySeverity.FATAL, BaseMessages.getString(PKG, (String)"RuntimeTestRunner.Error.Desc", (String[])new String[]{runtimeTest.getName()}), e.getMessage(), e));
        }
        long after = System.currentTimeMillis();
        RuntimeTestResultImpl runtimeTestResult = new RuntimeTestResultImpl(runtimeTest, true, runtimeTestResultSummary, after - before);
        RuntimeTestRunner runtimeTestRunner = this;
        synchronized (runtimeTestRunner) {
            if (overallSeverity == RuntimeTestEntrySeverity.ERROR || overallSeverity == RuntimeTestEntrySeverity.FATAL) {
                this.failedDependencies.add(eligibleTestId);
            } else {
                this.satisfiedDependencies.add(eligibleTestId);
            }
            this.runtimeTestResultMap.put(eligibleTestId, runtimeTestResult);
            this.runningTestIds.remove(eligibleTestId);
            this.callbackState();
            this.notifyAll();
        }
    }

    public synchronized void runTests() {
        this.callbackState();
        while (this.remainingTests.size() > 0 || this.runningTestIds.size() > 0) {
            HashSet<RuntimeTest> eligibleTests = new HashSet<RuntimeTest>();
            HashSet<RuntimeTest> skippingTests = new HashSet<RuntimeTest>();
            HashSet<String> possibleToSatisfyIds = new HashSet<String>(this.satisfiedDependencies);
            for (RuntimeTest remainingTest : this.remainingTests) {
                possibleToSatisfyIds.add(remainingTest.getId());
            }
            possibleToSatisfyIds.addAll(this.outstandingTestIds);
            possibleToSatisfyIds.addAll(this.runningTestIds);
            for (RuntimeTest remainingTest : this.remainingTests) {
                Set<String> remainingTestDependencies = remainingTest.getDependencies();
                if (this.satisfiedDependencies.containsAll(remainingTestDependencies)) {
                    eligibleTests.add(remainingTest);
                    continue;
                }
                if (Collections.disjoint(remainingTestDependencies, this.failedDependencies) && possibleToSatisfyIds.containsAll(remainingTestDependencies)) continue;
                skippingTests.add(remainingTest);
                this.markSkipped(remainingTest);
            }
            this.remainingTests.removeAll(eligibleTests);
            this.remainingTests.removeAll(skippingTests);
            for (RuntimeTest eligibleTest : eligibleTests) {
                String eligibleTestId = eligibleTest.getId();
                this.outstandingTestIds.remove(eligibleTestId);
                this.runningTestIds.add(eligibleTestId);
            }
            int wasRunning = this.runningTestIds.size();
            for (final RuntimeTest eligibleTest : eligibleTests) {
                this.executorService.submit(new Runnable(){

                    @Override
                    public void run() {
                        RuntimeTestRunner.this.runTest(eligibleTest);
                    }
                });
            }
            if (skippingTests.size() == 0) {
                if (wasRunning <= 0) continue;
                while (wasRunning == this.runningTestIds.size()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                continue;
            }
            this.callbackState();
        }
        this.callbackState(true);
    }

    public static class Factory {
        public RuntimeTestRunner create(Collection<? extends RuntimeTest> runtimeTests, Object objectUnderTest, RuntimeTestProgressCallback runtimeTestProgressCallback, ExecutorService executorService) {
            return new RuntimeTestRunner(runtimeTests, objectUnderTest, runtimeTestProgressCallback, executorService);
        }
    }
}

