/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.docbundle.bundleloader;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.LibDocBundleBoot;
import org.pentaho.reporting.libraries.docbundle.bundleloader.DirectoryResourceLoader;
import org.pentaho.reporting.libraries.docbundle.bundleloader.RepositoryResourceBundleData;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.file.FileRepository;
import org.pentaho.reporting.libraries.resourceloader.FactoryParameterKey;
import org.pentaho.reporting.libraries.resourceloader.ParameterKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleData;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleLoader;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.loader.LoaderUtils;

public class DirectoryResourceBundleLoader
implements ResourceBundleLoader {
    public ResourceBundleData loadBundle(ResourceManager resourceManager, ResourceKey key) throws ResourceLoadingException {
        if (key == null) {
            throw new NullPointerException();
        }
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        try {
            Object identifier = key.getIdentifier();
            if (!(identifier instanceof File)) {
                return null;
            }
            File directory = (File)identifier;
            if (!directory.isDirectory()) {
                return null;
            }
            FileRepository repository = new FileRepository(directory);
            String bundleType = BundleUtilities.getBundleType((Repository)repository);
            String bundleMapping = BundleUtilities.getBundleMapping(bundleType);
            HashMap<FactoryParameterKey, Object> map = new HashMap<FactoryParameterKey, Object>();
            map.put(new FactoryParameterKey("repository"), repository);
            map.put(new FactoryParameterKey("repository-loader"), this);
            ResourceKey mainKey = new ResourceKey(key, (Object)DirectoryResourceBundleLoader.class.getName(), (Object)bundleMapping, map);
            return new RepositoryResourceBundleData(key, (Repository)repository, mainKey, true);
        }
        catch (ContentIOException e) {
            throw new ResourceLoadingException("Failed", (Exception)((Object)e));
        }
    }

    public boolean isSupportedKey(ResourceKey key) {
        ResourceKey parent = key.getParent();
        if (parent == null) {
            return false;
        }
        if (!DirectoryResourceLoader.class.getName().equals(parent.getSchema())) {
            return false;
        }
        return DirectoryResourceBundleLoader.class.getName().equals(key.getSchema());
    }

    public ResourceKey deriveKey(ResourceKey parent, String path, Map<? extends ParameterKey, ? extends Object> factoryKeys) throws ResourceKeyCreationException {
        HashMap<? extends ParameterKey, ? extends Object> map;
        if (!this.isSupportedKey(parent)) {
            throw new ResourceKeyCreationException("Assertation: Unsupported parent key type");
        }
        String identifier = (String)parent.getIdentifier();
        String entry = path != null ? (path.length() > 0 && path.charAt(0) == '/' ? LoaderUtils.stripLeadingSlashes((String)path) : LoaderUtils.mergePaths((String)identifier, (String)path)) : identifier;
        if (factoryKeys != null) {
            map = new HashMap<ParameterKey, Object>();
            map.putAll(parent.getFactoryParameters());
            map.putAll(factoryKeys);
        } else {
            map = parent.getFactoryParameters();
        }
        if ("true".equals(LibDocBundleBoot.getInstance().getGlobalConfig().getConfigProperty("org.pentaho.reporting.libraries.docbundle.bundleloader.directory.StrictKeyCheck", "true"))) {
            try {
                FileRepository repository = (FileRepository)parent.getFactoryParameters().get(new FactoryParameterKey("repository"));
                if (!RepositoryUtilities.isExistsEntity((Repository)repository, (String[])RepositoryUtilities.split((String)entry, (String)"/"))) {
                    throw new ResourceKeyCreationException("The key does not exist: " + entry);
                }
            }
            catch (ContentIOException e) {
                throw new ResourceKeyCreationException("Failed to check for existing key", (Exception)((Object)e));
            }
        }
        return new ResourceKey(parent.getParent(), parent.getSchema(), (Object)entry, map);
    }

    public String serialize(ResourceKey bundleKey, ResourceKey key) throws ResourceException {
        return null;
    }

    public ResourceKey deserialize(ResourceKey bundleKey, String stringKey) throws ResourceKeyCreationException {
        return null;
    }

    public boolean isSupportedDeserializer(String data) throws ResourceKeyCreationException {
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj.getClass() == this.getClass();
    }
}

