/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce.cubrid;

import com.cloudera.sqoop.lib.SqoopRecord;
import com.cloudera.sqoop.mapreduce.UpdateOutputFormat;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.sqoop.mapreduce.UpdateOutputFormat;

public class CubridUpsertOutputFormat<K extends SqoopRecord, V>
extends UpdateOutputFormat<K, V> {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());

    @Override
    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException {
        try {
            return new CubridUpsertRecordWriter(context);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public class CubridUpsertRecordWriter
    extends UpdateOutputFormat.UpdateRecordWriter {
        public CubridUpsertRecordWriter(TaskAttemptContext context) throws ClassNotFoundException, SQLException {
            super(context);
        }

        @Override
        protected String getUpdateStatement() {
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO ");
            sb.append(this.tableName);
            sb.append("(");
            boolean first = true;
            for (String column : this.columnNames) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(column);
            }
            sb.append(") VALUES(");
            first = true;
            for (int i = 0; i < this.columnNames.length; ++i) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append("?");
            }
            sb.append(") ON DUPLICATE KEY UPDATE ");
            first = true;
            for (String column : this.columnNames) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(column).append("=").append(column);
            }
            String query = sb.toString();
            CubridUpsertOutputFormat.this.log.debug((Object)("Using upsert query: " + query));
            return query;
        }
    }
}

