/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.connections;

import java.sql.Driver;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.pentaho.database.DatabaseDialectException;
import org.pentaho.database.IDatabaseDialect;
import org.pentaho.database.IDriverLocator;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.service.IDatabaseDialectService;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.misc.connections.DatasourceServiceException;
import org.pentaho.reporting.engine.classic.extensions.modules.connections.DataSourceCacheManager;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class PooledDatasourceHelper {
    private static final Log logger = LogFactory.getLog(PooledDatasourceHelper.class);
    public static final String GENERIC = "GENERIC";

    private PooledDatasourceHelper() {
    }

    public static PoolingDataSource setupPooledDataSource(IDatabaseConnection databaseConnection) throws DatasourceServiceException {
        try {
            String url;
            DataSourceCacheManager cacheManager = (DataSourceCacheManager)ClassicEngineBoot.getInstance().getObjectFactory().get(DataSourceCacheManager.class);
            IDatabaseDialectService databaseDialectService = (IDatabaseDialectService)ClassicEngineBoot.getInstance().getObjectFactory().get(IDatabaseDialectService.class);
            IDatabaseDialect dialect = databaseDialectService.getDialect(databaseConnection);
            String driverClass = GENERIC.equals(databaseConnection.getDatabaseType().getShortName()) ? (String)databaseConnection.getAttributes().get("CUSTOM_DRIVER_CLASS") : dialect.getNativeDriver();
            try {
                url = dialect.getURLWithExtraOptions(databaseConnection);
            }
            catch (DatabaseDialectException e) {
                url = null;
            }
            String maxdleConn = PooledDatasourceHelper.getSystemSetting("dbcp-defaults.max-idle-conn");
            String minIdleConn = PooledDatasourceHelper.getSystemSetting("dbcp-defaults.min-idle-conn");
            String maxActConn = PooledDatasourceHelper.getSystemSetting("dbcp-defaults.max-act-conn");
            String validQuery = null;
            String whenExhaustedAction = PooledDatasourceHelper.getSystemSetting("dbcp-defaults.when-exhausted-action");
            String wait = PooledDatasourceHelper.getSystemSetting("dbcp-defaults.wait");
            String testWhileIdleValue = PooledDatasourceHelper.getSystemSetting("dbcp-defaults.test-while-idle");
            String testOnBorrowValue = PooledDatasourceHelper.getSystemSetting("dbcp-defaults.test-on-borrow");
            String testOnReturnValue = PooledDatasourceHelper.getSystemSetting("dbcp-defaults.test-on-return");
            boolean testWhileIdle = !StringUtils.isEmpty((String)testWhileIdleValue) && Boolean.parseBoolean(testWhileIdleValue);
            boolean testOnBorrow = !StringUtils.isEmpty((String)testOnBorrowValue) && Boolean.parseBoolean(testOnBorrowValue);
            boolean testOnReturn = !StringUtils.isEmpty((String)testOnReturnValue) && Boolean.parseBoolean(testOnReturnValue);
            int maxActiveConnection = -1;
            long waitTime = -1L;
            byte whenExhaustedActionType = -1;
            int minIdleConnection = !StringUtils.isEmpty((String)minIdleConn) ? Integer.parseInt(minIdleConn) : -1;
            int maxIdleConnection = !StringUtils.isEmpty((String)maxdleConn) ? Integer.parseInt(maxdleConn) : -1;
            Map attributes = databaseConnection.getAttributes();
            if (attributes.containsKey("POOLING_maxActive")) {
                maxActiveConnection = Integer.parseInt((String)attributes.get("POOLING_maxActive"));
            } else if (!StringUtils.isEmpty((String)maxActConn)) {
                maxActiveConnection = Integer.parseInt(maxActConn);
            }
            if (attributes.containsKey("POOLING_maxWait")) {
                waitTime = Integer.parseInt((String)attributes.get("POOLING_maxWait"));
            } else if (!StringUtils.isEmpty((String)wait)) {
                waitTime = Long.parseLong(wait);
            }
            if (attributes.containsKey("query")) {
                validQuery = (String)attributes.get("query");
            }
            whenExhaustedActionType = !StringUtils.isEmpty((String)whenExhaustedAction) ? (byte)Byte.parseByte(whenExhaustedAction) : (byte)1;
            PoolingDataSource poolingDataSource = new PoolingDataSource();
            GenericObjectPool pool = new GenericObjectPool(null);
            pool.setWhenExhaustedAction(whenExhaustedActionType);
            pool.setMaxActive(maxActiveConnection);
            pool.setMaxIdle(maxIdleConnection);
            pool.setMaxWait(waitTime);
            pool.setMinIdle(minIdleConnection);
            pool.setTestWhileIdle(testWhileIdle);
            pool.setTestOnReturn(testOnReturn);
            pool.setTestOnBorrow(testOnBorrow);
            pool.setTestWhileIdle(testWhileIdle);
            Properties properties = new Properties();
            properties.setProperty("user", databaseConnection.getUsername());
            properties.setProperty("password", databaseConnection.getPassword());
            DriverConnectionFactory factory = new DriverConnectionFactory(PooledDatasourceHelper.getDriver(dialect, driverClass, url), url, properties);
            PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)factory, (ObjectPool)pool, null, validQuery, false, true);
            logger.debug((Object)("Pool defaults to " + maxActiveConnection + " max active/" + maxIdleConnection + "max idlewith " + waitTime + "wait time idle connections."));
            for (int i = 0; i < maxIdleConnection; ++i) {
                pool.addObject();
            }
            logger.debug((Object)("Pool now has " + pool.getNumActive() + " active/" + pool.getNumIdle() + " idle connections."));
            poolingDataSource.setPool((ObjectPool)pool);
            cacheManager.getDataSourceCache().put(databaseConnection.getName(), (DataSource)poolingDataSource);
            return poolingDataSource;
        }
        catch (Exception e) {
            throw new DatasourceServiceException((Throwable)e);
        }
    }

    static Driver getDriver(IDatabaseDialect dialect, String driverClass, String url) {
        if (dialect instanceof IDriverLocator) {
            return ((IDriverLocator)dialect).getDriver(url);
        }
        return (Driver)ObjectUtilities.loadAndInstantiate((String)driverClass, PooledDatasourceHelper.class, Driver.class);
    }

    private static String getSystemSetting(String key) {
        Configuration config = ClassicEngineBoot.getInstance().getGlobalConfig();
        return config.getConfigProperty("org.pentaho.reporting.engine.classic.core." + key);
    }
}

