/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.sla;

import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.sla.SLAJobEventXCommand;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.sla.SLACalcStatus;
import org.apache.oozie.util.LogUtils;

public class SLAWorkflowActionJobEventXCommand
extends SLAJobEventXCommand {
    WorkflowActionBean wa;

    public SLAWorkflowActionJobEventXCommand(SLACalcStatus slaCalc, long lockTimeOut) {
        super(slaCalc, lockTimeOut);
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.wa = WorkflowActionQueryExecutor.getInstance().get(WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION_FOR_SLA, this.slaCalc.getId());
        }
        catch (JPAExecutorException e) {
            throw new CommandException(e);
        }
        LogUtils.setLogInfo(this.wa);
    }

    @Override
    protected void updateJobInfo() {
        if (this.wa.getEndTime() != null) {
            this.setEnded(true);
            if (this.wa.isTerminalWithFailure() || this.wa.getEndTime().getTime() > this.slaCalc.getExpectedEnd().getTime()) {
                this.setEndMiss(true);
            }
        }
        this.slaCalc.setActualStart(this.wa.getStartTime());
        this.slaCalc.setActualEnd(this.wa.getEndTime());
        this.slaCalc.setJobStatus(this.wa.getStatusStr());
    }
}

