/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.tools.pigstats.EmbeddedPigStats;
import org.apache.pig.tools.pigstats.EmptyPigStats;
import org.apache.pig.tools.pigstats.PigStats;
import org.apache.pig.tools.pigstats.mapreduce.SimplePigStats;

public class PigStatsUtil {
    public static final String MAP_INPUT_RECORDS = "MAP_INPUT_RECORDS";
    public static final String MAP_OUTPUT_RECORDS = "MAP_OUTPUT_RECORDS";
    public static final String REDUCE_INPUT_RECORDS = "REDUCE_INPUT_RECORDS";
    public static final String REDUCE_OUTPUT_RECORDS = "REDUCE_OUTPUT_RECORDS";
    public static final String HDFS_BYTES_WRITTEN = "HDFS_BYTES_WRITTEN";
    public static final String HDFS_BYTES_READ = "HDFS_BYTES_READ";
    public static final String FILE_BYTES_WRITTEN = "FILE_BYTES_WRITTEN";
    public static final String FILE_BYTES_READ = "FILE_BYTES_READ";
    public static final String MULTI_INPUTS_RECORD_COUNTER = "Input records from ";
    public static final String MULTI_INPUTS_COUNTER_GROUP = "MultiInputCounters";
    public static final String MULTI_STORE_RECORD_COUNTER = "Output records in ";
    public static final String MULTI_STORE_COUNTER_GROUP = "MultiStoreCounters";
    @Deprecated
    public static final String TASK_COUNTER_GROUP = "org.apache.hadoop.mapred.Task$Counter";
    @Deprecated
    public static final String FS_COUNTER_GROUP = "org.apache.hadoop.mapreduce.FileSystemCounter";
    private static Pattern pattern = Pattern.compile("tmp(-)?[\\d]{1,10}$");
    private static final int COUNTER_NAME_LIMIT = 40;
    private static final String SEPARATOR = "/";
    private static final String SEMICOLON = ";";

    @Deprecated
    public static PigStats getEmptyPigStats() {
        return PigStats.start(new SimplePigStats());
    }

    public static PigStats getPigStats(int code) {
        PigStats ps = PigStats.get();
        if (ps == null) {
            ps = PigStats.start(new EmptyPigStats());
        }
        ps.setReturnCode(code);
        return ps;
    }

    public static void setErrorMessage(String msg) {
        PigStats ps = PigStats.get();
        if (ps == null) {
            ps = PigStats.start(new EmptyPigStats());
        }
        ps.setErrorMessage(msg);
    }

    public static void setErrorCode(int code) {
        PigStats ps = PigStats.get();
        if (ps == null) {
            ps = PigStats.start(new EmptyPigStats());
        }
        ps.setErrorCode(code);
    }

    public static void setErrorThrowable(Throwable t) {
        PigStats ps = PigStats.get();
        if (ps == null) {
            ps = PigStats.start(new EmptyPigStats());
        }
        ps.setErrorThrowable(t);
    }

    public static boolean isTempFile(String fileName) {
        Matcher result = pattern.matcher(fileName);
        return result.find();
    }

    public static void setStatsMap(Map<String, List<PigStats>> statsMap) {
        PigStats.start(new EmbeddedPigStats(statsMap));
    }

    public static String getMultiInputsCounterName(String fname, int index) {
        String shortName = PigStatsUtil.getShortName(fname);
        return shortName == null ? null : "Input records from _" + index + "_" + shortName;
    }

    public static String getMultiStoreCounterName(POStore store) {
        String shortName = PigStatsUtil.getShortName(store.getSFile().getFileName());
        return shortName == null ? null : "Output records in _" + store.getIndex() + "_" + shortName;
    }

    public static String getShortName(String uri) {
        int scolon = uri.indexOf(SEMICOLON);
        int slash = scolon != -1 ? uri.lastIndexOf(SEPARATOR, scolon) : uri.lastIndexOf(SEPARATOR);
        String shortName = null;
        if (scolon == -1) {
            shortName = uri.substring(slash + 1);
        }
        if (slash < scolon) {
            shortName = uri.substring(slash + 1, scolon);
        }
        if (shortName != null && shortName.length() > 40) {
            shortName = shortName.substring(shortName.length() - 40);
        }
        return shortName;
    }
}

