/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.plugins.common.ui;

import org.eclipse.swt.widgets.Shell;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.plugins.common.ui.CommonDialogFactory;
import org.pentaho.big.data.plugins.common.ui.NamedClusterDialogImpl;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegate;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;

public class HadoopClusterDelegateImpl
extends SpoonDelegate {
    public static final String SPOON_DIALOG_ERROR_DELETING_NAMED_CLUSTER_TITLE = "Spoon.Dialog.ErrorDeletingNamedCluster.Title";
    public static final String SPOON_DIALOG_ERROR_DELETING_NAMED_CLUSTER_MESSAGE = "Spoon.Dialog.ErrorDeletingNamedCluster.Message";
    public static final String SPOON_VARIOUS_DUPE_NAME = "Spoon.Various.DupeName";
    public static final String SPOON_DIALOG_ERROR_SAVING_NAMED_CLUSTER_TITLE = "Spoon.Dialog.ErrorSavingNamedCluster.Title";
    public static final String SPOON_DIALOG_ERROR_SAVING_NAMED_CLUSTER_MESSAGE = "Spoon.Dialog.ErrorSavingNamedCluster.Message";
    public static Class<?> PKG = HadoopClusterDelegateImpl.class;
    public static final String STRING_NAMED_CLUSTERS = BaseMessages.getString(PKG, (String)"NamedClusterDialog.HadoopClusters", (String[])new String[0]);
    private final NamedClusterService namedClusterService;
    private final RuntimeTestActionService runtimeTestActionService;
    private final RuntimeTester runtimeTester;
    private final CommonDialogFactory commonDialogFactory;

    public HadoopClusterDelegateImpl(Spoon spoon, NamedClusterService namedClusterService, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester) {
        this(spoon, namedClusterService, runtimeTestActionService, runtimeTester, new CommonDialogFactory());
    }

    public HadoopClusterDelegateImpl(Spoon spoon, NamedClusterService namedClusterService, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester, CommonDialogFactory commonDialogFactory) {
        super(spoon);
        this.namedClusterService = namedClusterService;
        this.runtimeTestActionService = runtimeTestActionService;
        this.runtimeTester = runtimeTester;
        this.commonDialogFactory = commonDialogFactory;
    }

    public void dupeNamedCluster(IMetaStore metaStore, NamedCluster nc, Shell shell) {
        if (metaStore == null) {
            metaStore = this.spoon.getMetaStore();
        }
        if (nc != null) {
            NamedCluster ncCopy = nc.clone();
            String dupename = BaseMessages.getString(Spoon.class, (String)SPOON_VARIOUS_DUPE_NAME, (String[])new String[0]) + nc.getName();
            ncCopy.setName(dupename);
            NamedClusterDialogImpl namedClusterDialogImpl = this.commonDialogFactory.createNamedClusterDialog(shell, this.namedClusterService, this.runtimeTestActionService, this.runtimeTester, ncCopy);
            namedClusterDialogImpl.setNewClusterCheck(true);
            String newname = namedClusterDialogImpl.open();
            if (newname != null) {
                this.saveNamedCluster(metaStore, ncCopy);
                this.spoon.refreshTree(STRING_NAMED_CLUSTERS);
            }
        }
    }

    public void delNamedCluster(IMetaStore metaStore, NamedCluster namedCluster) {
        if (metaStore == null) {
            metaStore = this.spoon.getMetaStore();
        }
        this.deleteNamedCluster(metaStore, namedCluster);
        this.spoon.refreshTree(STRING_NAMED_CLUSTERS);
        this.spoon.setShellText();
    }

    public String editNamedCluster(IMetaStore metaStore, NamedCluster namedCluster, Shell shell) {
        if (metaStore == null) {
            metaStore = this.spoon.getMetaStore();
        }
        NamedClusterDialogImpl namedClusterDialogImpl = this.commonDialogFactory.createNamedClusterDialog(shell, this.namedClusterService, this.runtimeTestActionService, this.runtimeTester, namedCluster.clone());
        namedClusterDialogImpl.setNewClusterCheck(false);
        String result = namedClusterDialogImpl.open();
        if (result != null) {
            this.deleteNamedCluster(metaStore, namedCluster);
            this.saveNamedCluster(metaStore, namedClusterDialogImpl.getNamedCluster());
            this.spoon.refreshTree(STRING_NAMED_CLUSTERS);
            if (namedClusterDialogImpl.getNamedCluster() != null) {
                return namedClusterDialogImpl.getNamedCluster().getName();
            }
        }
        return null;
    }

    public String newNamedCluster(VariableSpace variableSpace, IMetaStore metaStore, Shell shell) {
        if (metaStore == null) {
            metaStore = this.spoon.getMetaStore();
        }
        NamedCluster nc = this.namedClusterService.getClusterTemplate();
        NamedClusterDialogImpl namedClusterDialogImpl = this.commonDialogFactory.createNamedClusterDialog(shell, this.namedClusterService, this.runtimeTestActionService, this.runtimeTester, nc);
        namedClusterDialogImpl.setNewClusterCheck(true);
        String result = namedClusterDialogImpl.open();
        if (result != null) {
            if (variableSpace != null) {
                nc.shareVariablesWith(variableSpace);
            } else {
                nc.initializeVariablesFrom(null);
            }
            this.saveNamedCluster(metaStore, nc);
            this.spoon.refreshTree(STRING_NAMED_CLUSTERS);
            return nc.getName();
        }
        return null;
    }

    private void deleteNamedCluster(IMetaStore metaStore, NamedCluster namedCluster) {
        try {
            if (this.namedClusterService.read(namedCluster.getName(), metaStore) != null) {
                this.namedClusterService.delete(namedCluster.getName(), metaStore);
            }
        }
        catch (MetaStoreException e) {
            this.commonDialogFactory.createErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)SPOON_DIALOG_ERROR_DELETING_NAMED_CLUSTER_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)SPOON_DIALOG_ERROR_DELETING_NAMED_CLUSTER_MESSAGE, (String[])new String[]{namedCluster.getName()}), (Exception)((Object)e));
        }
    }

    private void saveNamedCluster(IMetaStore metaStore, NamedCluster namedCluster) {
        try {
            this.namedClusterService.create(namedCluster, metaStore);
        }
        catch (MetaStoreException e) {
            this.commonDialogFactory.createErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)SPOON_DIALOG_ERROR_SAVING_NAMED_CLUSTER_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)SPOON_DIALOG_ERROR_SAVING_NAMED_CLUSTER_MESSAGE, (String[])new String[]{namedCluster.getName()}), (Exception)((Object)e));
        }
    }
}

