/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.utils.mondrian;

import mondrian.mdx.MemberExpr;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.Position;
import mondrian.olap.Util;
import mondrian.rolap.RolapMeasure;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MDXTableModelUtils {
    private static final Log logger = LogFactory.getLog(MDXTableModelUtils.class);
    private static final String FORMATTED_MEASURE = "*FORMATTED_MEASURE_";

    public static String getProperMemberName(Member member, String defaultName) {
        if (defaultName.startsWith(FORMATTED_MEASURE)) {
            Member expressionMember = MDXTableModelUtils.extractExpressionMember(member);
            return expressionMember != null ? MDXTableModelUtils.getCaptionOrName(expressionMember) : defaultName;
        }
        return defaultName;
    }

    public static String computeUniqueColumnName(Position position) {
        StringBuffer positionName = new StringBuffer(100);
        for (int j = 0; j < position.size(); ++j) {
            if (j != 0) {
                positionName.append('/');
            }
            Member member = (Member)position.get(j);
            positionName.append(MDXTableModelUtils.getUniqueMemberName(member));
        }
        return positionName.toString();
    }

    public static String getUniqueMemberName(Member member) {
        String memberValue = Util.quoteMdxIdentifier((String)MDXTableModelUtils.getProperMemberName(member));
        while (member.getParentMember() != null) {
            memberValue = Util.quoteMdxIdentifier((String)MDXTableModelUtils.getProperMemberName(member.getParentMember())) + "." + memberValue;
            member = member.getParentMember();
        }
        Hierarchy hierarchy = member.getHierarchy();
        Dimension dimension = hierarchy.getDimension();
        if (hierarchy.getName().equals(dimension.getName())) {
            return Util.quoteMdxIdentifier((String)hierarchy.getName()) + "." + memberValue;
        }
        return Util.quoteMdxIdentifier((String)dimension.getName()) + "." + Util.quoteMdxIdentifier((String)hierarchy.getName()) + "." + memberValue;
    }

    private static Member extractExpressionMember(Member member) {
        try {
            Exp exp;
            if (member instanceof RolapMeasure && (exp = member.getExpression()) instanceof MemberExpr) {
                return ((MemberExpr)exp).getMember();
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error retrieving expression member, returning null", (Throwable)e);
        }
        return null;
    }

    private static String getProperMemberName(Member member) {
        String memberName = member.getName();
        if (memberName.startsWith(FORMATTED_MEASURE)) {
            Member expressionMember = MDXTableModelUtils.extractExpressionMember(member);
            return expressionMember != null ? MDXTableModelUtils.getCaptionOrName(expressionMember) : memberName;
        }
        return memberName;
    }

    private static String getCaptionOrName(Member member) {
        String caption = member.getCaption();
        if (caption.startsWith("%{") && caption.endsWith("}")) {
            return member.getName();
        }
        return caption;
    }
}

