/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pt.webdetails.cda.utils.DoQueryParameters;

public class QueryParameters {
    private final String PREFIX_PARAMETER = "param";
    private final String PREFIX_SETTING = "setting";

    public Map<String, List<String>> getParametersFromJson(String message) throws JSONException {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        JSONObject jsonObject = new JSONObject(message);
        Iterator keys = jsonObject.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Object item = jsonObject.get(key);
            if (item instanceof JSONArray) {
                JSONArray itemArray = (JSONArray)item;
                for (int i = 0; i < itemArray.length(); ++i) {
                    this.addMultiValueToMap(params, key, itemArray.getString(i));
                }
                continue;
            }
            this.addMultiValueToMap(params, key, jsonObject.getString(key));
        }
        return params;
    }

    public DoQueryParameters getDoQueryParameters(Map<String, List<String>> parameters) throws Exception {
        DoQueryParameters doQueryParams = new DoQueryParameters();
        BeanUtils.populate((Object)doQueryParams, parameters);
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object> extraSettings = new HashMap<String, Object>();
        for (String name : parameters.keySet()) {
            if (name.startsWith("param")) {
                params.put(name.replaceFirst("param", ""), this.getParam(parameters.get(name)));
                continue;
            }
            if (!name.startsWith("setting")) continue;
            extraSettings.put(name.replaceFirst("setting", ""), this.getParam(parameters.get(name)));
        }
        doQueryParams.setParameters(params);
        doQueryParams.setExtraSettings(extraSettings);
        return doQueryParams;
    }

    private Object getParam(List<String> paramValues) {
        if (paramValues == null) {
            return null;
        }
        if (paramValues.size() == 1) {
            return paramValues.get(0);
        }
        if (paramValues instanceof List) {
            return paramValues.toArray();
        }
        return paramValues;
    }

    public void addMultiValueToMap(Map<String, List<String>> map, String key, String value) {
        if (value != null) {
            List<String> values = map.get(key);
            if (values != null) {
                values.add(value);
            } else {
                ArrayList<String> newValuesList = new ArrayList<String>();
                newValuesList.add(value);
                map.put(key, newValuesList);
            }
        }
    }
}

