/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.utils;

import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cda.dataaccess.Parameter;

public class ParameterArrayToStringEncoder {
    private static final Log logger = LogFactory.getLog(ParameterArrayToStringEncoder.class);
    private String fieldSeparator;
    private String quoteCharacter;

    public ParameterArrayToStringEncoder(String fieldSeparator, String quoteCharacter) {
        this.fieldSeparator = fieldSeparator;
        this.quoteCharacter = quoteCharacter == null ? "" : quoteCharacter;
    }

    public String encodeParameterArray(Object parameterArrayValue, Parameter.Type type) {
        switch (type) {
            case STRING_ARRAY: {
                if (parameterArrayValue instanceof List) {
                    parameterArrayValue = ((List)parameterArrayValue).toArray();
                }
                if (!(parameterArrayValue instanceof String[]) && parameterArrayValue instanceof Object[]) {
                    Object[] oldVal = parameterArrayValue;
                    String[] newVal = new String[oldVal.length];
                    for (int i = 0; i < oldVal.length; ++i) {
                        newVal[i] = "" + oldVal[i];
                    }
                    parameterArrayValue = newVal;
                }
                String[] strArr = (String[])parameterArrayValue;
                int i = 0;
                StringBuilder strBuild = new StringBuilder();
                for (String s : strArr) {
                    if (i++ > 0) {
                        strBuild.append(this.fieldSeparator);
                    }
                    strBuild.append(this.quoteCharacter);
                    strBuild.append(s.replace(this.quoteCharacter, this.quoteCharacter + this.quoteCharacter));
                    strBuild.append(this.quoteCharacter);
                }
                return strBuild.toString();
            }
        }
        if (parameterArrayValue instanceof Object[]) {
            Object[] arr = parameterArrayValue;
            int i = 0;
            StringBuilder strBuild = new StringBuilder();
            for (Object o : arr) {
                if (i++ > 0) {
                    strBuild.append(this.fieldSeparator);
                }
                if (o instanceof Date) {
                    strBuild.append(((Date)o).getTime());
                    continue;
                }
                strBuild.append(o);
            }
            return strBuild.toString();
        }
        logger.warn((Object)"Non array type passed to ArrayEncoder. Returning input value as String");
        return parameterArrayValue.toString();
    }
}

