/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.utils;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.table.TableModel;
import org.apache.commons.lang.StringUtils;

public class NaturalOrderComparator
implements Comparator<Integer> {
    private TableModel baseData;
    private List<String> sortBy;
    Comparator<String> stringComparator = String.CASE_INSENSITIVE_ORDER;
    Pattern recognizeNbr = Pattern.compile("[\\s]*[-+]?(?:(?:\\d[\\d,]*)(?:[.][\\d]+)?|([.][\\d]+))");

    public NaturalOrderComparator(TableModel baseData, List<String> sortBy) {
        this.baseData = baseData;
        this.sortBy = sortBy;
    }

    @Override
    public int compare(Integer i0, Integer i1) {
        for (String entry : this.sortBy) {
            char direction = entry.charAt(entry.length() - 1);
            boolean ascending = direction == 'A' || direction == 'a';
            int i = Integer.parseInt(entry.substring(0, entry.length() - 1), 10);
            int bigger = 0;
            String v0 = this.baseData.getValueAt(i0, i) != null ? this.baseData.getValueAt(i0, i).toString() : "";
            String v1 = this.baseData.getValueAt(i1, i) != null ? this.baseData.getValueAt(i1, i).toString() : "";
            boolean v0Empty = false;
            boolean v1Empty = false;
            if (v0.compareTo("Infinity") == 0 || v0.compareTo("") == 0 || v0.compareTo("null") == 0) {
                v0Empty = true;
            }
            if (v1.compareTo("Infinity") == 0 || v1.compareTo("") == 0 || v1.compareTo("null") == 0) {
                v1Empty = true;
            }
            if (v0Empty && v1Empty) {
                return 0;
            }
            if (v0Empty) {
                return 1;
            }
            if (v1Empty) {
                return -1;
            }
            bigger = this.compareStrings(v0, v1);
            if (bigger == 0) continue;
            return ascending ? bigger : -bigger;
        }
        return 0;
    }

    public int compareStrings(String a, String b) {
        if (a == null) {
            if (b == null) {
                return 0;
            }
            return -1;
        }
        if (b == null) {
            return 1;
        }
        Matcher matcherA = this.recognizeNbr.matcher(a);
        Matcher matcherB = this.recognizeNbr.matcher(b);
        int idxA = 0;
        int idxB = 0;
        while (idxA < a.length() || idxB < b.length()) {
            BigDecimal numberB;
            String preB;
            boolean foundInA = matcherA.find(idxA);
            boolean foundInB = matcherB.find(idxB);
            if (!foundInA || !foundInB) {
                return this.stringComparator.compare(a.substring(idxA), b.substring(idxB));
            }
            String preA = StringUtils.substring((String)a, (int)idxA, (int)matcherA.start());
            int comparison = this.stringComparator.compare(preA, preB = StringUtils.substring((String)b, (int)idxB, (int)matcherB.start()));
            if (comparison != 0) {
                return comparison;
            }
            String matchA = StringUtils.substring((String)a, (int)matcherA.start(), (int)matcherA.end());
            String matchB = StringUtils.substring((String)b, (int)matcherB.start(), (int)matcherB.end());
            BigDecimal numberA = new BigDecimal(StringUtils.remove((String)matchA, (char)',').trim());
            comparison = numberA.compareTo(numberB = new BigDecimal(StringUtils.remove((String)matchB, (char)',').trim()));
            if (comparison != 0) {
                return comparison;
            }
            idxA = matcherA.end();
            idxB = matcherB.end();
        }
        return 0;
    }
}

