/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.utils;

import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.EmptyDataAttributes;
import org.pentaho.reporting.libraries.formula.DefaultFormulaContext;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.parser.ParseException;
import pt.webdetails.cda.dataaccess.ColumnDefinition;
import pt.webdetails.cda.utils.CalculatedColumnException;

public class CalculatedTableModel
implements MetaTableModel {
    private MetaTableModel metaTableModel;
    private TableModel backend;
    private ColumnDefinition[] calculatedColumns;
    private int backendColumnCount;
    private boolean inferTypes = false;
    private Class<?>[] calculatedColumnClasses;

    public CalculatedTableModel(TableModel backend, ColumnDefinition[] calculatedColumns, boolean inferColumnTypes) {
        this(backend, calculatedColumns);
        this.inferTypes = inferColumnTypes;
        if (this.inferTypes) {
            this.calculatedColumnClasses = new Class[calculatedColumns.length];
        }
    }

    public CalculatedTableModel(TableModel backend, ColumnDefinition[] calculatedColumns) {
        if (backend == null) {
            throw new IllegalArgumentException("Attempting to create a calculated table model from null table.");
        }
        if (calculatedColumns == null) {
            throw new IllegalArgumentException("Null calculated columns.");
        }
        this.backend = backend;
        this.backendColumnCount = backend.getColumnCount();
        this.calculatedColumns = (ColumnDefinition[])calculatedColumns.clone();
        if (backend instanceof MetaTableModel) {
            this.metaTableModel = (MetaTableModel)backend;
        }
    }

    public int getRowCount() {
        return this.backend.getRowCount();
    }

    public int getColumnCount() {
        return this.backend.getColumnCount() + this.calculatedColumns.length;
    }

    public String getColumnName(int columnIndex) {
        if (columnIndex < this.backendColumnCount) {
            return this.backend.getColumnName(columnIndex);
        }
        int calculatedColumnIndex = columnIndex - this.backendColumnCount;
        return this.calculatedColumns[calculatedColumnIndex].getName();
    }

    public Class<?> getColumnClass(int columnIndex) {
        int calcColumnIndex;
        if (columnIndex < this.backendColumnCount) {
            return this.backend.getColumnClass(columnIndex);
        }
        if (this.inferTypes && (calcColumnIndex = columnIndex - this.backendColumnCount) < this.calculatedColumnClasses.length && this.calculatedColumnClasses[calcColumnIndex] != null) {
            return this.calculatedColumnClasses[calcColumnIndex];
        }
        return Object.class;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex < this.backendColumnCount) {
            return this.backend.isCellEditable(rowIndex, columnIndex);
        }
        return false;
    }

    protected void accumulateClassAt(int calcColumnIndex, Class<?> valueClass) {
        if (this.calculatedColumnClasses[calcColumnIndex] == null) {
            this.calculatedColumnClasses[calcColumnIndex] = valueClass;
        } else if (!this.calculatedColumnClasses[calcColumnIndex].isAssignableFrom(valueClass)) {
            this.calculatedColumnClasses[calcColumnIndex] = valueClass.isAssignableFrom(this.calculatedColumnClasses[calcColumnIndex]) ? valueClass : Object.class;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getValueInternal(int columnIndex, DataAccessFormulaContext context) throws ParseException, EvaluationException {
        if (columnIndex < this.backendColumnCount) {
            return this.backend.getValueAt(context.getRowIndex(), columnIndex);
        }
        int calcColumnIndex = columnIndex - this.backendColumnCount;
        try {
            int separator;
            context.lock(calcColumnIndex);
            String formula = this.calculatedColumns[calcColumnIndex].getFormula();
            String formulaExpression = formula.length() > 0 && formula.charAt(0) == '=' ? formula.substring(1) : ((separator = formula.indexOf(58)) <= 0 || separator + 1 == formula.length() ? null : formula.substring(separator + 1));
            Formula formulaObject = new Formula(formulaExpression);
            formulaObject.initialize((FormulaContext)context);
            Object value = formulaObject.evaluate();
            if (this.isLibFormulaErrorValue(value)) {
                value = null;
            }
            if (this.inferTypes && value != null) {
                this.accumulateClassAt(calcColumnIndex, value.getClass());
            }
            Object object = value;
            return object;
        }
        finally {
            context.unlock(calcColumnIndex);
        }
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex < this.backendColumnCount) {
            return this.backend.getValueAt(rowIndex, columnIndex);
        }
        try {
            DataAccessFormulaContext formulaContext = new DataAccessFormulaContext(rowIndex);
            return this.getValueInternal(columnIndex, formulaContext);
        }
        catch (Exception e) {
            throw new IllegalStateException(new CalculatedColumnException("Error in calculated column position (" + rowIndex + "," + columnIndex + ");", e));
        }
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex < this.backendColumnCount) {
            this.backend.setValueAt(aValue, rowIndex, columnIndex);
        }
    }

    public void addTableModelListener(TableModelListener l) {
    }

    public void removeTableModelListener(TableModelListener l) {
    }

    public DataAttributes getCellDataAttributes(int row, int columnIndex) {
        if (this.metaTableModel == null) {
            return EmptyDataAttributes.INSTANCE;
        }
        if (columnIndex < this.backendColumnCount) {
            return this.metaTableModel.getCellDataAttributes(row, columnIndex);
        }
        return EmptyDataAttributes.INSTANCE;
    }

    public boolean isCellDataAttributesSupported() {
        if (this.metaTableModel == null) {
            return false;
        }
        return this.metaTableModel.isCellDataAttributesSupported();
    }

    public DataAttributes getColumnAttributes(int columnIndex) {
        if (this.metaTableModel == null) {
            return EmptyDataAttributes.INSTANCE;
        }
        if (columnIndex < this.backendColumnCount) {
            return this.metaTableModel.getColumnAttributes(columnIndex);
        }
        return EmptyDataAttributes.INSTANCE;
    }

    public DataAttributes getTableAttributes() {
        if (this.metaTableModel == null) {
            return EmptyDataAttributes.INSTANCE;
        }
        return this.metaTableModel.getTableAttributes();
    }

    private boolean isLibFormulaErrorValue(Object formulaError) {
        return formulaError != null && formulaError instanceof LibFormulaErrorValue;
    }

    private class DataAccessFormulaContext
    extends DefaultFormulaContext {
        private int rowIndex;
        private boolean[] columnLocks;

        private DataAccessFormulaContext(int rowIndex) {
            this.rowIndex = rowIndex;
            this.columnLocks = new boolean[CalculatedTableModel.this.calculatedColumns.length];
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public void lock(int calcColumnIndex) {
            if (this.columnLocks[calcColumnIndex]) {
                throw new IllegalStateException("Infinite loop while evaluating a formula");
            }
            this.columnLocks[calcColumnIndex] = true;
        }

        public void unlock(int calcColumnIndex) {
            this.columnLocks[calcColumnIndex] = true;
        }

        public Object resolveReference(Object name) {
            for (int column = 0; column < CalculatedTableModel.this.getColumnCount(); ++column) {
                if (!CalculatedTableModel.this.getColumnName(column).equals(name)) continue;
                return CalculatedTableModel.this.getValueAt(this.rowIndex, column);
            }
            return null;
        }
    }
}

