/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.exporter;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pt.webdetails.cda.exporter.AbstractExporter;
import pt.webdetails.cda.exporter.ExporterException;
import pt.webdetails.cda.exporter.XmlExporter;
import pt.webdetails.cda.utils.MetadataTableModel;

public class JsonExporter
extends AbstractExporter {
    private static final String MIME_TYPE = "application/json";
    private static final Log logger = LogFactory.getLog(XmlExporter.class);
    private String attachmentName;
    boolean isJsonp = false;

    public JsonExporter() {
    }

    public JsonExporter(Map<String, String> extraSettings) {
        super(extraSettings);
        if (this.getSetting("callback", null) != null) {
            this.isJsonp = true;
        }
        this.attachmentName = this.getSetting("attachmentName", null);
        logger.debug((Object)("Initialized JsonExporter with attachment filename '" + this.attachmentName + "'"));
    }

    @Override
    public void export(OutputStream out, TableModel tableModel) throws ExporterException {
        try {
            JSONObject json = this.getTableAsJson(tableModel, null);
            try {
                if (this.isJsonp) {
                    out.write(this.getSetting("callback", "xxx").concat("(").getBytes("UTF-8"));
                }
                out.write(json.toString().getBytes("UTF-8"));
                if (this.isJsonp) {
                    out.write(");".getBytes("UTF-8"));
                }
                out.flush();
            }
            catch (IOException e) {
                throw new ExporterException("IO Exception converting to utf-8", e);
            }
        }
        catch (JSONException e) {
            throw new ExporterException("JSONException building object", (Exception)((Object)e));
        }
    }

    public JSONObject getTableAsJson(TableModel tableModel, Integer rowLimit) throws JSONException, ExporterException {
        JSONObject json = new JSONObject();
        JSONArray metadataArray = new JSONArray();
        int columnCount = tableModel.getColumnCount();
        int rowCount = tableModel.getRowCount();
        if (rowLimit != null) {
            rowCount = Math.min(rowCount, rowLimit);
        }
        boolean[] isColumnDouble = new boolean[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            JSONObject info = new JSONObject();
            info.put("colIndex", i);
            info.put("colName", (Object)tableModel.getColumnName(i));
            Class<Double> columnClass = tableModel.getColumnClass(i);
            isColumnDouble[i] = columnClass.isAssignableFrom(Double.class);
            info.put("colType", (Object)this.getColType(columnClass));
            metadataArray.put((Object)info);
        }
        json.put("metadata", (Object)metadataArray);
        if (tableModel instanceof MetadataTableModel) {
            json.put("queryInfo", ((MetadataTableModel)((Object)tableModel)).getAllMetadata());
        }
        JSONArray valuesArray = new JSONArray();
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            JSONArray rowArray = new JSONArray();
            for (int colIdx = 0; colIdx < columnCount; ++colIdx) {
                Object value = tableModel.getValueAt(rowIdx, colIdx);
                try {
                    if (value != null && isColumnDouble[colIdx] && (((Double)value).isInfinite() || ((Double)value).isNaN())) {
                        value = null;
                    }
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                rowArray.put(value);
            }
            valuesArray.put((Object)rowArray);
        }
        json.put("resultset", (Object)valuesArray);
        return json;
    }

    @Override
    public String getMimeType() {
        return MIME_TYPE;
    }

    @Override
    public String getAttachmentName() {
        return this.attachmentName;
    }
}

