/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.exporter;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.textfileoutput.TextFileField;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputMeta;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.exporter.AbstractKettleExporter;

public class CsvExporter
extends AbstractKettleExporter {
    public static final String CSV_SEPARATOR_SETTING = "csvSeparator";
    public static final String CSV_QUOTE_SETTING = "csvQuote";
    private static final Log logger = LogFactory.getLog(CsvExporter.class);
    private static final String DEFAULT_CSV_SEPARATOR_SETTING = ";";
    private static final String DEFAULT_CSV_ENCLOSURE_SETTING = "\"";
    private String separator = this.getSetting("csvSeparator", CdaEngine.getInstance().getConfigProperty("pt.webdetails.cda.exporter.csv.Separator", ";"));
    private String enclosure = this.getSetting("csvQuote", CdaEngine.getInstance().getConfigProperty("pt.webdetails.cda.exporter.csv.Enclosure", "\""));
    private String attachmentName = this.getSetting("attachmentName", "cda-export.csv");
    private boolean showColumnHeaders = Boolean.parseBoolean(this.getSetting("columnHeaders", "true"));

    public CsvExporter(Map<String, String> extraSettings) {
        super(extraSettings);
        logger.debug((Object)("Initialized CsvExporter with attachement filename '" + this.attachmentName + "'"));
        logger.debug((Object)("Initialized CsvExporter with enclosure '" + this.enclosure + "'"));
        logger.debug((Object)("Initialized CsvExporter with show columns '" + this.showColumnHeaders + "'"));
        logger.debug((Object)("Initialized CsvExporter with separator '" + this.separator + "'"));
    }

    @Override
    protected StepMeta getExportStepMeta(String name) {
        TextFileOutputMeta csvOutputStepMeta = new TextFileOutputMeta();
        csvOutputStepMeta.setOutputFields(new TextFileField[0]);
        csvOutputStepMeta.setSeparator(this.separator);
        csvOutputStepMeta.setEnclosure(this.enclosure);
        csvOutputStepMeta.setEnclosureForced(true);
        csvOutputStepMeta.setHeaderEnabled(this.showColumnHeaders);
        csvOutputStepMeta.setFooterEnabled(false);
        csvOutputStepMeta.setFilename("${java.io.tmpdir}/" + this.getFileName());
        csvOutputStepMeta.setExtension("csv");
        csvOutputStepMeta.setFastDump(true);
        StepMeta stepMeta = new StepMeta(name, (StepMetaInterface)csvOutputStepMeta);
        stepMeta.setCopies(1);
        return stepMeta;
    }

    @Override
    public String getMimeType() {
        return "text/csv";
    }

    @Override
    public String getAttachmentName() {
        return this.attachmentName;
    }

    @Override
    public String getType() {
        return "csv";
    }
}

