/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.events;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import pt.webdetails.cpf.messaging.JsonSerializable;
import pt.webdetails.cpf.messaging.PluginEvent;

public abstract class CdaEvent
extends PluginEvent {
    private QueryInfo queryInfo;

    public CdaEvent(CdaEventType eventType, QueryInfo queryInfo) throws JSONException {
        super("cda", eventType.toString(), queryInfo.cdaSettingsId);
        this.queryInfo = queryInfo;
        this.setKey(eventType.toString());
    }

    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    public void setQueryInfo(QueryInfo queryInfo) {
        this.queryInfo = queryInfo;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject obj = super.toJSON();
        obj.put(Fields.QUERY_INFO, (Object)this.queryInfo.toJSON());
        return obj;
    }

    public static class QueryInfo
    implements JsonSerializable {
        String cdaSettingsId;
        String dataAccessId;
        String query;
        ParameterDataRow parameters;

        public QueryInfo(String cdaSettingsId, String dataAccessId, String query, ParameterDataRow parameters) {
            this.cdaSettingsId = cdaSettingsId;
            this.dataAccessId = dataAccessId;
            this.query = query;
            this.parameters = parameters;
        }

        public JSONObject toJSON() throws JSONException {
            JSONObject obj = new JSONObject();
            obj.put("cdaSettingsId", (Object)this.cdaSettingsId);
            obj.put("dataAccessId", (Object)this.dataAccessId);
            obj.put("query", (Object)this.query);
            JSONArray params = new JSONArray();
            for (String paramName : this.parameters.getColumnNames()) {
                JSONArray param = new JSONArray();
                param.put(0, (Object)paramName).put(1, this.parameters.get(paramName));
                params.put((Object)param);
            }
            obj.put("parameters", (Object)params);
            return obj;
        }
    }

    static enum CdaEventType {
        QueryTooLong,
        QueryError;

    }

    public static class Fields
    extends PluginEvent.Fields {
        public static String QUERY_INFO = "queryInfo";
    }
}

