/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.dataaccess.kettle;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.formula.FormulaMeta;
import org.pentaho.di.trans.steps.formula.FormulaMetaFunction;
import org.pentaho.di.trans.steps.selectvalues.SelectValuesMeta;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.SQLParameterLookupParser;
import pt.webdetails.cda.connections.sql.JdbcConnection;
import pt.webdetails.cda.connections.sql.JdbcConnectionInfo;
import pt.webdetails.cda.connections.sql.JndiConnection;
import pt.webdetails.cda.connections.sql.SqlConnection;
import pt.webdetails.cda.dataaccess.ColumnDefinition;
import pt.webdetails.cda.dataaccess.Parameter;
import pt.webdetails.cda.dataaccess.SqlDataAccess;
import pt.webdetails.cda.dataaccess.kettle.DataAccessKettleAdapter;
import pt.webdetails.cda.dataaccess.kettle.KettleAdapterException;
import pt.webdetails.cda.query.QueryOptions;
import pt.webdetails.cda.settings.UnknownConnectionException;

public class SQLKettleAdapter
implements DataAccessKettleAdapter {
    private SqlDataAccess dataAccess;
    private QueryOptions queryOptions;
    private DatabaseMeta databaseMeta;
    private String translatedQuery;
    private String[] parameterNames;
    private DataRow parameters;
    private final String DUMMY_DATABASE_NAME = "cda_dummy_datasource_name_for_export";

    public SQLKettleAdapter(SqlDataAccess dataAccess, QueryOptions queryOptions) {
        this.dataAccess = dataAccess;
        this.queryOptions = queryOptions;
    }

    @Override
    public StepMeta getFilterStepMeta(String name, String[] columns) throws KettleAdapterException {
        try {
            SelectValuesMeta selectValuesMeta = new SelectValuesMeta();
            selectValuesMeta.setDefault();
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<ColumnDefinition> calculatedColumns = this.dataAccess.getCalculatedColumns();
            if (calculatedColumns.size() > 0) {
                ArrayList<String> extendedColumns = new ArrayList<String>();
                for (String s : columns) {
                    extendedColumns.add(s);
                }
                for (ColumnDefinition col : calculatedColumns) {
                    extendedColumns.add(col.getName());
                }
                columns = extendedColumns.toArray(new String[extendedColumns.size()]);
            }
            ArrayList<Integer> outputs = this.dataAccess.getOutputs();
            for (int n = 0; n < outputs.size(); ++n) {
                if (outputs.get(n) > columns.length - 1) {
                    throw new KettleAdapterException("Error initializing Kettle Select Field step for SQL data access type. Invalid index.");
                }
                fields.add(columns[outputs.get(n)]);
            }
            if (this.dataAccess.getOutputMode().ordinal() == 0) {
                String[] emptyStr = new String[fields.size()];
                int[] dummyValue = new int[fields.size()];
                for (int n = 0; n < fields.size(); ++n) {
                    emptyStr[n] = "";
                    dummyValue[n] = -2;
                }
                selectValuesMeta.setSelectRename(emptyStr);
                selectValuesMeta.setSelectLength(dummyValue);
                selectValuesMeta.setSelectPrecision(dummyValue);
                selectValuesMeta.setSelectName(fields.toArray(new String[fields.size()]));
            } else {
                selectValuesMeta.setDeleteName(fields.toArray(new String[fields.size()]));
            }
            StepMeta stepMeta = new StepMeta(name, (StepMetaInterface)selectValuesMeta);
            stepMeta.setCopies(1);
            return stepMeta;
        }
        catch (Exception e) {
            throw new KettleAdapterException("Error initializing Kettle Select Field step for SQL data access type", e);
        }
    }

    @Override
    public StepMeta getKettleStepMeta(String name) throws KettleAdapterException {
        try {
            TableInputMeta tableInputMeta = new TableInputMeta();
            tableInputMeta.setDatabaseMeta(this.getDatabaseMeta());
            this.prepareQuery();
            tableInputMeta.setSQL(this.translatedQuery);
            StepMeta stepMeta = new StepMeta(name, (StepMetaInterface)tableInputMeta);
            stepMeta.setCopies(1);
            return stepMeta;
        }
        catch (Exception e) {
            throw new KettleAdapterException("Error initializing Kettle step for SQL data access type", e);
        }
    }

    private void prepareQuery() throws KettleAdapterException {
        if (this.translatedQuery == null) {
            try {
                this.parameters = Parameter.createParameterDataRowFromParameters(this.dataAccess.getFilledParameters(this.queryOptions));
                SQLParameterLookupParser parser = new SQLParameterLookupParser(true);
                this.translatedQuery = parser.translateAndLookup(this.dataAccess.getQuery(), this.parameters);
                this.parameterNames = parser.getFields();
            }
            catch (Exception e) {
                throw new KettleAdapterException("Unable to substitute data access parameters", e);
            }
        }
    }

    @Override
    public DataRow getParameters() throws KettleAdapterException {
        this.prepareQuery();
        return this.parameters;
    }

    @Override
    public String[] getParameterNames() throws KettleAdapterException {
        this.prepareQuery();
        return this.parameterNames;
    }

    protected DatabaseMeta getDatabaseMeta() throws KettleAdapterException {
        if (this.databaseMeta == null) {
            SqlConnection connection;
            try {
                connection = (SqlConnection)this.dataAccess.getCdaSettings().getConnection(this.dataAccess.getConnectionId());
            }
            catch (UnknownConnectionException e) {
                throw new KettleAdapterException(e);
            }
            if (connection instanceof JdbcConnection) {
                JdbcConnectionInfo connectionInfo = ((JdbcConnection)connection).getConnectionInfo();
                this.databaseMeta = new DatabaseMeta(connection.getId(), "GENERIC", "Native", null, null, null, connectionInfo.getUser(), connectionInfo.getPass());
                this.databaseMeta.getAttributes().put("CUSTOM_URL", connectionInfo.getUrl());
                this.databaseMeta.getAttributes().put("CUSTOM_DRIVER_CLASS", connectionInfo.getDriver());
            } else if (connection instanceof JndiConnection) {
                JndiConnection jndiConnection = (JndiConnection)connection;
                this.databaseMeta = new DatabaseMeta(connection.getId(), "GENERIC", "JNDI", null, jndiConnection.getConnectionInfo().getJndi(), null, null, null);
            } else {
                throw new KettleAdapterException("Unsupported connection type: " + connection.getClass().getName());
            }
        }
        if (StringUtils.isEmpty((String)this.databaseMeta.getDatabaseName())) {
            this.databaseMeta.setDBName("cda_dummy_datasource_name_for_export");
        }
        return this.databaseMeta;
    }

    @Override
    public DatabaseMeta[] getDatabases() throws KettleAdapterException {
        return new DatabaseMeta[]{this.getDatabaseMeta()};
    }

    @Override
    public ArrayList<Integer> getDataAccessOutputs() throws KettleAdapterException {
        return this.dataAccess.getOutputs();
    }

    @Override
    public boolean hasCalculatedColumns() {
        return this.dataAccess.getCalculatedColumns().size() > 0;
    }

    @Override
    public StepMeta getFormulaStepMeta(String name) {
        FormulaMeta formulaMeta = new FormulaMeta();
        formulaMeta.setDefault();
        ArrayList<FormulaMetaFunction> calcTypes = new ArrayList<FormulaMetaFunction>();
        for (ColumnDefinition col : this.dataAccess.getCalculatedColumns()) {
            String formula = col.getFormula();
            if (formula.indexOf("=") == 0) {
                formula = formula.substring(1);
            }
            calcTypes.add(new FormulaMetaFunction(col.getName(), formula, col.getType().ordinal(), -1, -1, ""));
        }
        formulaMeta.setFormula(calcTypes.toArray(new FormulaMetaFunction[calcTypes.size()]));
        StepMeta stepMeta = new StepMeta(name, (StepMetaInterface)formulaMeta);
        stepMeta.setCopies(1);
        return stepMeta;
    }
}

