/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.dataaccess;

import io.reactivex.Observer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Wrapper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.trans.dataservice.client.api.IDataServiceClientService;
import org.pentaho.di.trans.dataservice.jdbc.api.IThinPreparedStatement;
import org.pentaho.di.trans.dataservice.jdbc.api.IThinStatement;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ConnectionProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.DefaultParametrizationProviderFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ParametrizationProvider;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.ParametrizationProviderFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.SQLReportDataFactory;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.connections.ConnectionCatalog;
import pt.webdetails.cda.connections.InvalidConnectionException;
import pt.webdetails.cda.connections.dataservices.DataservicesConnection;
import pt.webdetails.cda.dataaccess.DataAccessEnums;
import pt.webdetails.cda.dataaccess.DataservicesDataAccess;
import pt.webdetails.cda.dataaccess.InvalidParameterException;
import pt.webdetails.cda.dataaccess.Parameter;
import pt.webdetails.cda.dataaccess.PropertyDescriptor;
import pt.webdetails.cda.dataaccess.QueryException;
import pt.webdetails.cda.dataaccess.streaming.IStreamingDataAccess;
import pt.webdetails.cda.query.QueryOptions;
import pt.webdetails.cda.settings.UnknownConnectionException;
import pt.webdetails.cda.utils.streaming.SQLStreamingReportDataFactory;
import pt.webdetails.cda.xml.DomVisitor;

public class StreamingDataservicesDataAccess
extends DataservicesDataAccess
implements IStreamingDataAccess {
    private static final Log logger = LogFactory.getLog(StreamingDataservicesDataAccess.class);
    private static final DataAccessEnums.DataAccessInstanceType TYPE = DataAccessEnums.DataAccessInstanceType.STREAMING_DATASERVICES;
    protected String dataServiceName;
    protected String windowMode;
    protected long windowSize;
    protected long windowEvery;
    protected long windowLimit;

    public StreamingDataservicesDataAccess(Element element) {
        super(element);
        this.dataServiceName = element.selectSingleNode("./StreamingDataServiceName").getText();
        this.windowMode = String.valueOf(element.selectSingleNode("./WindowMode").getText());
        this.windowSize = Integer.valueOf(element.selectSingleNode("./WindowSize").getText()).intValue();
        this.windowEvery = Long.valueOf(element.selectSingleNode("./WindowEvery").getText());
        this.windowLimit = Long.valueOf(element.selectSingleNode("./WindowLimit").getText());
    }

    @Override
    public String getDataServiceName() {
        return this.dataServiceName;
    }

    public String getWindowMode() {
        return this.windowMode;
    }

    public long getWindowSize() {
        return this.windowSize;
    }

    public long getWindowEvery() {
        return this.windowEvery;
    }

    public long getWindowLimit() {
        return this.windowLimit;
    }

    public StreamingDataservicesDataAccess() {
    }

    @Override
    public SQLReportDataFactory getSQLReportDataFactory(DataservicesConnection connection, ParameterDataRow parameterDataRow) throws InvalidConnectionException, UnknownConnectionException {
        IDataServiceClientService.StreamingMode mode = IDataServiceClientService.StreamingMode.ROW_BASED.toString().equalsIgnoreCase(this.windowMode) ? IDataServiceClientService.StreamingMode.ROW_BASED : IDataServiceClientService.StreamingMode.TIME_BASED;
        return new SQLStreamingReportDataFactory(connection.getInitializedConnectionProvider(parameterDataRow, CdaEngine.getEnvironment().getFormulaContext()), mode, this.windowSize, this.windowEvery, this.windowLimit);
    }

    @Override
    public String getType() {
        return TYPE.getType();
    }

    @Override
    public String getLabel() {
        return TYPE.getLabel();
    }

    @Override
    public List<PropertyDescriptor> getInterface() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(new PropertyDescriptor("id", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.ATTRIB));
        properties.add(new PropertyDescriptor("access", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.ATTRIB));
        properties.add(new PropertyDescriptor("parameters", PropertyDescriptor.Type.ARRAY, PropertyDescriptor.Placement.CHILD));
        properties.add(new PropertyDescriptor("output", PropertyDescriptor.Type.ARRAY, PropertyDescriptor.Placement.CHILD));
        properties.add(new PropertyDescriptor("columns", PropertyDescriptor.Type.ARRAY, PropertyDescriptor.Placement.CHILD));
        properties.add(new PropertyDescriptor("dataServiceQuery", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        properties.add(new PropertyDescriptor("connection", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.ATTRIB));
        properties.add(new PropertyDescriptor("streamingDataServiceName", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        properties.add(new PropertyDescriptor("windowMode", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        properties.add(new PropertyDescriptor("windowSize", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        properties.add(new PropertyDescriptor("windowEvery", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        properties.add(new PropertyDescriptor("windowLimit", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        return properties;
    }

    @Override
    public void accept(DomVisitor xmlVisitor, Element root) {
        xmlVisitor.visit(this, root);
    }

    @Override
    public ConnectionCatalog.ConnectionType getConnectionType() {
        return ConnectionCatalog.ConnectionType.DATASERVICES;
    }

    @Override
    public void doPushStreamQuery(QueryOptions queryOptions, Observer<List<RowMetaAndData>> consumer) throws QueryException {
        this.performStreamingRawQuery(queryOptions, consumer);
    }

    private void performStreamingRawQuery(QueryOptions queryOptions, Observer<List<RowMetaAndData>> consumer) throws QueryException {
        try {
            List<Parameter> parameters = this.getFilledParameters(queryOptions);
            ParameterDataRow parameterDataRow = Parameter.createParameterDataRowFromParameters(parameters);
            this.performStreamingRawQuery(parameterDataRow, consumer);
        }
        catch (InvalidParameterException e) {
            throw new QueryException("Error parsing parameters ", e);
        }
    }

    protected void performStreamingRawQuery(ParameterDataRow parameterDataRow, Observer<List<RowMetaAndData>> consumer) throws QueryException {
        String query = this.getQuery();
        try {
            DataservicesConnection conn = this.getConnection();
            PushStreamAndSQLReportDataFactory dataFactory = this.getDataFactory(conn, parameterDataRow);
            dataFactory.performPushQuery(query, parameterDataRow, consumer);
        }
        catch (Exception e) {
            throw new QueryException(e.getLocalizedMessage(), e);
        }
    }

    protected PushStreamAndSQLReportDataFactory getDataFactory(DataservicesConnection connection, ParameterDataRow parameterDataRow) throws InvalidConnectionException {
        return new PushStreamAndSQLReportDataFactory(connection.getInitializedConnectionProvider(parameterDataRow, CdaEngine.getEnvironment().getFormulaContext()), this.getStreamingParams());
    }

    protected IDataServiceClientService.IStreamingParams getStreamingParams() {
        return new StreamingParams(this.windowMode, this.windowSize, this.windowEvery, this.windowLimit);
    }

    protected DataservicesConnection getConnection() throws UnknownConnectionException {
        return (DataservicesConnection)this.getCdaSettings().getConnection(this.getConnectionId());
    }

    protected class PushStreamAndSQLReportDataFactory
    extends SQLStreamingReportDataFactory {
        private static final long serialVersionUID = 1L;
        private IDataServiceClientService.IStreamingParams streamingParams;

        public PushStreamAndSQLReportDataFactory(ConnectionProvider connectionProvider, IDataServiceClientService.IStreamingParams params) {
            super(connectionProvider, params.getWindowMode(), params.getWindowSize(), params.getWindowEvery(), params.getWindowLimit());
            this.streamingParams = params;
        }

        private IDataServiceClientService.IStreamingParams getStreamingParams() {
            return this.streamingParams;
        }

        private <T> T unwrap(Wrapper stmt, Class<T> wrapped) throws Exception {
            if (stmt.isWrapperFor(wrapped)) {
                return stmt.unwrap(wrapped);
            }
            throw new Exception(String.format("Failed to unwrap '%s' from '$s'", wrapped, stmt));
        }

        public void performPushQuery(String query, ParameterDataRow parameters, Observer<List<RowMetaAndData>> consumer) throws Exception {
            Connection connection = this.getConnectionProvider().createConnection(null, null);
            ParametrizationProvider paramProvider = this.getParamProviderFactory().create(connection);
            String translatedQuery = paramProvider.rewriteQueryForParametrization(connection, query, (DataRow)parameters);
            String[] orderedNames = paramProvider.getPreparedParameterNames();
            if (orderedNames.length > 0) {
                PreparedStatement pstmt = connection.prepareStatement(translatedQuery);
                for (int i = 0; i < orderedNames.length; ++i) {
                    pstmt.setObject(i + 1, parameters.get(orderedNames[i]));
                }
                IThinPreparedStatement thinStmt = this.unwrap(pstmt, IThinPreparedStatement.class);
                thinStmt.executePushQuery(this.getStreamingParams(), consumer);
            } else {
                Statement stmt = connection.createStatement();
                IThinStatement thinStmt = this.unwrap(stmt, IThinStatement.class);
                thinStmt.executePushQuery(query, this.getStreamingParams(), consumer);
            }
        }

        private ParametrizationProviderFactory getParamProviderFactory() {
            return new DefaultParametrizationProviderFactory();
        }
    }

    protected static class StreamingParams
    implements IDataServiceClientService.IStreamingParams {
        private long windowSize;
        private long windowEvery;
        private long windowLimit;
        private IDataServiceClientService.StreamingMode windowMode;

        public StreamingParams(IDataServiceClientService.StreamingMode windowMode, long windowSize, long windowEvery, long windowLimit) {
            this.windowMode = windowMode;
            this.windowEvery = windowEvery;
            this.windowLimit = windowLimit;
            this.windowSize = windowSize;
        }

        public StreamingParams(String windowMode, long windowSize, long windowEvery, long windowLimit) {
            this.windowMode = IDataServiceClientService.StreamingMode.valueOf((String)windowMode);
            this.windowEvery = windowEvery;
            this.windowLimit = windowLimit;
            this.windowSize = windowSize;
        }

        public IDataServiceClientService.StreamingMode getWindowMode() {
            return this.windowMode;
        }

        public long getWindowSize() {
            return this.windowSize;
        }

        public long getWindowEvery() {
            return this.windowEvery;
        }

        public long getWindowLimit() {
            return this.windowLimit;
        }
    }
}

