/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.dataaccess;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.swing.table.TableModel;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.cache.IQueryCache;
import pt.webdetails.cda.cache.TableCacheKey;
import pt.webdetails.cda.cache.monitor.ExtraCacheInfo;
import pt.webdetails.cda.connections.Connection;
import pt.webdetails.cda.connections.ConnectionCatalog;
import pt.webdetails.cda.connections.DummyConnection;
import pt.webdetails.cda.dataaccess.AbstractDataAccess;
import pt.webdetails.cda.dataaccess.InvalidParameterException;
import pt.webdetails.cda.dataaccess.Parameter;
import pt.webdetails.cda.dataaccess.PropertyDescriptor;
import pt.webdetails.cda.dataaccess.QueryException;
import pt.webdetails.cda.events.CdaEvent;
import pt.webdetails.cda.events.QueryErrorEvent;
import pt.webdetails.cda.events.QueryTooLongEvent;
import pt.webdetails.cda.query.QueryOptions;
import pt.webdetails.cda.settings.UnknownConnectionException;
import pt.webdetails.cda.utils.TableModelUtils;
import pt.webdetails.cda.xml.DomVisitable;
import pt.webdetails.cda.xml.DomVisitor;
import pt.webdetails.cpf.messaging.IEventPublisher;
import pt.webdetails.cpf.messaging.PluginEvent;

public abstract class SimpleDataAccess
extends AbstractDataAccess
implements DomVisitable {
    private static final Log logger = LogFactory.getLog(SimpleDataAccess.class);
    protected String connectionId;
    protected String query;
    protected String queryType;
    private IEventPublisher eventPublisher;
    private static final String QUERY_TIME_THRESHOLD_PROPERTY = "pt.webdetails.cda.QueryTimeThreshold";
    private static int queryTimeThreshold = SimpleDataAccess.getQueryTimeThresholdFromConfig(3600);

    public SimpleDataAccess() {
        this.eventPublisher = CdaEngine.getEnvironment().getEventPublisher();
    }

    public SimpleDataAccess(Element element) {
        super(element);
        this.connectionId = element.attributeValue("connection");
        this.query = element.selectSingleNode("./Query") != null ? element.selectSingleNode("./Query").getText() : null;
        this.eventPublisher = CdaEngine.getEnvironment().getEventPublisher();
        this.queryType = element.attributeValue("type");
    }

    public SimpleDataAccess(String id, String name, String connectionId, String query) {
        super(id, name);
        this.query = query;
        this.connectionId = connectionId;
        this.eventPublisher = CdaEngine.getEnvironment().getEventPublisher();
    }

    public SimpleDataAccess(String id, String name, String connectionId, String query, String queryType) {
        super(id, name);
        this.query = query;
        this.connectionId = connectionId;
        this.eventPublisher = CdaEngine.getEnvironment().getEventPublisher();
        this.queryType = queryType;
    }

    @Override
    protected TableModel queryDataSource(QueryOptions queryOptions) throws QueryException {
        TableModel tableModelCopy;
        TableCacheKey key;
        ParameterDataRow parameterDataRow;
        List<Parameter> parameters = this.getFilledParameters(queryOptions);
        try {
            parameterDataRow = Parameter.createParameterDataRowFromParameters(parameters);
        }
        catch (InvalidParameterException e) {
            throw new QueryException("Error parsing parameters ", e);
        }
        IDataSourceQuery rawQueryExecution = null;
        Long queryTime = null;
        try {
            key = this.createCacheKey(parameters);
            if (this.isCacheEnabled() && !queryOptions.isCacheBypass()) {
                try {
                    TableModel cachedTableModel = SimpleDataAccess.getCdaCache().getTableModel(key);
                    if (cachedTableModel != null) {
                        logger.debug((Object)"Found table in cache, returning.");
                        TableModel tableModel = cachedTableModel;
                        return tableModel;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("Error while attempting to load from cache, bypassing cache (cause: " + e.getClass() + ")"), (Throwable)e);
                }
            }
            long beginTime = System.currentTimeMillis();
            rawQueryExecution = this.performRawQuery(parameterDataRow);
            TableModel tableModel = this.postProcessTableModel(rawQueryExecution.getTableModel());
            queryTime = this.logIfDurationAboveThreshold(beginTime, this.getId(), this.getQuery(), parameters);
            tableModelCopy = TableModelUtils.copyTableModel(this, tableModel);
        }
        catch (Exception e) {
            try {
                CdaEvent.QueryInfo info = new CdaEvent.QueryInfo(this.getCdaSettings().getId(), this.getId(), this.getQuery(), parameterDataRow);
                if (e instanceof QueryException && e.getCause() != null) {
                    this.eventPublisher.publish((PluginEvent)new QueryErrorEvent(info, e.getCause()));
                } else {
                    this.eventPublisher.publish((PluginEvent)new QueryErrorEvent(info, e));
                }
            }
            catch (Exception inner) {
                logger.error((Object)"Error pushing event", (Throwable)inner);
            }
            if (e instanceof QueryException) {
                throw (QueryException)e;
            }
            throw new QueryException("Found an unhandled exception:", e);
        }
        finally {
            if (rawQueryExecution != null) {
                rawQueryExecution.closeDataSource();
            }
        }
        if (this.isCacheEnabled()) {
            ExtraCacheInfo cInfo = new ExtraCacheInfo(this.getCdaSettings().getId(), this.getId(), queryTime, tableModelCopy);
            IQueryCache cache = SimpleDataAccess.getCdaCache();
            if (cache != null) {
                cache.putTableModel(key, tableModelCopy, this.getCacheDuration(), cInfo);
            } else {
                logger.error((Object)"Cache enabled but no cache available.");
            }
        }
        return tableModelCopy;
    }

    public List<Parameter> getFilledParameters(QueryOptions queryOptions) throws QueryException {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>(this.getParameters().size());
        for (Parameter param : this.getParameters()) {
            parameters.add(new Parameter(param));
        }
        for (Parameter parameter : parameters) {
            Parameter parameterPassed = queryOptions.getParameter(parameter.getName());
            try {
                if (parameter.getAccess().equals((Object)Parameter.Access.PUBLIC) && parameterPassed != null) {
                    parameterPassed.inheritDefaults(parameter);
                    parameter.setValue(parameterPassed.getValue());
                    continue;
                }
                parameter.setValue(parameter.getValue());
            }
            catch (InvalidParameterException e) {
                throw new QueryException("Error parsing parameters ", e);
            }
        }
        return parameters;
    }

    protected TableCacheKey createCacheKey(List<Parameter> parameters) throws QueryException {
        try {
            Connection connection = this.getConnectionType() == ConnectionCatalog.ConnectionType.NONE ? new DummyConnection() : this.getCdaSettings().getConnection(this.getConnectionId());
            return new TableCacheKey(connection, this.getQuery(), this.getQueryType(), parameters, this.getExtraCacheKey());
        }
        catch (UnknownConnectionException e) {
            throw new QueryException("Unable to get a Connection for this dataAccess ", e);
        }
    }

    private long logIfDurationAboveThreshold(long beginTime, String queryId, String query, List<Parameter> parameters) {
        long endTime = System.currentTimeMillis();
        long duration = (endTime - beginTime) / 1000L;
        if (duration > (long)queryTimeThreshold) {
            try {
                this.eventPublisher.publish((PluginEvent)new QueryTooLongEvent(new CdaEvent.QueryInfo(this.getCdaSettings().getId(), queryId, query, Parameter.createParameterDataRowFromParameters(parameters)), duration));
            }
            catch (Exception e) {
                logger.error((Object)"Error pushing event", (Throwable)e);
            }
            String logMsg = "Query " + queryId + " took " + duration + "s.\n";
            logMsg = logMsg + "\t Query contents: << " + query.trim() + " >>\n";
            if (parameters.size() > 0) {
                logMsg = logMsg + "\t Parameters: \n";
                for (Parameter parameter : parameters) {
                    logMsg = logMsg + "\t\t" + parameter.toString() + "\n";
                }
            }
            logger.warn((Object)logMsg);
        }
        return duration;
    }

    protected TableModel postProcessTableModel(TableModel tm) {
        return tm;
    }

    protected abstract IDataSourceQuery performRawQuery(ParameterDataRow var1) throws QueryException;

    public String getQuery() {
        return this.query;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public String getQueryType() {
        return this.queryType;
    }

    @Override
    public List<PropertyDescriptor> getInterface() {
        List<PropertyDescriptor> properties = super.getInterface();
        properties.add(new PropertyDescriptor("query", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        properties.add(new PropertyDescriptor("connection", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.ATTRIB));
        properties.add(new PropertyDescriptor("cache", PropertyDescriptor.Type.BOOLEAN, PropertyDescriptor.Placement.CHILD));
        properties.add(new PropertyDescriptor("cacheDuration", PropertyDescriptor.Type.NUMERIC, PropertyDescriptor.Placement.ATTRIB));
        properties.add(new PropertyDescriptor("cacheKeys", PropertyDescriptor.Type.ARRAY, PropertyDescriptor.Placement.CHILD));
        return properties;
    }

    private static int getQueryTimeThresholdFromConfig(int defaultValue) {
        String strVal = CdaEngine.getInstance().getConfigProperty(QUERY_TIME_THRESHOLD_PROPERTY);
        if (!StringUtils.isEmpty((String)strVal)) {
            try {
                return Integer.parseInt(strVal);
            }
            catch (NumberFormatException nfe) {
                logger.warn((Object)MessageFormat.format("Could not parse {0} in property {1}, using default {2}.", strVal, QUERY_TIME_THRESHOLD_PROPERTY, defaultValue));
            }
        }
        return defaultValue;
    }

    @Override
    public void accept(DomVisitor xmlVisitor, Element root) {
        xmlVisitor.visit(this, root);
    }

    @Override
    public void setQuery(String query) {
        this.query = query;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    protected <T> T parseNode(Element element, String nodePath, Function<String, T> parse, T defaultValue) {
        try {
            return Optional.ofNullable(element.selectSingleNode(nodePath)).map(Node::getText).map(parse).orElse(defaultValue);
        }
        catch (Exception e) {
            logger.error((Object)(" parse error in " + this.getName() + ": " + e.getMessage()));
            return defaultValue;
        }
    }

    public static interface IDataSourceQuery {
        public TableModel getTableModel();

        public void closeDataSource() throws QueryException;
    }
}

