/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.dataaccess;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.AbstractNamedMDXDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.olap4j.BandedMDXDataFactory;
import pt.webdetails.cda.connections.ConnectionCatalog;
import pt.webdetails.cda.connections.InvalidConnectionException;
import pt.webdetails.cda.connections.olap4j.Olap4JConnection;
import pt.webdetails.cda.dataaccess.PREDataAccess;
import pt.webdetails.cda.settings.UnknownConnectionException;

public class Olap4JDataAccess
extends PREDataAccess {
    private static final Log logger = LogFactory.getLog(Olap4JDataAccess.class);

    public Olap4JDataAccess(Element element) {
        super(element);
    }

    public Olap4JDataAccess() {
    }

    protected AbstractNamedMDXDataFactory createDataFactory() throws UnknownConnectionException, InvalidConnectionException {
        Olap4JConnection connection = (Olap4JConnection)this.getCdaSettings().getConnection(this.getConnectionId());
        return new BandedMDXDataFactory(connection.getInitializedConnectionProvider());
    }

    @Override
    public DataFactory getDataFactory() throws UnknownConnectionException, InvalidConnectionException {
        logger.debug((Object)"Creating BandedMDXDataFactory");
        Olap4JConnection connection = (Olap4JConnection)this.getCdaSettings().getConnection(this.getConnectionId());
        AbstractNamedMDXDataFactory mdxDataFactory = this.createDataFactory();
        mdxDataFactory.setQuery("query", this.getQuery());
        mdxDataFactory.setJdbcPasswordField(connection.getPasswordField());
        mdxDataFactory.setJdbcUserField(connection.getUserField());
        mdxDataFactory.setRoleField(connection.getRoleField());
        return mdxDataFactory;
    }

    @Override
    public String getType() {
        return "olap4j";
    }

    @Override
    public ConnectionCatalog.ConnectionType getConnectionType() {
        return ConnectionCatalog.ConnectionType.OLAP4J;
    }
}

