/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.dataaccess;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.AbstractNamedMDXDataFactory;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.cache.CacheKey;
import pt.webdetails.cda.connections.mondrian.AbstractMondrianConnection;
import pt.webdetails.cda.connections.mondrian.MondrianConnectionInfo;
import pt.webdetails.cda.dataaccess.GlobalMdxDataAccess;
import pt.webdetails.cda.dataaccess.PropertyDescriptor;
import pt.webdetails.cda.utils.mondrian.CompactBandedMDXDataFactory;
import pt.webdetails.cda.utils.mondrian.ExtBandedMDXDataFactory;

public class MdxDataAccess
extends GlobalMdxDataAccess {
    private static final Log logger = LogFactory.getLog(MdxDataAccess.class);
    private BANDED_MODE bandedMode = BANDED_MODE.CLASSIC;

    public MdxDataAccess(String id, String name, String connectionId, String query) {
        super(id, name, connectionId, query);
        try {
            String _mode = CdaEngine.getInstance().getConfigProperty("pt.webdetails.cda.BandedMDXMode");
            if (_mode != null) {
                this.bandedMode = BANDED_MODE.valueOf(_mode);
            }
        }
        catch (Exception ex) {
            this.bandedMode = BANDED_MODE.COMPACT;
        }
    }

    public MdxDataAccess(Element element) {
        super(element);
        try {
            this.bandedMode = BANDED_MODE.valueOf(element.selectSingleNode("./BandedMode").getText().toUpperCase());
        }
        catch (Exception e) {
            try {
                String _mode = CdaEngine.getInstance().getConfigProperty("pt.webdetails.cda.BandedMDXMode");
                if (_mode != null) {
                    this.bandedMode = BANDED_MODE.valueOf(_mode);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public MdxDataAccess() {
    }

    @Override
    protected AbstractNamedMDXDataFactory createDataFactory() {
        if (this.getBandedMode() == BANDED_MODE.CLASSIC) {
            return new ExtBandedMDXDataFactory();
        }
        return new CompactBandedMDXDataFactory();
    }

    public BANDED_MODE getBandedMode() {
        return this.bandedMode;
    }

    @Override
    public String getType() {
        return "mdx";
    }

    @Override
    public List<PropertyDescriptor> getInterface() {
        List<PropertyDescriptor> properties = super.getInterface();
        properties.add(new PropertyDescriptor("bandedMode", PropertyDescriptor.Type.STRING, PropertyDescriptor.Placement.CHILD));
        return properties;
    }

    @Override
    protected Serializable getExtraCacheKey() {
        MondrianConnectionInfo mci;
        try {
            mci = ((AbstractMondrianConnection)this.getCdaSettings().getConnection(this.getConnectionId())).getConnectionInfo();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get a connection info for cache key");
            mci = null;
        }
        CacheKey cacheKey = this.getCacheKey() != null ? ((CacheKey)this.getCacheKey()).clone() : new CacheKey();
        cacheKey.addKeyValuePair("bandedMode", this.bandedMode.toString());
        cacheKey.addKeyValuePair("mondrianRole", mci.getMondrianRole());
        return cacheKey;
    }

    protected static class ExtraCacheKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private BANDED_MODE bandedMode;
        private String roles;

        public ExtraCacheKey(BANDED_MODE bandedMode, String roles) {
            this.bandedMode = bandedMode;
            this.roles = roles;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExtraCacheKey other = (ExtraCacheKey)obj;
            if (!(this.bandedMode == other.bandedMode || this.bandedMode != null && this.bandedMode.equals((Object)other.bandedMode))) {
                return false;
            }
            return !(this.roles == null ? other.roles != null : !this.roles.equals(other.roles));
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.bandedMode = (BANDED_MODE)((Object)in.readObject());
            this.roles = (String)in.readObject();
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject((Object)this.bandedMode);
            out.writeObject(this.roles);
        }

        public int hashCode() {
            int hash = 7;
            hash = 83 * hash + (this.bandedMode != null ? this.bandedMode.hashCode() : 0);
            hash = 83 * hash + (this.roles != null ? this.roles.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return this.getClass().getName() + "[bandedMode: " + (Object)((Object)this.bandedMode) + "; roles:" + this.roles + "]";
        }
    }

    public static enum BANDED_MODE {
        CLASSIC,
        COMPACT;

    }
}

