/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cda.dataaccess;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleDataFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import pt.webdetails.cda.CdaEngine;
import pt.webdetails.cda.cache.CacheKey;
import pt.webdetails.cda.connections.ConnectionCatalog;
import pt.webdetails.cda.connections.InvalidConnectionException;
import pt.webdetails.cda.connections.kettle.KettleConnection;
import pt.webdetails.cda.dataaccess.PREDataAccess;
import pt.webdetails.cda.dataaccess.Parameter;
import pt.webdetails.cda.dataaccess.QueryException;
import pt.webdetails.cda.dataaccess.SimpleDataAccess;
import pt.webdetails.cda.settings.CdaSettings;
import pt.webdetails.cda.settings.UnknownConnectionException;
import pt.webdetails.cda.utils.ParameterArrayToStringEncoder;

public class KettleDataAccess
extends PREDataAccess {
    private String path;
    private static final String PARAMETER_KETTLE_SEPARATOR = "pt.webdetails.cda.dataaccess.parameterarray.kettle.Separator";
    private static final String PARAMETER_KETTLE_QUOTE = "pt.webdetails.cda.dataaccess.parameterarray.kettle.Quote";

    public KettleDataAccess(Element element) {
        super(element);
    }

    public KettleDataAccess() {
    }

    @Override
    public DataFactory getDataFactory() throws UnknownConnectionException, InvalidConnectionException {
        KettleConnection connection = (KettleConnection)this.getCdaSettings().getConnection(this.getConnectionId());
        KettleDataFactory dataFactory = new KettleDataFactory();
        dataFactory.setQuery("query", connection.createTransformationProducer(this.getQuery(), this.getCdaSettings()));
        return dataFactory;
    }

    @Override
    public String getType() {
        return "kettle";
    }

    @Override
    public ConnectionCatalog.ConnectionType getConnectionType() {
        return ConnectionCatalog.ConnectionType.KETTLE;
    }

    @Override
    public void setCdaSettings(CdaSettings cdaSettings) {
        super.setCdaSettings(cdaSettings);
        ResourceManager resourceManager = CdaEngine.getInstance().getSettingsManager().getResourceManager();
        try {
            ResourceKey fileKey = resourceManager.deriveKey(this.getCdaSettings().getContextKey(), "");
            this.path = fileKey.getIdentifierAsString();
        }
        catch (ResourceKeyCreationException e) {
            this.path = null;
        }
    }

    @Override
    public Serializable getExtraCacheKey() {
        CacheKey cacheKey = this.getCacheKey() != null ? ((CacheKey)this.getCacheKey()).clone() : new CacheKey();
        cacheKey.addKeyValuePair("path", this.path);
        return cacheKey;
    }

    private String getSeparator() {
        String stringSeparator = CdaEngine.getInstance().getConfigProperty(PARAMETER_KETTLE_SEPARATOR);
        if (StringUtils.isEmpty((String)stringSeparator)) {
            stringSeparator = ";";
        }
        return stringSeparator;
    }

    private String getQuoteCharacter() {
        String stringQuote = CdaEngine.getInstance().getConfigProperty(PARAMETER_KETTLE_QUOTE);
        if (StringUtils.isEmpty((String)stringQuote)) {
            stringQuote = "\"";
        }
        return stringQuote;
    }

    @Override
    protected SimpleDataAccess.IDataSourceQuery performRawQuery(ParameterDataRow parameterDataRow) throws QueryException {
        if (this.getParameters().size() == 0) {
            return super.performRawQuery(parameterDataRow);
        }
        ArrayList<Parameter> parameters = this.getParameters();
        String[] columnNames = parameterDataRow.getColumnNames();
        Object[] values = new Object[columnNames.length];
        for (int i = 0; i < parameters.size(); ++i) {
            Object value;
            Parameter parameter = (Parameter)parameters.get(i);
            if (parameter.getType() == Parameter.Type.STRING_ARRAY || parameter.getType() == Parameter.Type.INTEGER_ARRAY || parameter.getType() == Parameter.Type.NUMERIC_ARRAY || parameter.getType() == Parameter.Type.DATE_ARRAY) {
                ParameterArrayToStringEncoder encoder = new ParameterArrayToStringEncoder(this.getSeparator(), this.getQuoteCharacter());
                value = encoder.encodeParameterArray(parameterDataRow.get(columnNames[i]), parameter.getType());
            } else {
                value = parameterDataRow.get(columnNames[i]);
            }
            values[i] = value;
        }
        return super.performRawQuery(new ParameterDataRow(columnNames, values));
    }
}

